/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import javax.activation.CommandInfo;
import javax.activation.CommandMap;
import javax.activation.DataContentHandler;
import javax.activation.DataContentHandlerFactory;
import javax.activation.DataHandlerDataSource;
import javax.activation.DataSource;
import javax.activation.DataSourceDataContentHandler;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.activation.ObjectDataContentHandler;
import javax.activation.SecuritySupport;
import javax.activation.URLDataSource;
import javax.activation.UnsupportedDataTypeException;

public class DataHandler
implements Transferable {
    private DataSource dataSource = null;
    private DataSource objDataSource = null;
    private Object object = null;
    private String objectMimeType = null;
    private CommandMap currentCommandMap = null;
    private static final DataFlavor[] emptyFlavors = new DataFlavor[0];
    private DataFlavor[] transferFlavors = emptyFlavors;
    private DataContentHandler dataContentHandler = null;
    private DataContentHandler factoryDCH = null;
    private static DataContentHandlerFactory factory = null;
    private DataContentHandlerFactory oldFactory = null;
    private String shortType = null;

    public DataHandler(DataSource dataSource) {
        this.dataSource = dataSource;
        this.oldFactory = factory;
    }

    public DataHandler(Object object, String string) {
        this.object = object;
        this.objectMimeType = string;
        this.oldFactory = factory;
    }

    public DataHandler(URL uRL) {
        this.dataSource = new URLDataSource(uRL);
        this.oldFactory = factory;
    }

    private synchronized CommandMap getCommandMap() {
        if (this.currentCommandMap != null) {
            return this.currentCommandMap;
        }
        return CommandMap.getDefaultCommandMap();
    }

    public DataSource getDataSource() {
        if (this.dataSource == null) {
            if (this.objDataSource == null) {
                this.objDataSource = new DataHandlerDataSource(this);
            }
            return this.objDataSource;
        }
        return this.dataSource;
    }

    public String getName() {
        if (this.dataSource != null) {
            return this.dataSource.getName();
        }
        return null;
    }

    public String getContentType() {
        if (this.dataSource != null) {
            return this.dataSource.getContentType();
        }
        return this.objectMimeType;
    }

    public InputStream getInputStream() throws IOException {
        InputStream inputStream = null;
        if (this.dataSource != null) {
            inputStream = this.dataSource.getInputStream();
        } else {
            DataContentHandler dataContentHandler = this.getDataContentHandler();
            if (dataContentHandler == null) {
                throw new UnsupportedDataTypeException("no DCH for MIME type " + this.getBaseType());
            }
            if (dataContentHandler instanceof ObjectDataContentHandler && ((ObjectDataContentHandler)dataContentHandler).getDCH() == null) {
                throw new UnsupportedDataTypeException("no object DCH for MIME type " + this.getBaseType());
            }
            final DataContentHandler dataContentHandler2 = dataContentHandler;
            final PipedOutputStream pipedOutputStream = new PipedOutputStream();
            PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        dataContentHandler2.writeTo(DataHandler.this.object, DataHandler.this.objectMimeType, pipedOutputStream);
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        try {
                            pipedOutputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }, "DataHandler.getInputStream").start();
            inputStream = pipedInputStream;
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outputStream) throws IOException {
        if (this.dataSource != null) {
            InputStream inputStream = null;
            byte[] byArray = new byte[8192];
            inputStream = this.dataSource.getInputStream();
            try {
                int n;
                while ((n = inputStream.read(byArray)) > 0) {
                    outputStream.write(byArray, 0, n);
                }
            }
            finally {
                inputStream.close();
                inputStream = null;
            }
        } else {
            DataContentHandler dataContentHandler = this.getDataContentHandler();
            dataContentHandler.writeTo(this.object, this.objectMimeType, outputStream);
        }
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.dataSource != null) {
            return this.dataSource.getOutputStream();
        }
        return null;
    }

    @Override
    public synchronized DataFlavor[] getTransferDataFlavors() {
        if (factory != this.oldFactory) {
            this.transferFlavors = emptyFlavors;
        }
        if (this.transferFlavors == emptyFlavors) {
            this.transferFlavors = this.getDataContentHandler().getTransferDataFlavors();
        }
        if (this.transferFlavors == emptyFlavors) {
            return this.transferFlavors;
        }
        return (DataFlavor[])this.transferFlavors.clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavorArray[i].equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        return this.getDataContentHandler().getTransferData(dataFlavor, this.dataSource);
    }

    public synchronized void setCommandMap(CommandMap commandMap) {
        if (commandMap != this.currentCommandMap || commandMap == null) {
            this.transferFlavors = emptyFlavors;
            this.dataContentHandler = null;
            this.currentCommandMap = commandMap;
        }
    }

    public CommandInfo[] getPreferredCommands() {
        if (this.dataSource != null) {
            return this.getCommandMap().getPreferredCommands(this.getBaseType(), this.dataSource);
        }
        return this.getCommandMap().getPreferredCommands(this.getBaseType());
    }

    public CommandInfo[] getAllCommands() {
        if (this.dataSource != null) {
            return this.getCommandMap().getAllCommands(this.getBaseType(), this.dataSource);
        }
        return this.getCommandMap().getAllCommands(this.getBaseType());
    }

    public CommandInfo getCommand(String string) {
        if (this.dataSource != null) {
            return this.getCommandMap().getCommand(this.getBaseType(), string, this.dataSource);
        }
        return this.getCommandMap().getCommand(this.getBaseType(), string);
    }

    public Object getContent() throws IOException {
        if (this.object != null) {
            return this.object;
        }
        return this.getDataContentHandler().getContent(this.getDataSource());
    }

    public Object getBean(CommandInfo commandInfo) {
        Object object = null;
        try {
            ClassLoader classLoader = null;
            classLoader = SecuritySupport.getContextClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            object = commandInfo.getCommandObject(this, classLoader);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return object;
    }

    private synchronized DataContentHandler getDataContentHandler() {
        if (factory != this.oldFactory) {
            this.oldFactory = factory;
            this.factoryDCH = null;
            this.dataContentHandler = null;
            this.transferFlavors = emptyFlavors;
        }
        if (this.dataContentHandler != null) {
            return this.dataContentHandler;
        }
        String string = this.getBaseType();
        if (this.factoryDCH == null && factory != null) {
            this.factoryDCH = factory.createDataContentHandler(string);
        }
        if (this.factoryDCH != null) {
            this.dataContentHandler = this.factoryDCH;
        }
        if (this.dataContentHandler == null) {
            this.dataContentHandler = this.dataSource != null ? this.getCommandMap().createDataContentHandler(string, this.dataSource) : this.getCommandMap().createDataContentHandler(string);
        }
        this.dataContentHandler = this.dataSource != null ? new DataSourceDataContentHandler(this.dataContentHandler, this.dataSource) : new ObjectDataContentHandler(this.dataContentHandler, this.object, this.objectMimeType);
        return this.dataContentHandler;
    }

    private synchronized String getBaseType() {
        if (this.shortType == null) {
            String string = this.getContentType();
            try {
                MimeType mimeType = new MimeType(string);
                this.shortType = mimeType.getBaseType();
            }
            catch (MimeTypeParseException mimeTypeParseException) {
                this.shortType = string;
            }
        }
        return this.shortType;
    }

    public static synchronized void setDataContentHandlerFactory(DataContentHandlerFactory dataContentHandlerFactory) {
        block4: {
            if (factory != null) {
                throw new Error("DataContentHandlerFactory already defined");
            }
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    securityManager.checkSetFactory();
                }
                catch (SecurityException securityException) {
                    if (DataHandler.class.getClassLoader() == dataContentHandlerFactory.getClass().getClassLoader()) break block4;
                    throw securityException;
                }
            }
        }
        factory = dataContentHandlerFactory;
    }
}

