/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.world.client;

import aroma1997.world.CommonProxy;
import aroma1997.world.Config;
import aroma1997.world.DimensionalWorldItems;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    private Config worldConfig;

    @Override
    public void setConfig(Config config) {
        this.reregisterDimension(this.worldConfig == null ? 0 : this.worldConfig.dimensionid, config.dimensionid, DimensionalWorldItems.dimensionType);
        this.reregisterDimension(this.worldConfig == null ? 0 : this.worldConfig.dimensionidSphere, config.dimensionidSphere, DimensionalWorldItems.dimensionTypeSphere);
        this.worldConfig = config;
        config.onReload();
    }

    private void reregisterDimension(int oldDimension, int newDimension, DimensionType type) {
        boolean hashChanged;
        if (oldDimension != 0) {
            boolean bl = hashChanged = newDimension != oldDimension;
            if (hashChanged && DimensionManager.isDimensionRegistered((int)oldDimension)) {
                DimensionManager.unregisterDimension((int)oldDimension);
            }
        } else {
            hashChanged = true;
        }
        if (hashChanged) {
            DimensionManager.registerDimension((int)newDimension, (DimensionType)type);
        }
    }

    @Override
    public Config getWorldConfig() {
        return this.worldConfig;
    }

    @Override
    public void serverStarted() {
        this.setConfig(Config.INSTANCE);
    }
}

