/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.world.item;

import aroma1997.core.block.AromicBlockMulti;
import aroma1997.core.misc.TeleporterNormal;
import aroma1997.core.util.WorldUtil;
import aroma1997.world.dimension.TeleporterMining;
import aroma1997.world.item.BlockPortalFrame;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMiningPortal
extends AromicBlockMulti<EnumFacing.Axis> {
    protected static final AxisAlignedBB X_AABB = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    protected static final AxisAlignedBB Z_AABB = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
    protected static final AxisAlignedBB Y_AABB = new AxisAlignedBB(0.0, 0.375, 0.0, 1.0, 0.625, 1.0);
    private BlockPortalFrame frameBlock;

    public BlockMiningPortal() {
        super(Material.field_151567_E, EnumFacing.Axis.class);
        this.func_149722_s();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing.Axis)state.func_177229_b((IProperty)this.property)) {
            case X: {
                return X_AABB;
            }
            default: {
                return Y_AABB;
            }
            case Z: 
        }
        return Z_AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos neighborPos) {
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b((IProperty)this.property);
        PortalSize size = new PortalSize(world, pos, axis);
        if (!size.isValidPortal()) {
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (world.field_72995_K) {
            return;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        int targetDimentsion = this.getTargetDimension(entity.field_71093_bK);
        PortalSize size = this.getFirstValidPortralSize(world, pos);
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (player.func_70093_af() && entity.field_71088_bW == 0) {
                player.func_70095_a(false);
                entity.field_71088_bW = 40;
                if (server != null) {
                    TeleporterNormal.teleportToDimension((Entity)entity, (MinecraftServer)server, (int)targetDimentsion, (Teleporter)new TeleporterMining(size, server.func_71218_a(targetDimentsion)));
                }
            }
        } else if (entity.field_71088_bW == 0 && !world.field_72995_K) {
            entity.field_71088_bW = 2;
            TeleporterNormal.teleportToDimension((Entity)entity, (MinecraftServer)server, (int)targetDimentsion, (Teleporter)new TeleporterMining(size, server.func_71218_a(targetDimentsion)));
        } else if (entity.field_71088_bW > 0 && !world.field_72995_K) {
            entity.field_71088_bW = 2;
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public Block getFrameBlock() {
        return this.frameBlock;
    }

    void setFrameBlock(BlockPortalFrame block) {
        this.frameBlock = block;
    }

    public int getTargetDimension(int currentDimension) {
        if (currentDimension != this.getAlternateDimension()) {
            return this.getAlternateDimension();
        }
        return 0;
    }

    public PortalSize getFirstValidPortralSize(World world, BlockPos pos) {
        EnumFacing.Axis axis;
        PortalSize size = null;
        EnumFacing.Axis[] axisArray = EnumFacing.Axis.values();
        int n = axisArray.length;
        for (int i = 0; i < n && !(size = new PortalSize(world, pos, axis = axisArray[i])).isValid(); ++i) {
        }
        return size;
    }

    public int getAlternateDimension() {
        return this.frameBlock.getAlternateDimension();
    }

    public class PortalSize {
        private static final int MAX_HEIGHT = 21;
        private static final int MAX_WIDTH = 21;
        private static final int MIN_HEIGHT = 1;
        private static final int MIN_WIDTH = 1;
        private final World world;
        private final EnumFacing.Axis axis;
        public final EnumFacing rightDir;
        public final EnumFacing leftDir;
        public final EnumFacing upDir;
        public final EnumFacing downDir;
        private int portalBlockCount;
        private BlockPos bottomLeft;
        private int height;
        private int width;

        public PortalSize(World world, BlockPos pos, EnumFacing.Axis axis) {
            this.world = world;
            this.axis = axis;
            if (axis == EnumFacing.Axis.X) {
                this.leftDir = EnumFacing.EAST;
                this.upDir = EnumFacing.UP;
            } else if (axis == EnumFacing.Axis.Z) {
                this.leftDir = EnumFacing.NORTH;
                this.upDir = EnumFacing.UP;
            } else {
                this.leftDir = EnumFacing.NORTH;
                this.upDir = EnumFacing.EAST;
            }
            this.rightDir = this.leftDir.func_176734_d();
            this.downDir = this.upDir.func_176734_d();
            BlockPos searchPos = pos;
            while (WorldUtil.getSideValue((BlockPos)pos, (EnumFacing)this.upDir) > WorldUtil.getSideValue((BlockPos)searchPos, (EnumFacing)this.upDir) - 21 && pos.func_177956_o() > 0 && this.isBlockAir(world.func_180495_p(pos.func_177972_a(this.downDir)))) {
                pos = pos.func_177972_a(this.downDir);
            }
            int distanceUntillEdge = this.getDistanceUntilEdge(pos, this.leftDir) - 1;
            if (distanceUntillEdge >= 0) {
                this.bottomLeft = pos.func_177967_a(this.leftDir, distanceUntillEdge);
                this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
                if (this.width < 1 || this.width > 21) {
                    this.bottomLeft = null;
                    this.width = 0;
                }
            }
            if (this.bottomLeft != null) {
                this.height = this.calculatePortalHeight();
            }
        }

        public BlockMiningPortal getPortalBlock() {
            return BlockMiningPortal.this;
        }

        protected int getDistanceUntilEdge(BlockPos searchPos, EnumFacing searchDir) {
            BlockPos currentPos;
            int height;
            for (height = 0; height <= 21 && this.isBlockAir(this.world.func_180495_p(currentPos = searchPos.func_177967_a(searchDir, height))) && this.world.func_180495_p(currentPos.func_177972_a(this.downDir)).func_177230_c() == BlockMiningPortal.this.getFrameBlock(); ++height) {
            }
            Block arg4 = this.world.func_180495_p(searchPos.func_177967_a(searchDir, height)).func_177230_c();
            return arg4 == BlockMiningPortal.this.getFrameBlock() ? height : 0;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        protected int calculatePortalHeight() {
            int currentWidth;
            this.height = 0;
            block0: while (this.height < 21) {
                for (currentWidth = 0; currentWidth < this.width; ++currentWidth) {
                    BlockPos pos = this.bottomLeft.func_177967_a(this.rightDir, currentWidth).func_177967_a(this.upDir, this.height);
                    IBlockState state = this.world.func_180495_p(pos);
                    if (!this.isBlockAir(state)) break block0;
                    if (state.func_177230_c() == BlockMiningPortal.this) {
                        ++this.portalBlockCount;
                    }
                    if (currentWidth == 0 ? (state = this.world.func_180495_p(pos.func_177972_a(this.leftDir))).func_177230_c() != BlockMiningPortal.this.getFrameBlock() : currentWidth == this.width - 1 && (state = this.world.func_180495_p(pos.func_177972_a(this.rightDir))).func_177230_c() != BlockMiningPortal.this.getFrameBlock()) break block0;
                }
                ++this.height;
            }
            for (currentWidth = 0; currentWidth < this.width; ++currentWidth) {
                if (this.world.func_180495_p(this.bottomLeft.func_177967_a(this.rightDir, currentWidth).func_177967_a(this.upDir, this.height)).func_177230_c() == BlockMiningPortal.this.getFrameBlock()) continue;
                this.height = 0;
                break;
            }
            if (this.height <= 21 && this.height >= 1) {
                return this.height;
            }
            this.bottomLeft = null;
            this.width = 0;
            this.height = 0;
            return 0;
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 1 && this.width <= 21 && this.height >= 1 && this.height <= 21;
        }

        public boolean isValidPortal() {
            return this.isValid() && this.portalBlockCount == this.width * this.height;
        }

        public void placePortalBlocks() {
            for (int currentWidth = 0; currentWidth < this.width; ++currentWidth) {
                BlockPos lvt_2_1_ = this.bottomLeft.func_177967_a(this.rightDir, currentWidth);
                for (int currentHeight = 0; currentHeight < this.height; ++currentHeight) {
                    this.world.func_180501_a(lvt_2_1_.func_177967_a(this.upDir, currentHeight), BlockMiningPortal.this.func_176223_P().func_177226_a((IProperty)BlockMiningPortal.this.property, (Comparable)this.axis), 2);
                }
            }
        }

        public EnumFacing.Axis getAxis() {
            return this.axis;
        }

        private boolean isBlockAir(IBlockState state) {
            return WorldUtil.isBlockAir((IBlockState)state) || state == BlockMiningPortal.this.func_176223_P().func_177226_a((IProperty)BlockMiningPortal.this.property, (Comparable)this.axis);
        }
    }
}

