/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.world.item;

import aroma1997.core.item.AromicItem;
import aroma1997.core.misc.TeleporterNormal;
import aroma1997.core.util.LocalizationHelper;
import aroma1997.core.util.ServerUtil;
import aroma1997.world.DimensionalWorldItems;
import aroma1997.world.item.BlockPortalFrame;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDimensionChanger
extends AromicItem {
    private static List<BlockPortalFrame> knownDimensions = new ArrayList<BlockPortalFrame>();

    public static void addPortalFrame(BlockPortalFrame frame) {
        knownDimensions.add(frame);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 28;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        if (!world.field_72995_K) {
            EntityPlayer player;
            BlockPos bedLocation;
            int targetDim = this.getTargetDimension(stack, entityLiving.field_71093_bK);
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            WorldServer targetWorld = server.func_71218_a(targetDim);
            BlockPos pos = targetWorld.func_175694_M();
            if (entityLiving instanceof EntityPlayer && (bedLocation = (player = (EntityPlayer)entityLiving).getBedLocation(targetDim)) != null) {
                pos = bedLocation;
            }
            TeleporterNormal.teleportToDimension((Entity)entityLiving, (MinecraftServer)server, (int)targetDim, (Teleporter)new TeleporterNormal(pos));
        }
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            int damage = (itemStack.func_77952_i() + 1) % knownDimensions.size();
            itemStack.func_77964_b(damage);
            if (world.field_72995_K) {
                player.func_145747_a(ServerUtil.getChatForString((String)LocalizationHelper.localizeFormatted((String)"item.aroma1997sdimension:dimensionChanger.description", (Object[])new Object[]{this.getTargetDimension(itemStack, player.field_71093_bK)})));
            }
        } else {
            player.func_184598_c(hand);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
    }

    public int getTargetDimension(ItemStack stack, int currentDimension) {
        return knownDimensions.get(stack.func_77952_i()).getMiningPortal().getTargetDimension(currentDimension);
    }

    public int func_77647_b(int i) {
        return i;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        subItems.add((Object)new ItemStack((Item)this));
        if (tab == CreativeTabs.field_78027_g) {
            for (int i = 1; i < knownDimensions.size(); ++i) {
                subItems.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    public void postRegister() {
        ItemDimensionChanger.addPortalFrame(DimensionalWorldItems.portalFrame);
        ItemDimensionChanger.addPortalFrame(DimensionalWorldItems.portalFrameSphere);
        this.registerModels();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        if (world == null) {
            return;
        }
        tooltip.add(LocalizationHelper.localizeFormatted((String)"item.aroma1997sdimension:dimensionChanger.description", (Object[])new Object[]{this.getTargetDimension(stack, world.field_73011_w.getDimension())}));
    }
}

