/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.world.sphere.dimension;

import aroma1997.world.sphere.dimension.BiomeProviderSphere;
import aroma1997.world.sphere.dimension.ChunkGeneratorSphere;
import aroma1997.world.sphere.dimension.WorldProviderSphere;
import aroma1997.world.sphere.sphereproviders.BufferedSphereProvider;
import aroma1997.world.sphere.sphereproviders.ISphereInfoProvider;
import aroma1997.world.sphere.sphereproviders.RandomSphereProvider;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SphereWorldType
extends WorldType {
    private Map<World, ISphereInfoProvider> sphereInfoProvider = new WeakHashMap<World, ISphereInfoProvider>();

    public SphereWorldType() {
        super("biomesphere;");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77128_b() {
        return "generator.aroma1997sdimension:biomesphere";
    }

    protected ISphereInfoProvider getSphereInfo(World world) {
        return new RandomSphereProvider(world.func_72905_C());
    }

    private ISphereInfoProvider getBufferedInfoProvider(World world) {
        ISphereInfoProvider provider = this.sphereInfoProvider.get(world);
        if (provider == null) {
            provider = new BufferedSphereProvider(this.getSphereInfo(world));
            this.sphereInfoProvider.put(world, provider);
        }
        return provider;
    }

    public BiomeProvider getBiomeProvider(World world) {
        return new BiomeProviderSphere(this.getBufferedInfoProvider(world));
    }

    public IChunkGenerator getChunkGenerator(World world, String generatorOptions) {
        return new ChunkGeneratorSphere(world, this.getBufferedInfoProvider(world), world.func_72912_H().func_76089_r());
    }

    public int getMinimumSpawnHeight(World world) {
        return 4;
    }

    @SubscribeEvent
    public void createSpawnEvent(WorldEvent.CreateSpawnPosition event) {
        World world = event.getWorld();
        if (world.func_72912_H().func_76067_t() == this) {
            world.func_175652_B(WorldProviderSphere.getSpawnPoint(this.getBufferedInfoProvider(world), BlockPos.field_177992_a));
            event.setCanceled(true);
        }
    }
}

