/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.world.sphere.dimension;

import aroma1997.core.util.LazyInitializer;
import aroma1997.world.DimensionalWorldItems;
import aroma1997.world.sphere.Sphere;
import aroma1997.world.sphere.dimension.BiomeProviderSphere;
import aroma1997.world.sphere.dimension.ChunkGeneratorSphere;
import aroma1997.world.sphere.sphereproviders.BufferedSphereProvider;
import aroma1997.world.sphere.sphereproviders.EmptySphereProvider;
import aroma1997.world.sphere.sphereproviders.ISphereInfoProvider;
import aroma1997.world.sphere.sphereproviders.RandomSphereProvider;
import java.util.Collection;
import java.util.stream.Stream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.IChunkGenerator;

public class WorldProviderSphere
extends WorldProvider
implements ISphereInfoProvider {
    private static final BlockPos ORIGINUP = new BlockPos(0, 100, 0);
    private ISphereInfoProvider sphereInfo = new EmptySphereProvider();
    private LazyInitializer<BlockPos> spawnPoint = new LazyInitializer(() -> WorldProviderSphere.getSpawnPoint(this, BlockPos.field_177992_a));

    public DimensionType func_186058_p() {
        return DimensionalWorldItems.dimensionTypeSphere;
    }

    protected void func_76572_b() {
        this.field_191067_f = true;
        this.field_76578_c = new BiomeProviderSphere(this);
        if (!this.field_76579_a.field_72995_K) {
            this.sphereInfo = new BufferedSphereProvider(new RandomSphereProvider(this.getSeed()));
        }
    }

    public IChunkGenerator func_186060_c() {
        return new ChunkGeneratorSphere(this.field_76579_a, this, true);
    }

    public boolean func_76566_a(int x, int z) {
        return this.getInfluencedSpheres(new ChunkPos(x >> 4, z >> 4)).stream().anyMatch(sphere -> {
            int dist;
            int zD;
            int xD = sphere.getCenter().func_177958_n() - x;
            return xD * xD + (zD = sphere.getCenter().func_177952_p() - z) * zD < (dist = sphere.getRadius() - 2) * dist;
        });
    }

    public BlockPos getSpawnPoint() {
        return (BlockPos)this.spawnPoint.get();
    }

    public static BlockPos getSpawnPoint(ISphereInfoProvider info, BlockPos searchOrigin) {
        return info.getSphereStream(new ChunkPos(searchOrigin), 20).filter(sphere -> BiomeProvider.allowedBiomes.contains(sphere.getBiome())).map(Sphere::getCenter).findFirst().orElse(ORIGINUP);
    }

    @Override
    public Collection<Sphere> getInfluencedSpheres(ChunkPos pos) {
        return this.sphereInfo.getInfluencedSpheres(pos);
    }

    @Override
    public Stream<Sphere> getSphereStream(ChunkPos center, int radius) {
        return this.sphereInfo.getSphereStream(center, radius);
    }

    public boolean func_76567_e() {
        return false;
    }

    public WorldProvider.WorldSleepResult canSleepAt(EntityPlayer player, BlockPos pos) {
        return WorldProvider.WorldSleepResult.DENY;
    }
}

