/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.world.sphere.sphereproviders;

import aroma1997.world.Config;
import aroma1997.world.sphere.RandomSelection;
import aroma1997.world.sphere.Sphere;
import aroma1997.world.sphere.SphereHelper;
import aroma1997.world.sphere.dimension.BiomeProviderSphere;
import aroma1997.world.sphere.sphereproviders.ISphereInfoProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.biome.Biome;

public class RandomSphereProvider
implements ISphereInfoProvider {
    private final long worldSeed;
    private final Random random = new Random();
    private final RandomSelection<Biome> availableBiomes = new RandomSelection();
    private static final float VILLAGE_PROBABILITY = 0.3f;

    public RandomSphereProvider(long seed) {
        this.worldSeed = seed;
        for (Biome biome : Biome.field_185377_q) {
            if (!BiomeProviderSphere.isBiomeOK(biome)) continue;
            this.availableBiomes.add(biome, 1.0f);
        }
    }

    protected boolean isChunkCandidateForSphere(ChunkPos pos, long seed) {
        int hashSearchRadius = 2;
        for (int i = 0; i < (2 * hashSearchRadius + 1) * (2 * hashSearchRadius + 1); ++i) {
            ChunkPos current = new ChunkPos(pos.field_77276_a + i % (2 * hashSearchRadius + 1) - hashSearchRadius, pos.field_77275_b + i / (2 * hashSearchRadius + 1) - hashSearchRadius);
            if (SphereHelper.getRandomSeed(this.worldSeed, current) >= seed) continue;
            return false;
        }
        return true;
    }

    protected Sphere getSphere(ChunkPos pos) {
        long seed = SphereHelper.getRandomSeed(this.worldSeed, pos);
        if (!this.isChunkCandidateForSphere(pos, seed)) {
            return null;
        }
        this.random.setSeed(seed);
        if (this.random.nextFloat() < Config.INSTANCE.sphereSpawnRate) {
            int minHeight = Config.INSTANCE.sphereMinHeight;
            int diffHeight = Config.INSTANCE.sphereMaxHeight - minHeight;
            int minSize = Config.INSTANCE.sphereMinSize;
            int diffSize = Config.INSTANCE.sphereMaxSize - minSize;
            BlockPos center = pos.func_180331_a(this.random.nextInt(16), minHeight + SphereHelper.centered(this.random, diffHeight + 1), this.random.nextInt(16));
            int radius = minSize + SphereHelper.centered(this.random, diffSize + 1);
            return new Sphere(center, radius, this.availableBiomes.getRandomElement(this.random), this.random.nextFloat() < 0.3f);
        }
        return null;
    }

    @Override
    public Collection<Sphere> getInfluencedSpheres(ChunkPos center) {
        int searchRadius = (Config.INSTANCE.sphereMaxSize + 15) / 16;
        return this.getSphereStream(center, searchRadius).collect(Collectors.toList());
    }

    @Override
    public Stream<Sphere> getSphereStream(ChunkPos center, int radius) {
        return IntStream.rangeClosed(0, radius).mapToObj(i -> this.getSpheres(center, i)).flatMap(Function.identity());
    }

    private Stream<Sphere> getSpheres(ChunkPos center, int range) {
        ArrayList<Sphere> spheres = new ArrayList<Sphere>();
        for (int i = -range; i <= range; ++i) {
            spheres.add(this.getSphere(new ChunkPos(center.field_77276_a + i, center.field_77275_b + -range)));
            spheres.add(this.getSphere(new ChunkPos(center.field_77276_a + i, center.field_77275_b + range)));
            spheres.add(this.getSphere(new ChunkPos(center.field_77276_a + -range, center.field_77275_b + i)));
            spheres.add(this.getSphere(new ChunkPos(center.field_77276_a + range, center.field_77275_b + i)));
        }
        return spheres.stream().filter(Objects::nonNull).distinct();
    }
}

