/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.api.network;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import sonar.fluxnetworks.api.network.AccessLevel;
import sonar.fluxnetworks.api.network.FluxLogicType;
import sonar.fluxnetworks.api.network.NetworkMember;
import sonar.fluxnetworks.api.network.NetworkSettings;
import sonar.fluxnetworks.api.tiles.IFluxConnector;
import sonar.fluxnetworks.api.utils.NBTType;

public interface IFluxNetwork {
    default public int getNetworkID() {
        return this.getSetting(NetworkSettings.NETWORK_ID);
    }

    default public String getNetworkName() {
        return this.getSetting(NetworkSettings.NETWORK_NAME);
    }

    public <T> T getSetting(NetworkSettings<T> var1);

    public <T> void setSetting(NetworkSettings<T> var1, T var2);

    @Deprecated
    default public void onStartServerTick() {
    }

    default public void onEndServerTick() {
    }

    default public void onRemoved() {
    }

    default public AccessLevel getMemberPermission(EntityPlayer player) {
        return AccessLevel.NONE;
    }

    default public void addNewMember(String name) {
    }

    default public void removeMember(UUID uuid) {
    }

    default public <T extends IFluxConnector> List<T> getConnections(FluxLogicType type) {
        return Lists.newArrayList();
    }

    default public Optional<NetworkMember> getValidMember(UUID player) {
        return Optional.empty();
    }

    default public void queueConnectionAddition(IFluxConnector flux) {
    }

    default public void queueConnectionRemoval(IFluxConnector flux, boolean chunkUnload) {
    }

    default public boolean isInvalid() {
        return false;
    }

    public void readNetworkNBT(NBTTagCompound var1, NBTType var2);

    public void writeNetworkNBT(NBTTagCompound var1, NBTType var2);
}

