/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.connection.transfer;

import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import sonar.fluxnetworks.api.energy.ITileEnergyHandler;
import sonar.fluxnetworks.common.connection.FluxNetworkServer;
import sonar.fluxnetworks.common.connection.transfer.BasicTransferHandler;
import sonar.fluxnetworks.common.connection.transfer.ConnectionTransfer;
import sonar.fluxnetworks.common.handler.TileEntityHandler;
import sonar.fluxnetworks.common.tileentity.TileFluxPlug;

public class FluxPlugHandler
extends BasicTransferHandler<TileFluxPlug> {
    private final Map<EnumFacing, ConnectionTransfer> transfers = new EnumMap<EnumFacing, ConnectionTransfer>(EnumFacing.class);
    private long received;
    private long removed;

    public FluxPlugHandler(TileFluxPlug fluxPlug) {
        super(fluxPlug);
    }

    @Override
    public void onCycleStart() {
        for (ConnectionTransfer transfer : this.transfers.values()) {
            if (transfer == null) continue;
            transfer.onCycleStart();
        }
    }

    @Override
    public void onCycleEnd() {
        this.change = this.received;
        this.received = 0L;
        this.removed = 0L;
    }

    @Override
    public long removeFromBuffer(long energy) {
        long a = Math.min(Math.min(energy, this.buffer), ((TileFluxPlug)this.device).getLogicLimit() - this.removed);
        if (a <= 0L) {
            return 0L;
        }
        this.buffer -= a;
        this.removed += a;
        return a;
    }

    @Override
    public long receiveFromSupplier(long amount, @Nonnull EnumFacing side, boolean simulate) {
        if (((TileFluxPlug)this.device).getNetwork().isInvalid()) {
            return 0L;
        }
        ConnectionTransfer transfer = this.transfers.get(side);
        if (transfer != null) {
            long a = ((FluxNetworkServer)((TileFluxPlug)this.device).getNetwork()).bufferLimiter - this.buffer;
            if (a <= 0L) {
                return 0L;
            }
            if ((a = Math.min(amount, Math.min(a, ((TileFluxPlug)this.device).getLogicLimit()) - this.buffer)) <= 0L) {
                return 0L;
            }
            if (!simulate) {
                this.buffer += a;
                this.received += a;
                transfer.onEnergyReceived(a);
            }
            return a;
        }
        return 0L;
    }

    @Override
    public void updateTransfers(EnumFacing ... faces) {
        FluxPlugHandler.updateSidedTransfers(((TileFluxPlug)this.device).getFluxWorld(), ((TileFluxPlug)this.device).func_174877_v(), this.transfers, faces);
    }

    static void updateSidedTransfers(World world, BlockPos pos, Map<EnumFacing, ConnectionTransfer> transfers, @Nonnull EnumFacing[] faces) {
        for (EnumFacing dir : faces) {
            ITileEnergyHandler handler;
            TileEntity tile = world.func_175625_s(pos.func_177972_a(dir));
            ConnectionTransfer transfer = transfers.get(dir);
            if (tile == null || (handler = TileEntityHandler.getEnergyHandler(tile, dir.func_176734_d())) == null) {
                transfers.put(dir, null);
                continue;
            }
            if (transfer == null || transfer.getTile() != tile) {
                transfers.put(dir, new ConnectionTransfer(handler, tile, dir));
                continue;
            }
            if (!transfer.getTile().func_145837_r()) continue;
            transfers.put(dir, null);
        }
    }
}

