/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.handler;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import sonar.fluxnetworks.api.energy.ITileEnergyHandler;
import sonar.fluxnetworks.api.tiles.IFluxConnector;
import sonar.fluxnetworks.common.handler.ItemEnergyHandler;
import sonar.fluxnetworks.common.integration.energy.ForgeEnergyHandler;
import sonar.fluxnetworks.common.integration.energy.GTEnergyHandler;
import sonar.fluxnetworks.common.integration.energy.IC2EnergyHandler;
import sonar.fluxnetworks.common.integration.energy.RedstoneFluxHandler;
import sonar.fluxnetworks.common.tileentity.TileFluxController;
import sonar.fluxnetworks.common.tileentity.TileFluxPlug;
import sonar.fluxnetworks.common.tileentity.TileFluxPoint;
import sonar.fluxnetworks.common.tileentity.TileFluxStorage;

public class TileEntityHandler {
    public static List<ITileEnergyHandler> tileEnergyHandlers = Lists.newArrayList();
    public static Map<String, Integer> blockBlacklist = new HashMap<String, Integer>();

    public static void registerTileEntity() {
        GameRegistry.registerTileEntity(TileFluxController.class, (String)"FluxController");
        GameRegistry.registerTileEntity(TileFluxPoint.class, (String)"FluxPoint");
        GameRegistry.registerTileEntity(TileFluxPlug.class, (String)"FluxPlug");
        GameRegistry.registerTileEntity(TileFluxStorage.class, (String)"FluxStorage");
        GameRegistry.registerTileEntity(TileFluxStorage.Herculean.class, (String)"HerculeanFluxStorage");
        GameRegistry.registerTileEntity(TileFluxStorage.Gargantuan.class, (String)"GargantuanFluxStorage");
    }

    public static void registerEnergyHandler() {
        tileEnergyHandlers.add(ForgeEnergyHandler.INSTANCE);
        ItemEnergyHandler.itemEnergyHandlers.add(ForgeEnergyHandler.INSTANCE);
        if (Loader.isModLoaded((String)"gregtech")) {
            tileEnergyHandlers.add(GTEnergyHandler.INSTANCE);
            ItemEnergyHandler.itemEnergyHandlers.add(GTEnergyHandler.INSTANCE);
        }
        if (Loader.isModLoaded((String)"redstoneflux")) {
            tileEnergyHandlers.add(RedstoneFluxHandler.INSTANCE);
            ItemEnergyHandler.itemEnergyHandlers.add(RedstoneFluxHandler.INSTANCE);
        }
        if (Loader.isModLoaded((String)"ic2")) {
            tileEnergyHandlers.add(IC2EnergyHandler.INSTANCE);
            ItemEnergyHandler.itemEnergyHandlers.add(IC2EnergyHandler.INSTANCE);
        }
    }

    @Nullable
    public static ITileEnergyHandler getEnergyHandler(TileEntity tile, EnumFacing side) {
        if (tile instanceof IFluxConnector) {
            return null;
        }
        String s = tile.func_145838_q().getRegistryName().toString();
        if (blockBlacklist.containsKey(s)) {
            int meta = blockBlacklist.get(s);
            if (meta == -1) {
                return null;
            }
            if (meta == tile.func_145832_p()) {
                return null;
            }
        }
        for (ITileEnergyHandler handler : tileEnergyHandlers) {
            if (!handler.hasCapability(tile, side)) continue;
            return handler;
        }
        return null;
    }

    public static boolean canRenderConnection(TileEntity tile, EnumFacing side) {
        if (tile == null) {
            return false;
        }
        if (tile instanceof IFluxConnector) {
            return false;
        }
        if (blockBlacklist.containsKey(tile.func_145838_q().getRegistryName().toString())) {
            int meta = blockBlacklist.get(tile.func_145838_q().getRegistryName().toString());
            if (meta == -1) {
                return false;
            }
            if (meta == tile.func_145832_p()) {
                return false;
            }
        }
        ITileEnergyHandler handler = null;
        for (ITileEnergyHandler handler1 : tileEnergyHandlers) {
            if (!handler1.hasCapability(tile, side)) continue;
            handler = handler1;
        }
        return handler != null;
    }
}

