/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.network;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.utils.NBTType;
import sonar.fluxnetworks.common.connection.FluxNetworkCache;
import sonar.fluxnetworks.common.network.PacketNetworkUpdate;

public class PacketNetworkUpdateRequest
implements IMessageHandler<UpdateRequestMessage, IMessage> {
    public IMessage onMessage(UpdateRequestMessage message, MessageContext ctx) {
        ArrayList networks = Lists.newArrayList();
        for (Integer i : message.networks) {
            IFluxNetwork network = FluxNetworkCache.instance.getNetwork(i);
            if (network.isInvalid()) continue;
            networks.add(network);
        }
        if (!networks.isEmpty()) {
            return new PacketNetworkUpdate.NetworkUpdateMessage(Lists.newArrayList((Iterable)networks), message.type);
        }
        return null;
    }

    public static class UpdateRequestMessage
    implements IMessage {
        public List<Integer> networks = Lists.newArrayList();
        public NBTType type;

        public UpdateRequestMessage() {
        }

        public UpdateRequestMessage(int networkID, NBTType type) {
            this.networks.add(networkID);
            this.type = type;
        }

        public UpdateRequestMessage(List<IFluxNetwork> networks, NBTType type) {
            networks.forEach(n -> this.networks.add(n.getNetworkID()));
            this.type = type;
        }

        public void fromBytes(ByteBuf buf) {
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                this.networks.add(buf.readInt());
            }
            this.type = NBTType.values()[buf.readInt()];
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.networks.size());
            this.networks.forEach(arg_0 -> ((ByteBuf)buf).writeInt(arg_0));
            buf.writeInt(this.type.ordinal());
        }
    }
}

