/*
 * Decompiled with CFR 0.152.
 */
package com.denfop;

import com.denfop.damagesource.IUDamageSource;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class IUPotion
extends Potion {
    public static IUPotion radiation;
    public static IUPotion frostbite;
    public static IUPotion poison_gas;
    private final List<ItemStack> curativeItems;
    private final ResourceLocation nameIcon;

    public IUPotion(String name, boolean badEffect, int liquidColor, ItemStack ... curativeItems) {
        super(badEffect, liquidColor);
        this.curativeItems = Arrays.asList(curativeItems);
        this.nameIcon = new ResourceLocation("industrialupgrade:textures/gui/" + name + ".png");
        ForgeRegistries.POTIONS.register(this.setRegistryName(name));
    }

    public static void init() {
        radiation.func_76390_b("iu.potion.radiation");
        radiation.func_76404_a(0.25);
        frostbite.func_76390_b("iu.potion.frostbite");
        frostbite.func_76404_a(0.25);
        poison_gas.func_76390_b("iu.potion.poison_gas");
        poison_gas.func_76404_a(0.25);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHUDEffect(int x, int y, PotionEffect effect, Minecraft mc, float alpha) {
        mc.field_71446_o.func_110577_a(this.nameIcon);
        Gui.func_146110_a((int)(x + 3), (int)(y + 3), (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventoryEffect(int x, int y, PotionEffect effect, Minecraft mc) {
        mc.field_71446_o.func_110577_a(this.nameIcon);
        Gui.func_146110_a((int)(x + 6), (int)(y + 7), (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
    }

    public void func_76394_a(EntityLivingBase entity, int amplifier) {
        if (this == radiation) {
            entity.func_70097_a(IUDamageSource.radiation, (float)(amplifier / 100) + 0.5f);
        }
        if (this == frostbite) {
            entity.func_70097_a(IUDamageSource.frostbite, (float)(amplifier / 100) + 0.5f);
        }
        if (this == poison_gas) {
            entity.func_70097_a(IUDamageSource.poison_gas, (float)(amplifier / 100) + 0.5f);
        }
    }

    public boolean func_76397_a(int duration, int amplifier) {
        int rate = 25 >> amplifier;
        return rate == 0 || duration % rate == 0;
    }

    public void applyTo(EntityLivingBase entity, int duration, int amplifier) {
        PotionEffect effect = new PotionEffect((Potion)radiation, duration, amplifier);
        effect.setCurativeItems(this.curativeItems);
        entity.func_70690_d(effect);
    }
}

