/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.agriculture;

import com.denfop.IUItem;
import com.denfop.api.agriculture.CropNetwork;
import com.denfop.api.agriculture.EnumSoil;
import com.denfop.api.agriculture.ICrop;
import com.denfop.api.pollution.LevelPollution;
import com.denfop.api.radiationsystem.EnumLevelRadiation;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;

public class CropBase
implements ICrop {
    private final String name;
    private final short id;
    private final EnumSoil soil;
    private final byte defaultWaterRequirement;
    private final byte defaultPestResistance;
    private final byte defaultLightLevel;
    private final byte defaultWeatherResistance;
    private final List<ICrop> unCompatibleCrops;
    private final byte render;
    private final boolean isCombine;
    private final List<ICrop> cropCombine;
    private final int maxTick;
    private final List<Biome> biomes;
    private final List<ICrop> compatibleCrops;
    private final List<ResourceLocation> textures;
    private final List<ResourceLocation> textures_top;
    private ItemStack stack;
    private byte genomeResistance;
    private byte genomeAdaptive;
    private byte chance;
    private boolean isBeeCombine;
    private LevelPollution airRequirements;
    private EnumLevelRadiation radiationRequirements;
    private int generation;
    private boolean sun;
    private boolean night;
    private byte chanceWeed;
    private byte sizeSeed;
    private int tick;
    private boolean ignoreSoil;
    private byte yield;
    private byte weatherResistance;
    private byte waterRequirement;
    private double growthSpeed;
    private byte pestResistance;
    private byte lightLevel;
    private LevelPollution soilRequirements;
    private List<ItemStack> drops;
    private ResourceLocation texture;
    private byte stage;
    private byte maxStage;

    public CropBase(String name, int id, EnumSoil soil, ItemStack stack, int yield, int weatherResistance, int waterRequirement, double growthSpeed, int pestResistance, int maxStage, int sizeSeed, ResourceLocation texture, boolean isCombine, List<ICrop> cropCombine, int chance, boolean isBeeCombine, int tick, int chanceWeed, boolean sun, boolean night, List<ItemStack> drop, int lightLevel, List<ICrop> unCompatibleCrops, int render) {
        this.yield = (byte)yield;
        this.name = name;
        this.unCompatibleCrops = unCompatibleCrops;
        this.generation = 0;
        this.id = (short)id;
        this.sun = sun;
        this.night = night;
        this.chanceWeed = (byte)chanceWeed;
        this.sizeSeed = (byte)sizeSeed;
        this.weatherResistance = (byte)weatherResistance;
        this.defaultWeatherResistance = (byte)weatherResistance;
        this.waterRequirement = (byte)waterRequirement;
        this.defaultWaterRequirement = (byte)waterRequirement;
        this.growthSpeed = growthSpeed;
        this.pestResistance = (byte)pestResistance;
        this.defaultPestResistance = (byte)pestResistance;
        this.maxStage = (byte)maxStage;
        this.stage = 0;
        this.render = (byte)render;
        this.biomes = new ArrayList<Biome>();
        this.drops = drop;
        this.textures = new ArrayList<ResourceLocation>();
        this.textures_top = new ArrayList<ResourceLocation>();
        this.soil = soil;
        this.ignoreSoil = false;
        this.stack = stack;
        NBTTagCompound nbt = ModUtils.nbt(this.stack);
        nbt.func_74768_a("crop_id", id);
        this.isCombine = isCombine;
        this.cropCombine = cropCombine;
        this.compatibleCrops = cropCombine;
        this.chance = (byte)chance;
        this.isBeeCombine = isBeeCombine;
        this.setTexture(texture, render);
        this.maxTick = tick;
        this.tick = 0;
        this.soilRequirements = LevelPollution.LOW;
        this.airRequirements = LevelPollution.LOW;
        this.radiationRequirements = EnumLevelRadiation.LOW;
        this.genomeResistance = 0;
        this.genomeAdaptive = 0;
        this.lightLevel = (byte)lightLevel;
        this.defaultLightLevel = (byte)lightLevel;
        CropNetwork.instance.addCrop(this);
    }

    public CropBase(String name, int id, EnumSoil soil, int yield, int weatherResistance, int waterRequirement, double growthSpeed, int pestResistance, int maxStage, int sizeSeed, ResourceLocation texture, boolean isCombine, List<ICrop> cropCombine, int chance, boolean isBeeCombine, int tick, int chanceWeed, boolean sun, boolean night, List<ItemStack> drop, int lightLevel, List<ICrop> unCompatibleCrops, int render) {
        this.yield = (byte)yield;
        this.name = name;
        this.unCompatibleCrops = unCompatibleCrops;
        this.generation = 0;
        this.id = (short)id;
        this.sun = sun;
        this.night = night;
        this.chanceWeed = (byte)chanceWeed;
        this.sizeSeed = (byte)sizeSeed;
        this.weatherResistance = (byte)weatherResistance;
        this.defaultWeatherResistance = (byte)weatherResistance;
        this.waterRequirement = (byte)waterRequirement;
        this.defaultWaterRequirement = (byte)waterRequirement;
        this.growthSpeed = growthSpeed;
        this.pestResistance = (byte)pestResistance;
        this.defaultPestResistance = (byte)pestResistance;
        this.maxStage = (byte)maxStage;
        this.stage = 0;
        this.render = (byte)render;
        this.biomes = new ArrayList<Biome>();
        this.drops = drop;
        this.textures = new ArrayList<ResourceLocation>();
        this.textures_top = new ArrayList<ResourceLocation>();
        this.soil = soil;
        this.ignoreSoil = false;
        this.stack = new ItemStack((Item)IUItem.crops);
        NBTTagCompound nbt = ModUtils.nbt(this.stack);
        nbt.func_74768_a("crop_id", id);
        this.isCombine = isCombine || !cropCombine.isEmpty();
        this.cropCombine = cropCombine;
        this.compatibleCrops = cropCombine;
        this.chance = (byte)chance;
        this.isBeeCombine = isBeeCombine;
        this.setTexture(texture, render);
        this.maxTick = tick;
        this.tick = 0;
        this.soilRequirements = LevelPollution.LOW;
        this.airRequirements = LevelPollution.LOW;
        this.radiationRequirements = EnumLevelRadiation.LOW;
        this.genomeResistance = 0;
        this.genomeAdaptive = 0;
        this.lightLevel = (byte)lightLevel;
        this.defaultLightLevel = (byte)lightLevel;
        CropNetwork.instance.addCrop(this);
    }

    @Override
    public CropBase copy() {
        CropBase cropBase = new CropBase(this.name, this.id, this.soil, this.stack.func_77946_l(), this.yield, this.defaultWeatherResistance, this.defaultWaterRequirement, this.growthSpeed, this.defaultPestResistance, this.maxStage, this.sizeSeed, this.texture, this.isCombine, this.cropCombine, this.chance, this.isBeeCombine, this.maxTick, this.chanceWeed, this.sun, this.night, this.drops, this.defaultLightLevel, this.unCompatibleCrops, this.render);
        cropBase.setAirRequirements(LevelPollution.LOW);
        cropBase.setRadiationRequirements(this.radiationRequirements);
        cropBase.setSoilRequirements(this.soilRequirements);
        cropBase.setGeneration(this.getGeneration());
        cropBase.setGenomeAdaptive(this.genomeAdaptive);
        cropBase.setGenomeResistance(this.genomeResistance);
        for (Biome biome : this.biomes) {
            cropBase.addBiome(biome);
        }
        return cropBase;
    }

    @Override
    public int getDefaultPestResistance() {
        return this.defaultPestResistance;
    }

    @Override
    public int getDefaultWeatherResistance() {
        return this.defaultWeatherResistance;
    }

    @Override
    public int getGenomeAdaptive() {
        return this.genomeAdaptive;
    }

    @Override
    public void setGenomeAdaptive(int genomeAdaptive) {
        this.genomeAdaptive = (byte)genomeAdaptive;
    }

    @Override
    public int getGenomeResistance() {
        return this.genomeResistance;
    }

    @Override
    public void setGenomeResistance(int genomeResistance) {
        this.genomeResistance = (byte)genomeResistance;
    }

    @Override
    public int getGeneration() {
        return this.generation;
    }

    @Override
    public void setGeneration(int generation) {
        this.generation = generation;
    }

    @Override
    public EnumLevelRadiation getRadiationRequirements() {
        return this.radiationRequirements;
    }

    @Override
    public void setRadiationRequirements(EnumLevelRadiation radiationRequirements) {
        this.radiationRequirements = radiationRequirements;
    }

    @Override
    public LevelPollution getAirRequirements() {
        return this.airRequirements;
    }

    @Override
    public void setAirRequirements(LevelPollution airRequirements) {
        this.airRequirements = airRequirements;
    }

    @Override
    public boolean isBeeCombine() {
        return this.isBeeCombine;
    }

    @Override
    public void setBeeCombine(boolean beeCombine) {
        this.isBeeCombine = beeCombine;
    }

    @Override
    public int getTick() {
        return this.tick;
    }

    @Override
    public void setTick(int tick) {
        this.tick = tick;
        if (this.tick >= this.maxTick) {
            this.tick = this.maxTick;
        }
        this.stage = (byte)Math.max((int)Math.ceil((double)this.maxStage * ((double)this.tick * 1.0 / (double)this.maxTick)) - 1, 0);
    }

    @Override
    public void addTick(int tick) {
        this.tick += tick;
        if (this.tick >= this.maxTick) {
            this.tick = this.maxTick;
        }
        this.stage = (byte)Math.max((int)Math.ceil((double)this.maxStage * ((double)this.tick * 1.0 / (double)this.maxTick)) - 1, 0);
    }

    @Override
    public boolean isCombine() {
        return this.isCombine;
    }

    @Override
    public int getMaxTick() {
        return this.maxTick;
    }

    @Override
    public int getChance() {
        return this.chance;
    }

    @Override
    public void setChance(int chance) {
        this.chance = (byte)chance;
    }

    @Override
    public List<ICrop> getCropCombine() {
        return this.cropCombine;
    }

    @Override
    public ItemStack getStackForDrop() {
        return this.stack;
    }

    @Override
    public ItemStack getStack() {
        return this.stack.func_77946_l();
    }

    @Override
    public void setStack(ItemStack cropItem) {
        this.stack = cropItem;
    }

    @Override
    public boolean isSun() {
        return this.sun;
    }

    @Override
    public void setSun(boolean sun) {
        this.sun = sun;
    }

    @Override
    public boolean isNight() {
        return this.night;
    }

    @Override
    public void setNight(boolean night) {
        this.night = night;
    }

    @Override
    public EnumSoil getSoil() {
        return this.soil;
    }

    @Override
    public boolean isIgnoreSoil() {
        return this.ignoreSoil;
    }

    @Override
    public void setIgnoreSoil(boolean ignoreSoil) {
        this.ignoreSoil = ignoreSoil;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getDefaultWaterRequirement() {
        return this.defaultWaterRequirement;
    }

    @Override
    public int getSizeSeed() {
        return this.sizeSeed;
    }

    @Override
    public void addSizeSeed(int col) {
        this.sizeSeed = (byte)col;
    }

    @Override
    public int getChanceWeed() {
        return this.chanceWeed;
    }

    @Override
    public void addChanceWeed(int col) {
        this.chanceWeed = (byte)col;
    }

    @Override
    public int getDefaultLightLevel() {
        return this.defaultLightLevel;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getLightLevel() {
        return this.lightLevel;
    }

    @Override
    public int getPestResistance() {
        return this.pestResistance;
    }

    @Override
    public void setPestResistance(int resistance) {
        this.pestResistance = (byte)resistance;
    }

    @Override
    public LevelPollution getSoilRequirements() {
        return this.soilRequirements;
    }

    @Override
    public void setSoilRequirements(LevelPollution pollution) {
        this.soilRequirements = pollution;
    }

    @Override
    public List<Biome> getBiomes() {
        return this.biomes;
    }

    @Override
    public boolean isCombineWithCrops(List<ICrop> crops) {
        if (crops.size() != this.compatibleCrops.size()) {
            return false;
        }
        block0: for (ICrop crop : crops) {
            for (ICrop crop1 : this.compatibleCrops) {
                if (crop1.getId() != crop.getId()) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    @Override
    public List<ItemStack> getDrops() {
        return this.drops;
    }

    @Override
    public int getYield() {
        return this.yield;
    }

    @Override
    public void setYield(int yield) {
        this.yield = (byte)yield;
    }

    @Override
    public int getWeatherResistance() {
        return this.weatherResistance;
    }

    @Override
    public void setWeatherResistance(int resistance) {
        this.weatherResistance = (byte)resistance;
    }

    @Override
    public int getWaterRequirement() {
        return this.waterRequirement;
    }

    @Override
    public void setWaterRequirement(int waterRequirement) {
        this.waterRequirement = (byte)waterRequirement;
    }

    @Override
    public double getGrowthSpeed() {
        return this.growthSpeed;
    }

    @Override
    public void setGrowthSpeed(double speed) {
        this.growthSpeed = speed;
    }

    @Override
    public boolean canGrowInBiome(Biome biomeName) {
        return this.biomes.contains(biomeName);
    }

    @Override
    public void addBiome(Biome biomeName) {
        if (!this.biomes.contains(biomeName)) {
            this.biomes.add(biomeName);
        }
    }

    @Override
    public void removeBiome(Biome biomeName) {
        this.biomes.remove(biomeName);
    }

    @Override
    public void setLight(int lightLevel) {
        this.lightLevel = (byte)lightLevel;
    }

    @Override
    public boolean compatibilityWithCrop(ICrop crop) {
        return this.unCompatibleCrops.contains(crop);
    }

    @Override
    public List<ItemStack> getDrop() {
        return this.drops;
    }

    @Override
    public void setDrop(List<ItemStack> drop) {
        this.drops = drop;
    }

    @Override
    public ResourceLocation getTexture() {
        return this.texture;
    }

    public void setTexture(ResourceLocation texture, int render) {
        this.texture = texture;
        this.textures.clear();
        this.textures_top.clear();
        for (int i = 0; i < this.maxStage; ++i) {
            this.textures.add(new ResourceLocation(this.texture.func_110624_b(), this.texture.func_110623_a() + "_" + i));
            if (render < 3) continue;
            this.textures_top.add(new ResourceLocation(this.texture.func_110624_b(), this.texture.func_110623_a() + "_top_" + i));
        }
    }

    @Override
    public ResourceLocation getTexture(int stage) {
        return this.textures.get(stage);
    }

    @Override
    public ResourceLocation getTextureTop(int stage) {
        return this.textures_top.get(stage);
    }

    @Override
    public List<ResourceLocation> getTextures() {
        return this.textures;
    }

    @Override
    public int getStage() {
        return this.stage;
    }

    @Override
    public void setStage(int stage) {
        this.stage = (byte)stage;
    }

    @Override
    public int getMaxStage() {
        return this.maxStage - 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CropBase cropBase = (CropBase)o;
        return this.id == cropBase.id && this.stage == cropBase.stage;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.stage);
    }

    public String toString() {
        return "CropBase{yield=" + this.yield + ", weatherResistance=" + this.weatherResistance + ", waterRequirement=" + this.waterRequirement + ", growthSpeed=" + this.growthSpeed + ", pestResistance=" + this.pestResistance + ", lightLevel=" + this.lightLevel + ", soilRequirements=" + (Object)((Object)this.soilRequirements) + ", biomes=" + this.biomes + ", compatibleCrops=" + this.compatibleCrops + ", drops=" + this.drops + ", texture=" + this.texture + ", stage=" + this.stage + ", maxStage=" + this.maxStage + '}';
    }

    @Override
    public void readPacket(CustomPacketBuffer buffer) {
        this.yield = buffer.readByte();
        this.tick = buffer.readInt();
        this.generation = buffer.readInt();
        this.stage = buffer.readByte();
        this.maxStage = buffer.readByte();
    }

    @Override
    public int getRender() {
        return this.render;
    }

    @Override
    public List<ResourceLocation> getTopTexture() {
        return this.textures_top;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer buffer = new CustomPacketBuffer();
        buffer.writeByte(this.yield);
        buffer.writeInt(this.tick);
        buffer.writeInt(this.generation);
        buffer.writeByte(this.stage);
        buffer.writeByte(this.maxStage);
        return buffer;
    }
}

