/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.agriculture;

import com.denfop.IUItem;
import com.denfop.api.agriculture.EnumSoil;
import com.denfop.api.agriculture.ICrop;
import com.denfop.api.agriculture.ICropItem;
import com.denfop.api.agriculture.genetics.GeneticsManager;
import com.denfop.api.agriculture.genetics.Genome;
import com.denfop.api.pollution.ChunkLevel;
import com.denfop.api.pollution.PollutionManager;
import com.denfop.api.radiationsystem.Radiation;
import com.denfop.tiles.crop.TileEntityCrop;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;

public class CropNetwork {
    public static CropNetwork instance;
    Map<Integer, ICrop> cropMap = new HashMap<Integer, ICrop>();
    Map<Integer, Map<ChunkPos, List<TileEntityCrop>>> mapWorldCrop = new HashMap<Integer, Map<ChunkPos, List<TileEntityCrop>>>();

    public static void init() {
        if (instance == null) {
            instance = new CropNetwork();
        }
    }

    public List<TileEntityCrop> getCropsFromChunk(World world, ChunkPos chunkPos) {
        Map map = this.mapWorldCrop.computeIfAbsent(world.field_73011_w.getDimension(), k -> new HashMap());
        return map.computeIfAbsent(chunkPos, k -> new ArrayList());
    }

    public void addNewCropToWorld(TileEntityCrop crop) {
        Map<ChunkPos, List<TileEntityCrop>> map = this.mapWorldCrop.get(crop.func_145831_w().field_73011_w.getDimension());
        if (map == null) {
            map = new HashMap<ChunkPos, List<TileEntityCrop>>();
            ChunkPos chunkPos = new ChunkPos(crop.func_174877_v());
            ArrayList<TileEntityCrop> list = new ArrayList<TileEntityCrop>();
            list.add(crop);
            map.put(chunkPos, list);
            this.mapWorldCrop.put(crop.func_145831_w().field_73011_w.getDimension(), map);
        } else {
            ChunkPos chunkPos = new ChunkPos(crop.func_174877_v());
            List<TileEntityCrop> list = map.get(chunkPos);
            if (list == null) {
                list = new ArrayList<TileEntityCrop>();
                list.add(crop);
                map.put(chunkPos, list);
            } else {
                list.add(crop);
            }
        }
    }

    public void removeCropFromWorld(TileEntityCrop crop) {
        ChunkPos chunkPos;
        List<TileEntityCrop> list;
        Map<ChunkPos, List<TileEntityCrop>> map = this.mapWorldCrop.get(crop.func_145831_w().field_73011_w.getDimension());
        if (map != null && (list = map.get(chunkPos = new ChunkPos(crop.func_174877_v()))) != null) {
            list.remove(crop);
        }
    }

    public CropNetwork getInstance() {
        return instance;
    }

    public Map<Integer, ICrop> getCropMap() {
        return this.cropMap;
    }

    public ICrop getCropFromStack(ItemStack stack, Genome genome) {
        if (stack.func_77973_b() instanceof ICropItem) {
            ICrop crop = ((ICropItem)stack.func_77973_b()).getCrop(stack.func_77952_i(), stack).copy();
            GeneticsManager.instance.loadGenomeToCrop(genome, crop);
            return crop;
        }
        return null;
    }

    public ICrop getCropFromStack(ItemStack stack) {
        if (stack.func_77973_b() instanceof ICropItem) {
            return ((ICropItem)stack.func_77973_b()).getCrop(stack.func_77952_i(), stack);
        }
        return null;
    }

    public ICrop getCrop(int id) {
        return this.cropMap.get(id);
    }

    public ICrop canCropCombine(List<ICrop> crops) {
        for (ICrop crop : this.cropMap.values()) {
            if (!crop.isCombine() || !crop.isCombineWithCrops(crops)) continue;
            return crop.copy();
        }
        return null;
    }

    public boolean canPlantCrop(ItemStack stack, World world, BlockPos pos, IBlockState downBlock, Biome biome) {
        ICrop crop = this.getCropFromStack(stack);
        if (crop == null) {
            return false;
        }
        if (crop.isIgnoreSoil() || crop.getSoil().getState() == downBlock && !crop.getSoil().isIgnore() || crop.getSoil().getBlock() == downBlock.func_177230_c() && crop.getSoil().isIgnore() || crop.getSoil() == EnumSoil.FARMLAND && downBlock.func_177230_c() == IUItem.humus || crop.getSoil() == EnumSoil.REDSTONE && downBlock.func_177230_c() == Blocks.field_150439_ay) {
            return crop.canGrowInBiome(biome);
        }
        return false;
    }

    public void addCrop(ICrop cropBase) {
        this.cropMap.putIfAbsent(cropBase.getId(), cropBase);
    }

    public boolean canGrow(World world, BlockPos pos, ChunkPos chunkPos, ICrop crop, Radiation radLevel, Chunk chunk, Biome biome, ChunkLevel chunkLevel) {
        boolean day;
        ChunkLevel air;
        int light;
        if ((radLevel == null || radLevel.getLevel().ordinal() <= crop.getRadiationRequirements().ordinal()) && this.isWaterNearby(world, pos, crop) && (light = chunk.func_177443_a(pos, 0)) >= crop.getLightLevel() && ((air = PollutionManager.pollutionManager.getChunkLevelAir(chunkPos)) == null || air.getLevelPollution().ordinal() <= crop.getAirRequirements().ordinal()) && (chunkLevel == null || chunkLevel.getLevelPollution().ordinal() <= crop.getSoilRequirements().ordinal()) && ((day = world.func_72935_r()) && crop.isSun() || !day && crop.isNight())) {
            boolean rain = world.func_72896_J();
            boolean thundering = world.func_72911_I();
            if (rain && crop.getWeatherResistance() >= 1 || thundering && crop.getWeatherResistance() >= 2 || !rain && !thundering) {
                return crop.canGrowInBiome(biome);
            }
        }
        return false;
    }

    public boolean canMultiGrow(World world, BlockPos pos, ChunkPos chunkPos, ICrop crop, Radiation radLevel, Chunk chunk, Biome biome, ChunkLevel chunkLevel) {
        boolean day;
        ChunkLevel air;
        int light;
        if (radLevel.getLevel().ordinal() <= crop.getRadiationRequirements().ordinal() && (light = chunk.func_177443_a(pos, 0)) >= crop.getLightLevel() && ((air = PollutionManager.pollutionManager.getChunkLevelAir(chunkPos)) == null || air.getLevelPollution().ordinal() <= crop.getAirRequirements().ordinal()) && (chunkLevel == null || chunkLevel.getLevelPollution().ordinal() <= crop.getSoilRequirements().ordinal()) && ((day = world.func_72935_r()) && crop.isSun() || !day && crop.isNight())) {
            boolean rain = world.func_72896_J();
            boolean thundering = world.func_72911_I();
            if (rain && crop.getWeatherResistance() >= 1 || thundering && crop.getWeatherResistance() >= 2 || !rain && !thundering) {
                return crop.canGrowInBiome(biome);
            }
        }
        return false;
    }

    public boolean isWaterNearby(World world, BlockPos pos, ICrop crop) {
        if (crop.getWaterRequirement() == 0) {
            return true;
        }
        int radius = crop.getWaterRequirement() + 1;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                BlockPos checkPos = pos.func_177982_a(x, -1, z);
                IBlockState state = world.func_180495_p(checkPos);
                if (state.func_177230_c() != Blocks.field_150355_j && state.func_177230_c() != Blocks.field_150358_i) continue;
                return true;
            }
        }
        return false;
    }
}

