/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.agriculture.genetics;

import com.denfop.api.agriculture.ICrop;
import com.denfop.api.agriculture.genetics.EnumGenetic;
import com.denfop.api.agriculture.genetics.GeneticTraits;
import com.denfop.api.agriculture.genetics.IGenome;
import com.denfop.api.pollution.LevelPollution;
import com.denfop.api.radiationsystem.EnumLevelRadiation;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class Genome
implements IGenome {
    public static Map<GeneticTraits, List<Biome>> geneticBiomes = new HashMap<GeneticTraits, List<Biome>>();
    Map<EnumGenetic, GeneticTraits> geneticTraitsMap = new HashMap<EnumGenetic, GeneticTraits>();
    private ItemStack stack;

    public Genome(ItemStack stack) {
        NBTTagCompound nbt;
        NBTTagCompound nbt1 = ModUtils.nbt(stack);
        if (!nbt1.func_74764_b("genome")) {
            nbt = new NBTTagCompound();
            nbt1.func_74782_a("genome", (NBTBase)nbt);
        }
        nbt = nbt1.func_74775_l("genome");
        NBTTagList tagList = nbt.func_150295_c("genomeList", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound genomeNbt = tagList.func_150305_b(i);
            byte meta = genomeNbt.func_74771_c("meta");
            GeneticTraits geneticTraits = GeneticTraits.values()[meta];
            this.geneticTraitsMap.put(geneticTraits.getGenetic(), geneticTraits);
        }
        this.stack = stack;
    }

    public Genome(Map<EnumGenetic, GeneticTraits> geneticTraitsMap) {
        this.geneticTraitsMap = new HashMap<EnumGenetic, GeneticTraits>(geneticTraitsMap);
    }

    private static GeneticTraits getTemperatureCategory(Biome biome) {
        if (biome.func_185353_n() < 0.1f) {
            return GeneticTraits.BIOME_IV;
        }
        if (biome.func_185353_n() < 0.5f) {
            return GeneticTraits.BIOME_III;
        }
        if (biome.func_185353_n() < 1.0f) {
            return GeneticTraits.BIOME;
        }
        if (biome.func_185353_n() < 1.5f) {
            return GeneticTraits.BIOME_I;
        }
        return GeneticTraits.BIOME_II;
    }

    public static void init() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            GeneticTraits geneticTraits = Genome.getTemperatureCategory(biome);
            List<Biome> biomes = geneticBiomes.get((Object)geneticTraits);
            if (biomes != null) {
                biomes.add(biome);
                continue;
            }
            biomes = new ArrayList<Biome>();
            biomes.add(biome);
            geneticBiomes.put(geneticTraits, biomes);
        }
    }

    public Map<EnumGenetic, GeneticTraits> getGeneticTraitsMap() {
        return this.geneticTraitsMap;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Genome genome = (Genome)o;
        return this.geneticTraitsMap.values().size() == genome.geneticTraitsMap.size() && this.checkGenomes(genome);
    }

    private boolean checkGenomes(Genome genome) {
        ArrayList<GeneticTraits> geneticTraits = new ArrayList<GeneticTraits>(genome.geneticTraitsMap.values());
        ArrayList<GeneticTraits> geneticTraits1 = new ArrayList<GeneticTraits>(this.geneticTraitsMap.values());
        geneticTraits1.removeIf(geneticTraits::contains);
        return geneticTraits1.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.geneticTraitsMap);
    }

    public void addGenome(GeneticTraits geneticTraits, ItemStack stack) {
        if (!this.geneticTraitsMap.containsKey((Object)geneticTraits.getGenetic())) {
            this.geneticTraitsMap.put(geneticTraits.getGenetic(), geneticTraits);
            this.writeNBT(ModUtils.nbt(stack));
        }
    }

    public void addGenome(GeneticTraits geneticTraits) {
        if (!this.geneticTraitsMap.containsKey((Object)geneticTraits.getGenetic())) {
            this.geneticTraitsMap.put(geneticTraits.getGenetic(), geneticTraits);
            this.writeNBT(ModUtils.nbt(this.stack));
        }
    }

    public void removeGenome(GeneticTraits geneticTraits, ItemStack stack) {
        if (this.geneticTraitsMap.containsKey((Object)geneticTraits.getGenetic())) {
            this.geneticTraitsMap.remove((Object)geneticTraits.getGenetic(), (Object)geneticTraits);
            this.writeNBT(ModUtils.nbt(stack));
        }
    }

    public GeneticTraits removeGenome(EnumGenetic genetic, ItemStack stack) {
        if (this.geneticTraitsMap.containsKey((Object)genetic)) {
            GeneticTraits value = this.geneticTraitsMap.remove((Object)genetic);
            this.writeNBT(ModUtils.nbt(stack));
            return value;
        }
        return null;
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList genomeNBT = new NBTTagList();
        for (GeneticTraits geneticTraits : this.geneticTraitsMap.values()) {
            NBTTagCompound nbtTagCompound1 = new NBTTagCompound();
            nbtTagCompound1.func_74774_a("meta", (byte)geneticTraits.ordinal());
            genomeNBT.func_74742_a((NBTBase)nbtTagCompound1);
        }
        NBTTagCompound nbt = nbtTagCompound.func_74775_l("genome");
        nbt.func_74782_a("genomeList", (NBTBase)genomeNBT);
        nbtTagCompound.func_74782_a("genome", (NBTBase)nbt);
        return nbtTagCompound;
    }

    @Override
    public boolean hasGenome(EnumGenetic genome) {
        return this.geneticTraitsMap.containsKey((Object)genome);
    }

    @Override
    public <T> T getLevelGenome(EnumGenetic genome, Class<T> tClass) {
        return this.geneticTraitsMap.get((Object)genome).getValue(tClass);
    }

    @Override
    public GeneticTraits getGenome(EnumGenetic genome) {
        return this.geneticTraitsMap.get((Object)genome);
    }

    @Override
    public Genome copy() {
        Genome genome = new Genome(this.geneticTraitsMap);
        genome.stack = this.stack.func_77946_l();
        return genome;
    }

    @Override
    public void loadCrop(ICrop crop) {
        for (GeneticTraits geneticTraits : this.geneticTraitsMap.values()) {
            switch (geneticTraits) {
                case SUN: {
                    crop.setSun(true);
                    break;
                }
                case BIOME: 
                case BIOME_I: 
                case BIOME_II: 
                case BIOME_III: 
                case BIOME_IV: {
                    List<Biome> biomes = geneticBiomes.get((Object)geneticTraits);
                    biomes.forEach(crop::addBiome);
                    break;
                }
                case AIR_I: 
                case AIR_II: 
                case AIR_III: {
                    crop.setAirRequirements(geneticTraits.getValue(LevelPollution.class));
                    break;
                }
                case SOIL_I: 
                case SOIL_II: 
                case SOIL_III: {
                    crop.setSoilRequirements(geneticTraits.getValue(LevelPollution.class));
                    break;
                }
                case WATER: {
                    crop.setWaterRequirement(0);
                    break;
                }
                case PEST_I: 
                case PEST_II: 
                case PEST_III: {
                    crop.setPestResistance(geneticTraits.getValue(Integer.class));
                    break;
                }
                case WEED_I: 
                case WEED_II: 
                case WEED_III: {
                    crop.addChanceWeed(geneticTraits.getValue(Integer.class));
                    break;
                }
                case LIGHT_I: 
                case LIGHT_II: 
                case LIGHT_III: 
                case LIGHT_IV: {
                    crop.setLight(geneticTraits.getValue(Integer.class));
                    break;
                }
                case RADIATION_I: 
                case RADIATION_II: 
                case RADIATION_III: {
                    crop.setRadiationRequirements(geneticTraits.getValue(EnumLevelRadiation.class));
                    break;
                }
                case SEED_I: 
                case SEED_II: 
                case SEED_III: {
                    crop.addSizeSeed(geneticTraits.getValue(Integer.class));
                    break;
                }
                case YIELD_I: 
                case YIELD_II: 
                case YIELD_III: {
                    crop.setYield(geneticTraits.getValue(Integer.class));
                    break;
                }
                case BEECOMBINE: {
                    crop.setBeeCombine(true);
                    break;
                }
                case NIGHT_GROW: {
                    crop.setNight(true);
                    break;
                }
                case SOIL_BLOCK: {
                    crop.setIgnoreSoil(true);
                    break;
                }
                case CHANCE_I: 
                case CHANCE_II: 
                case CHANCE_III: {
                    crop.setChance(geneticTraits.getValue(Integer.class));
                    break;
                }
                case GROW_SPEED_I: 
                case GROW_SPEED_II: 
                case GROW_SPEED_III: {
                    crop.setGrowthSpeed(geneticTraits.getValue(Double.class));
                    break;
                }
                case WEATHER_I: 
                case WEATHER_II: {
                    crop.setWeatherResistance(geneticTraits.getValue(Integer.class));
                    break;
                }
                case GENOME_ADAPTIVE_I: 
                case GENOME_ADAPTIVE_II: 
                case GENOME_ADAPTIVE_III: {
                    crop.setGenomeAdaptive(geneticTraits.getValue(Integer.class));
                    break;
                }
                case GENOME_RESISTANCE_I: 
                case GENOME_RESISTANCE_II: 
                case GENOME_RESISTANCE_III: {
                    crop.setGenomeResistance(geneticTraits.getValue(Integer.class));
                }
            }
        }
    }
}

