/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.bee;

import com.denfop.api.agriculture.ICrop;
import com.denfop.api.bee.BeeNetwork;
import com.denfop.api.bee.IBee;
import com.denfop.api.bee.Product;
import com.denfop.network.packet.CustomPacketBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.biome.Biome;

public class BeeBase
implements IBee {
    private final int weatherResistance;
    private final int maxSwarm;
    private final ICrop cropFlower;
    private final int id;
    private final List<Biome> biomes = new ArrayList<Biome>();
    private final int offspring;
    private final AxisAlignedBB sizeTerritory;
    private final int tickLifecycles;
    private final double maxMortalityRate;
    private final int tickBirthRate;
    private final List<Product> products = new ArrayList<Product>();
    private final String name;
    private List<IBee> unCompatibleBees;
    private boolean sun;
    private boolean night;
    private int chance;

    public BeeBase(String name, int id, int maxSwarm, int tickBirthRate, int tickLifecycles, AxisAlignedBB sizeTerritory, int offspring, int chance, boolean sun, boolean night, ICrop cropFlower, List<IBee> unCompatibleBees, int defaultWeatherResistance, double maxMortalityRate) {
        this.name = name;
        this.maxSwarm = maxSwarm;
        this.chance = chance;
        this.id = id;
        this.maxMortalityRate = maxMortalityRate;
        this.weatherResistance = defaultWeatherResistance;
        this.tickBirthRate = tickBirthRate;
        this.tickLifecycles = tickLifecycles;
        this.sizeTerritory = sizeTerritory;
        this.sun = sun;
        this.night = night;
        this.unCompatibleBees = unCompatibleBees;
        this.cropFlower = cropFlower;
        this.offspring = offspring;
        BeeNetwork.instance.addBee(this);
    }

    @Override
    public int getMaxSwarm() {
        return this.maxSwarm;
    }

    @Override
    public BeeBase copy() {
        BeeBase bee = new BeeBase(this.name, this.id, this.maxSwarm, this.tickBirthRate, this.tickLifecycles, this.sizeTerritory, this.offspring, this.chance, this.sun, this.night, this.cropFlower, new ArrayList<IBee>(this.unCompatibleBees), this.weatherResistance, this.maxMortalityRate);
        for (Biome biome : this.biomes) {
            bee.addBiome(biome);
        }
        return bee;
    }

    @Override
    public ICrop getCropFlower() {
        return this.cropFlower;
    }

    @Override
    public List<IBee> getUnCompatibleBees() {
        return this.unCompatibleBees;
    }

    @Override
    public void setUnCompatibleBees(List<IBee> bees) {
        this.unCompatibleBees = bees;
    }

    @Override
    public boolean isSun() {
        return this.sun;
    }

    @Override
    public boolean isNight() {
        return this.night;
    }

    @Override
    public int getWeatherResistance() {
        return this.weatherResistance;
    }

    @Override
    public int getChance() {
        return this.chance;
    }

    @Override
    public void setChance(int chance) {
        this.chance = chance;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public List<Biome> getBiomes() {
        return this.biomes;
    }

    @Override
    public boolean canWorkInBiome(Biome biomeName) {
        return this.biomes.contains(biomeName);
    }

    @Override
    public void addBiome(Biome biomeName) {
        this.biomes.add(biomeName);
    }

    @Override
    public int getOffspring() {
        return this.offspring;
    }

    @Override
    public AxisAlignedBB getSizeTerritory() {
        return this.sizeTerritory;
    }

    @Override
    public int getTickLifecycles() {
        return this.tickLifecycles;
    }

    @Override
    public double getMaxMortalityRate() {
        return this.maxMortalityRate;
    }

    @Override
    public int getTickBirthRate() {
        return this.tickBirthRate;
    }

    @Override
    public List<Product> getProduct() {
        return this.products;
    }

    @Override
    public void addPercentProduct(ICrop crop, double percent) {
        double totalChance = this.products.stream().mapToDouble(Product::getChance).sum();
        boolean find = false;
        if (totalChance <= 99.5) {
            for (Product product : this.products) {
                if (!product.equals(crop)) continue;
                product.addChance(0.1);
                find = true;
                break;
            }
            if (!find) {
                this.products.add(new Product(percent, crop));
            }
        } else {
            Product product1 = null;
            for (Product product : this.products) {
                if (!product.equals(crop)) continue;
                product1 = product;
                find = true;
                break;
            }
            if (product1 != null && this.products.size() == 1) {
                return;
            }
            this.products.sort((p1, p2) -> Double.compare(p2.getChance(), p1.getChance()));
            Iterator<Product> iter = this.products.iterator();
            if (find) {
                double total = percent / (double)(this.products.size() - 1);
                int count = 0;
                while (iter.hasNext()) {
                    Product product = iter.next();
                    if (!product.equals(crop) && product.getChance() < total) {
                        double total1 = product.getChance() - total;
                        total += total1 / (double)(this.products.size() - 1 - count);
                    }
                    if (!(product.getChance() <= 0.0)) continue;
                    iter.remove();
                }
                product1.addChance(percent);
            } else {
                double total = percent / (double)this.products.size();
                int count = 0;
                while (iter.hasNext()) {
                    Product product = iter.next();
                    if (product.getChance() < total) {
                        double total1 = product.getChance() - total;
                        total += total1 / (double)(this.products.size() - count);
                    }
                    if (!(product.getChance() <= 0.0)) continue;
                    iter.remove();
                }
                this.products.add(new Product(percent, crop));
            }
        }
    }

    @Override
    public void removeAllPercent(double range) {
        Iterator<Product> iter = this.products.iterator();
        while (iter.hasNext()) {
            Product product = iter.next();
            product.removeChance(range);
            if (!(product.getChance() <= 0.0)) continue;
            iter.remove();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void readPacket(CustomPacketBuffer buffer) {
    }

    @Override
    public CustomPacketBuffer writePacket() {
        return null;
    }
}

