/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.bee.genetics;

import com.denfop.api.bee.genetics.EnumGenetic;
import com.denfop.api.bee.genetics.GeneticTraits;
import com.denfop.api.bee.genetics.IGenome;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class Genome
implements IGenome {
    Map<EnumGenetic, GeneticTraits> geneticTraitsMap = new HashMap<EnumGenetic, GeneticTraits>();
    private ItemStack stack;

    public Genome(ItemStack stack) {
        NBTTagCompound nbt;
        NBTTagCompound nbt1 = ModUtils.nbt(stack);
        if (!nbt1.func_74764_b("genome")) {
            nbt = new NBTTagCompound();
            nbt1.func_74782_a("genome", (NBTBase)nbt);
        }
        nbt = nbt1.func_74775_l("genome");
        NBTTagList tagList = nbt.func_150295_c("genomeList", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound genomeNbt = tagList.func_150305_b(i);
            byte meta = genomeNbt.func_74771_c("meta");
            GeneticTraits geneticTraits = GeneticTraits.values()[meta];
            this.geneticTraitsMap.put(geneticTraits.getGenetic(), geneticTraits);
        }
        this.stack = stack;
    }

    public Genome(Map<EnumGenetic, GeneticTraits> geneticTraitsMap) {
        this.geneticTraitsMap = new HashMap<EnumGenetic, GeneticTraits>(geneticTraitsMap);
    }

    public Map<EnumGenetic, GeneticTraits> getGeneticTraitsMap() {
        return this.geneticTraitsMap;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Genome genome = (Genome)o;
        return this.geneticTraitsMap.values().size() == genome.geneticTraitsMap.size() && this.checkGenomes(genome);
    }

    private boolean checkGenomes(Genome genome) {
        ArrayList<GeneticTraits> geneticTraits = new ArrayList<GeneticTraits>(genome.geneticTraitsMap.values());
        ArrayList<GeneticTraits> geneticTraits1 = new ArrayList<GeneticTraits>(this.geneticTraitsMap.values());
        geneticTraits1.removeIf(geneticTraits::contains);
        return geneticTraits1.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.geneticTraitsMap);
    }

    public void addGenome(GeneticTraits geneticTraits, ItemStack stack) {
        if (!this.geneticTraitsMap.containsKey((Object)geneticTraits.getGenetic())) {
            this.geneticTraitsMap.put(geneticTraits.getGenetic(), geneticTraits);
            this.writeNBT(ModUtils.nbt(stack));
        }
    }

    public void addGenome(GeneticTraits geneticTraits) {
        if (!this.geneticTraitsMap.containsKey((Object)geneticTraits.getGenetic())) {
            this.geneticTraitsMap.put(geneticTraits.getGenetic(), geneticTraits);
            this.writeNBT(ModUtils.nbt(this.stack));
        }
    }

    public void removeGenome(GeneticTraits geneticTraits, ItemStack stack) {
        if (this.geneticTraitsMap.containsKey((Object)geneticTraits.getGenetic())) {
            this.geneticTraitsMap.remove((Object)geneticTraits.getGenetic(), (Object)geneticTraits);
            this.writeNBT(ModUtils.nbt(stack));
        }
    }

    public GeneticTraits removeGenome(EnumGenetic genetic, ItemStack stack) {
        if (this.geneticTraitsMap.containsKey((Object)genetic)) {
            GeneticTraits value = this.geneticTraitsMap.remove((Object)genetic);
            this.writeNBT(ModUtils.nbt(stack));
            return value;
        }
        return null;
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList genomeNBT = new NBTTagList();
        for (GeneticTraits geneticTraits : this.geneticTraitsMap.values()) {
            NBTTagCompound nbtTagCompound1 = new NBTTagCompound();
            nbtTagCompound1.func_74774_a("meta", (byte)geneticTraits.ordinal());
            genomeNBT.func_74742_a((NBTBase)nbtTagCompound1);
        }
        NBTTagCompound nbt = nbtTagCompound.func_74775_l("genome");
        nbt.func_74782_a("genomeList", (NBTBase)genomeNBT);
        nbtTagCompound.func_74782_a("genome", (NBTBase)nbt);
        return nbtTagCompound;
    }

    @Override
    public boolean hasGenome(EnumGenetic genome) {
        return this.geneticTraitsMap.containsKey((Object)genome);
    }

    @Override
    public <T> T getLevelGenome(EnumGenetic genome, Class<T> tClass) {
        return this.geneticTraitsMap.get((Object)genome).getValue(tClass);
    }

    @Override
    public GeneticTraits getGenome(EnumGenetic genome) {
        return this.geneticTraitsMap.get((Object)genome);
    }

    @Override
    public Genome copy() {
        Genome genome = new Genome(this.geneticTraitsMap);
        genome.stack = this.stack.func_77946_l();
        return genome;
    }
}

