/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.gasvein;

import com.denfop.api.gasvein.IGasVein;
import com.denfop.api.gasvein.TypeGas;
import com.denfop.network.packet.CustomPacketBuffer;
import java.util.Objects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;

public class GasVein
implements IGasVein {
    private final ChunkPos chunk;
    boolean find;
    private TypeGas type;
    private int col;
    private int maxcol;

    public GasVein(TypeGas type, ChunkPos chunk) {
        this.type = type;
        this.chunk = chunk;
        this.col = 0;
        this.maxcol = 0;
    }

    public GasVein(NBTTagCompound tagCompound) {
        this.type = TypeGas.values()[tagCompound.func_74771_c("type")];
        this.chunk = new ChunkPos((int)tagCompound.func_74765_d("x"), (int)tagCompound.func_74765_d("z"));
        this.col = tagCompound.func_74762_e("col");
        this.maxcol = tagCompound.func_74762_e("maxcol");
        this.find = tagCompound.func_74767_n("find");
        if (!this.find && this.col != this.maxcol) {
            this.find = true;
        }
    }

    public GasVein(CustomPacketBuffer is) {
        this.find = is.readBoolean();
        this.chunk = new ChunkPos((int)is.readShort(), (int)is.readShort());
        this.type = TypeGas.values()[is.readByte()];
        this.col = is.readInt();
        this.maxcol = is.readInt();
        if (!this.find && this.col != this.maxcol) {
            this.find = true;
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = new CustomPacketBuffer(32);
        customPacketBuffer.writeBoolean(this.find);
        customPacketBuffer.writeShort(this.chunk.field_77276_a);
        customPacketBuffer.writeShort(this.chunk.field_77275_b);
        customPacketBuffer.writeByte(this.type.ordinal());
        customPacketBuffer.writeInt(this.col);
        customPacketBuffer.writeInt(this.maxcol);
        return customPacketBuffer;
    }

    @Override
    public TypeGas getType() {
        return this.type;
    }

    @Override
    public void setType(TypeGas type) {
        this.type = type;
    }

    @Override
    public ChunkPos getChunk() {
        return this.chunk;
    }

    @Override
    public int getCol() {
        return this.col;
    }

    @Override
    public void setCol(int col) {
        this.col = col;
    }

    @Override
    public int getMaxCol() {
        return this.maxcol;
    }

    @Override
    public void setMaxCol(int maxcol) {
        this.maxcol = maxcol;
    }

    @Override
    public void removeCol(int col) {
        assert (this.col - col >= 0);
        this.col -= col;
    }

    @Override
    public boolean isFind() {
        return this.find;
    }

    @Override
    public void setFind(boolean find) {
        this.find = find;
    }

    @Override
    public NBTTagCompound writeTag() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74757_a("find", this.find);
        tagCompound.func_74777_a("x", (short)this.chunk.field_77276_a);
        tagCompound.func_74777_a("z", (short)this.chunk.field_77275_b);
        tagCompound.func_74774_a("type", (byte)this.type.ordinal());
        tagCompound.func_74768_a("col", this.col);
        tagCompound.func_74768_a("maxcol", this.maxcol);
        return tagCompound;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GasVein vein = (GasVein)o;
        return vein.chunk.equals((Object)this.chunk);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.chunk, this.find, this.type, this.col, this.maxcol});
    }
}

