/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.gui;

import com.denfop.Localization;
import com.denfop.api.gui.GuiElement;
import com.denfop.gui.GuiCore;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidItem
extends GuiElement<FluidItem> {
    private final FluidStack fluid;

    public FluidItem(GuiCore<?> gui, int x, int y, FluidStack fluid) {
        super(gui, x, y, 18, 18);
        this.fluid = fluid;
    }

    public static FluidItem createFluidSlot(GuiCore<?> gui, int x, int y, FluidStack fluid) {
        return new FluidItem(gui, x, y, fluid);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        if (mouseX >= this.x && mouseX <= this.x + 18 && mouseY >= this.y && mouseY <= this.y + 18) {
            String tooltip;
            List<String> lines = this.getToolTip();
            if (this.getTooltipProvider() != null && (tooltip = (String)this.getTooltipProvider().get()) != null && !tooltip.isEmpty()) {
                FluidItem.addLines(lines, tooltip);
            }
            if (!lines.isEmpty()) {
                this.gui.drawTooltip(mouseX, mouseY, lines);
            }
        }
    }

    @Override
    public void drawBackground(int mouseX, int mouseY) {
        FluidItem.bindCommonTexture();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FluidStack fs = this.fluid;
        if (fs != null && fs.amount > 0) {
            int fluidX = this.x + 1;
            int fluidY = this.y + 1;
            int fluidWidth = 16;
            int fluidHeight = 16;
            Fluid fluid = fs.getFluid();
            TextureAtlasSprite sprite = fluid != null ? FluidItem.getBlockTextureMap().func_110572_b(fluid.getStill(fs).toString()) : null;
            int color = fluid != null ? fluid.getColor(fs) : -1;
            FluidItem.bindBlockTexture();
            this.gui.drawSprite(fluidX, fluidY, fluidWidth, fluidHeight, sprite, color, 1.0, false, false);
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(commonTexture1);
    }

    @Override
    protected List<String> getToolTip() {
        List<String> ret = super.getToolTip();
        FluidStack fs = this.fluid;
        if (fs != null && fs.amount > 0) {
            Fluid fluid = fs.getFluid();
            if (fluid != null) {
                ret.add(fluid.getLocalizedName(fs));
                ret.add("Amount: " + fs.amount + " " + Localization.translate("iu.generic.text.mb"));
                String state = fs.getFluid().isGaseous() ? "Gas" : "Liquid";
                ret.add("Type: " + state);
            } else {
                ret.add("Invalid FluidStack instance.");
            }
        } else {
            ret.add("No Fluid");
            ret.add("Amount: 0 " + Localization.translate("iu.generic.text.mb"));
            ret.add("Type: Not Available");
        }
        return ret;
    }
}

