/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.gui;

import com.denfop.Localization;
import com.denfop.api.gui.MouseButton;
import com.denfop.api.gui.ScrollDirection;
import com.denfop.container.ContainerBase;
import com.denfop.gui.GuiCore;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;

public abstract class GuiElement<T extends GuiElement<T>> {
    public static final ResourceLocation commonTexture = new ResourceLocation("industrialupgrade", "textures/gui/common.png");
    public static final ResourceLocation commonTexture1 = new ResourceLocation("industrialupgrade", "textures/gui/gui_progressbars.png");
    public static final ResourceLocation commonTexture2 = new ResourceLocation("industrialupgrade", "textures/gui/gui_progressbars1.png");
    public static final ResourceLocation commonTexture3 = new ResourceLocation("industrialupgrade", "textures/gui/steam_progressbars.png");
    public static final ResourceLocation commonTexture4 = new ResourceLocation("industrialupgrade", "textures/gui/bio_progressbars.png");
    public static final ResourceLocation commonTexture5 = new ResourceLocation("industrialupgrade", "textures/gui/guispace_progress.png");
    protected GuiCore<?> gui;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    private Supplier<String> tooltipProvider;

    protected GuiElement(GuiCore<?> gui, int x, int y, int width, int height) {
        if (width < 0) {
            throw new IllegalArgumentException("negative width");
        }
        if (height < 0) {
            throw new IllegalArgumentException("negative height");
        }
        this.gui = gui;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public static void addLines(List<String> list, String str) {
        int pos;
        int startPos = 0;
        while ((pos = str.indexOf(10, startPos)) != -1) {
            list.add(GuiElement.processText(str.substring(startPos, pos)));
            startPos = pos + 1;
        }
        if (startPos == 0) {
            list.add(GuiElement.processText(str));
        } else {
            list.add(GuiElement.processText(str.substring(startPos)));
        }
    }

    protected static String processText(String text) {
        return Localization.translate(text);
    }

    protected static void bindTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }

    public static void bindCommonTexture() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(commonTexture);
    }

    public static void bindCommonTexture1() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(commonTexture1);
    }

    public static void bindCommonTexture2() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(commonTexture2);
    }

    public static void bindCommonTexture3() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(commonTexture3);
    }

    public static void bindCommonTexture4() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(commonTexture4);
    }

    public static void bindCommonTexture5() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(commonTexture5);
    }

    public static void bindBlockTexture() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
    }

    public static TextureMap getBlockTextureMap() {
        return Minecraft.func_71410_x().func_147117_R();
    }

    public boolean visible() {
        return true;
    }

    public GuiCore<?> getGui() {
        return this.gui;
    }

    public void setGui(GuiCore<?> gui) {
        this.gui = gui;
    }

    public boolean contains(int x, int y) {
        return x >= this.x && x <= this.x + this.width && y >= this.y && y <= this.y + this.height;
    }

    public T withTooltip(String tooltip) {
        return this.withTooltip((Supplier<String>)Suppliers.ofInstance((Object)tooltip));
    }

    public T withTooltip(Supplier<String> tooltipProvider) {
        this.tooltipProvider = tooltipProvider;
        return (T)this;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Supplier<String> getTooltipProvider() {
        return this.tooltipProvider;
    }

    public void tick() {
    }

    public void drawBackground(int mouseX, int mouseY) {
    }

    public void drawForeground(int mouseX, int mouseY) {
        if (this.contains(mouseX, mouseY) && !this.suppressTooltip(mouseX, mouseY)) {
            String tooltip;
            List<String> lines = this.getToolTip();
            if (this.tooltipProvider != null && (tooltip = (String)this.tooltipProvider.get()) != null && !tooltip.isEmpty()) {
                GuiElement.addLines(lines, tooltip);
            }
            if (!lines.isEmpty()) {
                this.gui.drawTooltip(mouseX, mouseY, lines);
            }
        }
    }

    public boolean onMouseClick(int mouseX, int mouseY, MouseButton button, boolean onThis) {
        return onThis && this.onMouseClick(mouseX, mouseY, button);
    }

    protected boolean onMouseClick(int mouseX, int mouseY, MouseButton button) {
        return false;
    }

    public boolean onMouseDrag(int mouseX, int mouseY, MouseButton button, long timeFromLastClick, boolean onThis) {
        return onThis && this.onMouseDrag(mouseX, mouseY, button, timeFromLastClick);
    }

    protected boolean onMouseDrag(int mouseX, int mouseY, MouseButton button, long timeFromLastClick) {
        return false;
    }

    public boolean onMouseRelease(int mouseX, int mouseY, MouseButton button, boolean onThis) {
        return onThis && this.onMouseRelease(mouseX, mouseY, button);
    }

    protected boolean onMouseRelease(int mouseX, int mouseY, MouseButton button) {
        return false;
    }

    public void onMouseScroll(int mouseX, int mouseY, ScrollDirection direction) {
    }

    public boolean onKeyTyped(char typedChar, int keyCode) {
        return false;
    }

    protected boolean suppressTooltip(int mouseX, int mouseY) {
        return false;
    }

    protected List<String> getToolTip() {
        return new ArrayList<String>();
    }

    protected final IInventory getBase() {
        return ((ContainerBase)((Object)this.gui.getContainer())).base;
    }

    public void addY(int height) {
        this.y += height;
    }
}

