/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.gui;

import com.denfop.Localization;
import com.denfop.api.gui.GuiElement;
import com.denfop.api.gui.TankGauge;
import com.denfop.blocks.FluidName;
import com.denfop.componets.Fluids;
import com.denfop.gui.GuiCore;
import com.denfop.utils.ModUtils;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class TanksGauge
extends GuiElement<TankGauge> {
    public static final int v = 100;
    private final List<Fluids.InternalFluidTank> tank;
    private final TankGuiStyle style;

    private TanksGauge(GuiCore<?> gui, int x, int y, int width, int height, List<Fluids.InternalFluidTank> tank, TankGuiStyle style) {
        super(gui, x, y, width, height);
        if (tank == null) {
            throw new NullPointerException("null tank");
        }
        this.tank = tank;
        this.style = style;
    }

    public static TanksGauge createNormal(GuiCore<?> gui, int x, int y, List<Fluids.InternalFluidTank> tank) {
        return new TanksGauge(gui, x, y, 20, 55, tank, TankGuiStyle.Normal);
    }

    public static TanksGauge createPlain(GuiCore<?> gui, int x, int y, int width, int height, List<Fluids.InternalFluidTank> tank) {
        return new TanksGauge(gui, x, y, width, height, tank, TankGuiStyle.Plain);
    }

    public static TanksGauge createBorderless(GuiCore<?> gui, int x, int y, List<Fluids.InternalFluidTank> tank, boolean mirrored) {
        return new TanksGauge(gui, x, y, 12, 47, tank, mirrored ? TankGuiStyle.BorderlessMirrored : TankGuiStyle.Borderless);
    }

    @Override
    public void drawBackground(int mouseX, int mouseY) {
        TanksGauge.bindCommonTexture();
        FluidStack fs = null;
        int amount = 0;
        int capacity = 0;
        for (Fluids.InternalFluidTank tank1 : this.tank) {
            if (fs == null && tank1.getFluid() != null) {
                fs = tank1.getFluid();
            }
            amount += tank1.getFluidAmount();
            capacity += tank1.getCapacity();
        }
        if (fs != null && fs.amount > 0) {
            Fluid fluid;
            if (this.style.withBorder) {
                this.gui.drawTexturedRect(this.x, this.y, this.width, this.height, 6.0, 100.0);
            }
            int fluidX = this.x;
            int fluidY = this.y;
            int fluidWidth = this.width;
            int fluidHeight = this.height;
            if (this.style.withBorder) {
                fluidX += 4;
                fluidY += 4;
                fluidWidth = 12;
                fluidHeight = 47;
            }
            TextureAtlasSprite sprite = (fluid = fs.getFluid()) != null ? TanksGauge.getBlockTextureMap().func_110572_b(FluidName.isFluid(fluid).getStill(fs).toString()) : null;
            int color = fluid != null ? fluid.getColor(fs) : -1;
            double renderHeight = (double)fluidHeight * ModUtils.limit((double)amount / (double)capacity, 0.0, 1.0);
            TanksGauge.bindBlockTexture();
            this.gui.drawSprite(fluidX, (double)(fluidY + fluidHeight) - renderHeight, fluidWidth, renderHeight, sprite, color, 1.0, false, true);
            if (this.style.withGauge) {
                TanksGauge.bindCommonTexture();
                int gaugeX = this.x;
                int gaugeY = this.y;
                if (!this.style.withBorder) {
                    gaugeX -= 4;
                    gaugeY -= 4;
                }
                this.gui.drawTexturedRect(gaugeX, gaugeY, 20.0, 55.0, 38.0, 100.0, this.style.mirrorGauge);
            }
        } else if (this.style.withBorder) {
            this.gui.drawTexturedRect(this.x, this.y, this.width, this.height, 70.0, 100.0, this.style.mirrorGauge);
        } else if (this.style.withGauge) {
            this.gui.drawTexturedRect(this.x, this.y, this.width, this.height, 74.0, 104.0, this.style.mirrorGauge);
        }
    }

    @Override
    protected List<String> getToolTip() {
        List<String> ret = super.getToolTip();
        FluidStack fs = null;
        int amount = 0;
        for (Fluids.InternalFluidTank tank1 : this.tank) {
            if (fs == null && tank1.getFluid() != null) {
                fs = tank1.getFluid();
            }
            amount += tank1.getFluidAmount();
        }
        if (fs != null && amount > 0) {
            Fluid fluid = fs.getFluid();
            if (fluid != null) {
                ret.add(fluid.getLocalizedName(fs) + ": " + amount + " " + Localization.translate("iu.generic.text.mb"));
            } else {
                ret.add("invalid fluid stack");
            }
        } else {
            ret.add(Localization.translate("iu.generic.text.empty"));
        }
        return ret;
    }

    private static enum TankGuiStyle {
        Normal(true, true, false),
        Borderless(false, true, false),
        BorderlessMirrored(false, true, true),
        Plain(false, false, false);

        public final boolean withBorder;
        public final boolean withGauge;
        public final boolean mirrorGauge;

        private TankGuiStyle(boolean withBorder, boolean withGauge, boolean mirrorGauge) {
            this.withBorder = withBorder;
            this.withGauge = withGauge;
            this.mirrorGauge = mirrorGauge;
        }
    }
}

