/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.guidebook;

import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.guidebook.GuideBookCore;
import com.denfop.api.guidebook.GuideTab;
import com.denfop.api.guidebook.Shape;
import com.denfop.api.guidebook.TypeObject;
import com.denfop.api.guidebook.TypeQuest;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Quest {
    public Shape prevShape;
    public ItemStack icon;
    public boolean hasPrev = false;
    public String localizedName;
    public String unLocalizedName;
    public Shape shape;
    public TypeQuest typeQuest;
    public TypeObject typeObject;
    public List<ItemStack> itemStacks;
    public List<FluidStack> fluidStacks;
    public String prevName;
    public String localizedDescription;
    public int prevX;
    public int prevY;
    public int x;
    public int y;

    private Quest(int x, int y, String unLocalizedName, String unLocalizedDescription, Shape shape, TypeQuest typeQuest, TypeObject typeObject, List<ItemStack> itemStacks, List<FluidStack> fluidStacks, GuideTab guideTab, String prev, ItemStack icon, boolean localizationItem, boolean itemInform, boolean noDescription) {
        this.x = x;
        this.y = y;
        this.unLocalizedName = unLocalizedName;
        this.localizedName = Localization.translate(unLocalizedName);
        this.localizedDescription = Localization.translate(unLocalizedDescription);
        if (noDescription) {
            this.localizedDescription = "";
        }
        this.shape = shape;
        this.typeQuest = typeQuest;
        this.fluidStacks = Collections.unmodifiableList(fluidStacks);
        this.itemStacks = Collections.unmodifiableList(itemStacks);
        this.typeObject = typeObject;
        GuideBookCore.instance.addQuestToTab(this, guideTab);
        if (!prev.isEmpty()) {
            Quest prevQuest = GuideBookCore.instance.getPrev("iu.guide_quest_name." + prev, guideTab);
            this.prevX = prevQuest.x;
            this.prevY = prevQuest.y;
            this.hasPrev = true;
            this.prevName = prevQuest.unLocalizedName;
            this.prevShape = prevQuest.shape;
        }
        this.icon = icon;
        if (this.icon == null) {
            this.icon = !this.itemStacks.isEmpty() ? this.itemStacks.get(0) : (!this.fluidStacks.isEmpty() ? ModUtils.getCellFromFluid(this.fluidStacks.get(0).getFluid()) : new ItemStack(Blocks.field_150347_e));
        }
        if (localizationItem) {
            this.localizedName = this.icon.func_82833_r();
            if (itemStacks.isEmpty() && !fluidStacks.isEmpty()) {
                this.localizedName = fluidStacks.get(0).getLocalizedName();
            }
        }
        if (itemInform && IUCore.network.getClient() != null) {
            this.localizedDescription = this.getLocalization(this.icon);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private String getLocalization(ItemStack icon) {
        ArrayList information = new ArrayList();
        icon.func_77973_b().func_77624_a(icon, (World)Minecraft.func_71410_x().field_71441_e, information, null);
        return String.join((CharSequence)" ", information);
    }

    public static final class Builder {
        private String unLocalizedName = "";
        private Shape shape = Shape.DEFAULT;
        private TypeQuest typeQuest = TypeQuest.DETECT;
        private TypeObject typeObject = TypeObject.FLUID_ITEM;
        List<ItemStack> itemStacks = new ArrayList<ItemStack>();
        List<FluidStack> fluidStacks = new ArrayList<FluidStack>();
        private GuideTab guideTab;
        private String unLocalizedDescription;
        private String prev;
        private int x;
        private int y;
        private ItemStack icon;
        private boolean localizationItem;
        private boolean itemInform;
        private boolean noDescription;

        public Builder() {
            this.guideTab = GuideBookCore.instance.guideTabs.get(0);
            this.unLocalizedDescription = "";
            this.prev = "";
            this.localizationItem = false;
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(String name) {
            return new Builder().name(name);
        }

        public Builder name(String unLocalizedName) {
            this.unLocalizedName = "iu.guide_quest_name." + unLocalizedName;
            this.description(unLocalizedName);
            return this;
        }

        public Builder localizationItem() {
            this.localizationItem = true;
            return this;
        }

        public Builder noDescription() {
            this.noDescription = true;
            return this;
        }

        public Builder useItemInform() {
            this.itemInform = true;
            return this;
        }

        public Builder shape(Shape shape) {
            this.shape = shape;
            return this;
        }

        public Builder icon(ItemStack icon) {
            this.icon = icon;
            return this;
        }

        public Builder quest(TypeQuest typeQuest) {
            this.typeQuest = typeQuest;
            return this;
        }

        public Builder type(TypeObject typeObject) {
            this.typeObject = typeObject;
            return this;
        }

        public Builder itemStack(ItemStack itemStack) {
            if (this.typeObject.isItem()) {
                this.itemStacks.add(itemStack);
            }
            return this;
        }

        public Builder fluidStack(FluidStack fluidStack) {
            if (this.typeObject.isFluid()) {
                this.fluidStacks.add(fluidStack);
            }
            return this;
        }

        public Builder itemStack(ItemStack ... itemStack) {
            if (this.typeObject.isItem()) {
                this.itemStacks.addAll(Arrays.asList(itemStack));
            }
            return this;
        }

        public Builder fluidStack(FluidStack ... fluidStack) {
            if (this.typeObject.isFluid()) {
                this.fluidStacks.addAll(Arrays.asList(fluidStack));
            }
            return this;
        }

        public Builder itemStack(List<ItemStack> itemStack) {
            if (this.typeObject.isItem()) {
                this.itemStacks.addAll(itemStack);
            }
            return this;
        }

        public Builder fluidStack(List<FluidStack> fluidStack) {
            if (this.typeObject.isFluid()) {
                this.fluidStacks.addAll(fluidStack);
            }
            return this;
        }

        public Builder tab(GuideTab guideTab) {
            this.guideTab = guideTab;
            return this;
        }

        public Builder description(String unLocalizedDescription) {
            this.unLocalizedDescription = "iu.guide_quest_description." + unLocalizedDescription;
            return this;
        }

        public Builder prev(String prev) {
            this.prev = prev;
            return this;
        }

        public Builder position(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public void build() {
            new Quest(this.x, this.y, this.unLocalizedName, this.unLocalizedDescription, this.shape, this.typeQuest, this.typeObject, this.itemStacks, this.fluidStacks, this.guideTab, this.prev, this.icon, this.localizationItem, this.itemInform, this.noDescription);
        }
    }
}

