/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.item;

import com.denfop.api.radiationsystem.EnumLevelRadiation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;

public interface IHazmatLike {
    public static boolean hasCompleteHazmat(EntityLivingBase living) {
        return IHazmatLike.hasCompleteHazmat(living, EnumLevelRadiation.LOW);
    }

    public static boolean hasCompleteHazmat(EntityLivingBase living, EnumLevelRadiation levelRadiation) {
        EntityEquipmentSlot[] var1 = EntityEquipmentSlot.values();
        int var2 = var1.length;
        block8: for (EntityEquipmentSlot slot : var1) {
            if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR) continue;
            ItemStack stack = living.func_184582_a(slot);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IHazmatLike)) {
                return false;
            }
            IHazmatLike hazmat = (IHazmatLike)stack.func_77973_b();
            if (!hazmat.addsProtection(living, slot, stack)) {
                return false;
            }
            if (hazmat.fullyProtects(living, slot, stack)) {
                switch (levelRadiation) {
                    case LOW: 
                    case DEFAULT: 
                    case MEDIUM: {
                        return hazmat.getLevel() >= 1;
                    }
                    case HIGH: 
                    case VERY_HIGH: {
                        return hazmat.getLevel() > 1;
                    }
                }
                return false;
            }
            switch (levelRadiation) {
                case LOW: 
                case DEFAULT: 
                case MEDIUM: {
                    if (hazmat.getLevel() >= 1) continue block8;
                    return false;
                }
                case HIGH: 
                case VERY_HIGH: {
                    if (hazmat.getLevel() > 1) continue block8;
                    return false;
                }
            }
        }
        return true;
    }

    default public int getLevel() {
        return 1;
    }

    public boolean addsProtection(EntityLivingBase var1, EntityEquipmentSlot var2, ItemStack var3);

    default public boolean fullyProtects(EntityLivingBase entity, EntityEquipmentSlot slot, ItemStack stack) {
        return false;
    }
}

