/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.pollution;

import com.denfop.api.pollution.LevelPollution;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.INetworkObject;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;

public class ChunkLevel
implements INetworkObject {
    private ChunkPos pos;
    private ChunkPos defaultPos;
    private LevelPollution levelPollution;
    private double pollution;

    public ChunkLevel(ChunkPos pos, LevelPollution levelPollution, double pollution) {
        this.pos = pos;
        this.defaultPos = pos;
        this.levelPollution = levelPollution;
        this.pollution = pollution;
    }

    public ChunkLevel(NBTTagCompound tagCompound) {
        this.pollution = tagCompound.func_74769_h("pollution");
        this.levelPollution = LevelPollution.values()[tagCompound.func_74771_c("level")];
        this.pos = new ChunkPos(tagCompound.func_74762_e("x"), tagCompound.func_74762_e("z"));
        this.defaultPos = new ChunkPos(tagCompound.func_74762_e("x1"), tagCompound.func_74762_e("z1"));
    }

    public ChunkLevel(CustomPacketBuffer packetBuffer) {
        this.pollution = packetBuffer.readDouble();
        this.levelPollution = LevelPollution.values()[packetBuffer.readInt()];
        this.pos = new ChunkPos(packetBuffer.readInt(), packetBuffer.readInt());
        this.defaultPos = new ChunkPos(packetBuffer.readInt(), packetBuffer.readInt());
    }

    public NBTTagCompound writeCompound() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74780_a("pollution", this.pollution);
        tag.func_74774_a("level", (byte)this.levelPollution.ordinal());
        tag.func_74768_a("x", this.pos.field_77276_a);
        tag.func_74768_a("z", this.pos.field_77275_b);
        tag.func_74768_a("x1", this.defaultPos.field_77276_a);
        tag.func_74768_a("z1", this.defaultPos.field_77275_b);
        return tag;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = new CustomPacketBuffer();
        customPacketBuffer.writeDouble(this.pollution);
        customPacketBuffer.writeInt(this.levelPollution.ordinal());
        customPacketBuffer.writeInt(this.pos.field_77276_a);
        customPacketBuffer.writeInt(this.pos.field_77275_b);
        customPacketBuffer.writeInt(this.defaultPos.field_77276_a);
        customPacketBuffer.writeInt(this.defaultPos.field_77275_b);
        return customPacketBuffer;
    }

    public ChunkPos getDefaultPos() {
        return this.defaultPos;
    }

    public void setDefaultPos(ChunkPos defaultPos) {
        this.defaultPos = defaultPos;
    }

    public ChunkPos getPos() {
        return this.pos;
    }

    public void setPos(ChunkPos pos) {
        this.pos = pos;
    }

    public LevelPollution getLevelPollution() {
        return this.levelPollution;
    }

    public void setLevelPollution(LevelPollution levelPollution) {
        this.levelPollution = levelPollution;
    }

    public double getPollution() {
        return this.pollution;
    }

    public void setPollution(double pollution) {
        this.pollution = pollution;
    }

    public void addChunkPos(int x, int z) {
        this.pos = new ChunkPos(this.pos.field_77276_a + x, this.pos.field_77275_b + z);
    }

    public boolean removePollution(double pollution) {
        boolean removed;
        if (this.levelPollution == LevelPollution.VERY_LOW) {
            if (this.pollution == 0.0) {
                return false;
            }
            if (this.pollution == 124.0 && pollution == 125.0) {
                this.pollution = 0.0;
                return true;
            }
            if (this.pollution < pollution) {
                this.pollution = 0.0;
                return false;
            }
        }
        if (this.levelPollution == LevelPollution.LOW) {
            pollution /= 10.0;
        }
        if (this.levelPollution == LevelPollution.MEDIUM) {
            pollution /= 100.0;
        }
        if (this.levelPollution == LevelPollution.HIGH) {
            pollution /= 1000.0;
        }
        if (this.levelPollution == LevelPollution.VERY_HIGH) {
            pollution /= 10000.0;
        }
        if (this.pollution - pollution == 0.0) {
            this.pollution = this.levelPollution != LevelPollution.VERY_LOW ? 125.0 : 0.0;
            this.levelPollution = LevelPollution.values()[Math.max(this.levelPollution.ordinal() - 1, 0)];
            removed = true;
        } else if (this.pollution - pollution < 0.0) {
            this.pollution = 125.0 - (pollution - this.pollution);
            this.levelPollution = LevelPollution.values()[Math.max(this.levelPollution.ordinal() - 1, 0)];
            removed = true;
        } else {
            this.pollution -= pollution;
            pollution = 0.0;
            removed = true;
        }
        return removed;
    }

    public void addPollution(double pollution) {
        while (pollution > 0.0) {
            if (this.levelPollution == LevelPollution.LOW) {
                pollution /= 10.0;
            }
            if (this.levelPollution == LevelPollution.MEDIUM) {
                pollution /= 100.0;
            }
            if (this.levelPollution == LevelPollution.HIGH) {
                pollution /= 1000.0;
            }
            if (this.levelPollution == LevelPollution.VERY_HIGH) {
                pollution /= 10000.0;
            }
            if (this.pollution + pollution == 125.0) {
                pollution = 0.0;
                this.levelPollution = LevelPollution.values()[Math.min(this.levelPollution.ordinal() + 1, LevelPollution.values().length - 1)];
                continue;
            }
            if (this.pollution + pollution > 125.0) {
                this.pollution = 0.0;
                pollution -= 125.0 - this.pollution;
                this.levelPollution = LevelPollution.values()[Math.min(this.levelPollution.ordinal() + 1, LevelPollution.values().length - 1)];
                continue;
            }
            this.pollution += pollution;
            pollution = 0.0;
        }
    }
}

