/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.pollution;

import com.denfop.IUPotion;
import com.denfop.api.pollution.ChunkLevel;
import com.denfop.api.pollution.EventHandler;
import com.denfop.api.pollution.IPollutionMechanism;
import com.denfop.api.pollution.LevelPollution;
import com.denfop.api.pollution.Vec2f;
import com.denfop.api.windsystem.EnumTypeWind;
import com.denfop.api.windsystem.EnumWindSide;
import com.denfop.api.windsystem.IWindSystem;
import com.denfop.api.windsystem.WindSystem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class PollutionManager {
    public static PollutionManager pollutionManager;
    private final IWindSystem wind;
    private final Random random;
    Map<ChunkPos, ChunkLevel> pollutionAir = new HashMap<ChunkPos, ChunkLevel>();
    Map<ChunkPos, List<IPollutionMechanism>> pollutionAirChunks = new HashMap<ChunkPos, List<IPollutionMechanism>>();
    Map<ChunkPos, List<IPollutionMechanism>> pollutionSoilChunks = new HashMap<ChunkPos, List<IPollutionMechanism>>();
    Map<ChunkPos, ChunkLevel> pollutionSoil = new HashMap<ChunkPos, ChunkLevel>();

    public PollutionManager() {
        this.wind = WindSystem.windSystem;
        this.random = new Random();
        FMLCommonHandler.instance().bus().register((Object)new EventHandler());
    }

    public void work(EntityPlayer player) {
        if (player.func_130014_f_().field_73011_w.getDimension() != 0 || player.func_130014_f_().field_72995_K) {
            return;
        }
        if (player.func_130014_f_().func_72820_D() % 200L == 0L) {
            ChunkPos pos = new ChunkPos(player.func_180425_c());
            ChunkLevel pollution = this.pollutionSoil.get(pos);
            if (pollution != null && pollution.getLevelPollution().ordinal() >= 2) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 200, 0));
                if (pollution.getLevelPollution().ordinal() >= 3) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 200, 0));
                    if (pollution.getLevelPollution().ordinal() >= 4) {
                        player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 200, 0));
                    }
                }
            }
            if ((pollution = this.pollutionAir.get(pos)) != null && pollution.getLevelPollution().ordinal() >= 2) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 200, 0));
                if (pollution.getLevelPollution().ordinal() >= 3) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 200, 0));
                    if (pollution.getLevelPollution().ordinal() >= 4) {
                        player.func_70690_d(new PotionEffect((Potion)IUPotion.poison_gas, 200, 0));
                    }
                }
            }
        }
    }

    public void addAirPollutionMechanism(IPollutionMechanism pollutionMechanism) {
        List<IPollutionMechanism> pollution = this.pollutionAirChunks.get(pollutionMechanism.getChunkPos());
        if (pollution == null) {
            pollution = new LinkedList<IPollutionMechanism>();
            pollution.add(pollutionMechanism);
            this.pollutionAirChunks.put(pollutionMechanism.getChunkPos(), pollution);
        } else {
            pollution.add(pollutionMechanism);
        }
    }

    public void removeAirPollutionMechanism(IPollutionMechanism pollutionMechanism) {
        if (pollutionMechanism == null) {
            return;
        }
        List pollution = this.pollutionAirChunks.computeIfAbsent(pollutionMechanism.getChunkPos(), k -> new LinkedList());
        pollution.remove(pollutionMechanism);
    }

    public void removeSoilPollutionMechanism(IPollutionMechanism pollutionMechanism) {
        if (pollutionMechanism == null) {
            return;
        }
        List pollution = this.pollutionSoilChunks.computeIfAbsent(pollutionMechanism.getChunkPos(), k -> new LinkedList());
        pollution.remove(pollutionMechanism);
    }

    public void loadData(NBTTagCompound tagCompound) {
        ChunkLevel chunkLevel;
        int i;
        this.pollutionSoil.clear();
        this.pollutionAir.clear();
        this.pollutionAirChunks.clear();
        this.pollutionSoilChunks.clear();
        NBTTagCompound soil = tagCompound.func_74775_l("soil");
        NBTTagCompound air = tagCompound.func_74775_l("air");
        int size = soil.func_74762_e("size");
        int size1 = air.func_74762_e("size");
        for (i = 0; i < size; ++i) {
            chunkLevel = new ChunkLevel(soil.func_74775_l(String.valueOf(i)));
            this.pollutionSoil.put(chunkLevel.getPos(), chunkLevel);
        }
        for (i = 0; i < size1; ++i) {
            chunkLevel = new ChunkLevel(air.func_74775_l(String.valueOf(i)));
            this.pollutionAir.put(chunkLevel.getPos(), chunkLevel);
        }
    }

    public NBTTagCompound writeCompound() {
        ChunkLevel chunkLevel;
        int i;
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        NBTTagCompound soil = new NBTTagCompound();
        NBTTagCompound air = new NBTTagCompound();
        LinkedList<ChunkLevel> pollutionSoilChunk = new LinkedList<ChunkLevel>(this.pollutionSoil.values());
        LinkedList<ChunkLevel> pollutionAirChunk = new LinkedList<ChunkLevel>(this.pollutionAir.values());
        soil.func_74768_a("size", pollutionSoilChunk.size());
        air.func_74768_a("size", pollutionAirChunk.size());
        for (i = 0; i < pollutionSoilChunk.size(); ++i) {
            chunkLevel = (ChunkLevel)pollutionSoilChunk.get(i);
            soil.func_74782_a(String.valueOf(i), (NBTBase)chunkLevel.writeCompound());
        }
        for (i = 0; i < pollutionAirChunk.size(); ++i) {
            chunkLevel = (ChunkLevel)pollutionAirChunk.get(i);
            air.func_74782_a(String.valueOf(i), (NBTBase)chunkLevel.writeCompound());
        }
        nbtTagCompound.func_74782_a("air", (NBTBase)air);
        nbtTagCompound.func_74782_a("soil", (NBTBase)soil);
        return nbtTagCompound;
    }

    public void addSoilPollutionMechanism(IPollutionMechanism pollutionMechanism) {
        if (pollutionMechanism == null) {
            return;
        }
        List<IPollutionMechanism> pollution = this.pollutionSoilChunks.get(pollutionMechanism.getChunkPos());
        if (pollution == null) {
            pollution = new LinkedList<IPollutionMechanism>();
            pollution.add(pollutionMechanism);
            this.pollutionSoilChunks.put(pollutionMechanism.getChunkPos(), pollution);
        } else {
            pollution.add(pollutionMechanism);
        }
    }

    public ChunkLevel getChunkLevelAir(ChunkPos chunkPos) {
        return this.pollutionAir.get(chunkPos);
    }

    public ChunkLevel getChunkLevelSoil(ChunkPos chunkPos) {
        return this.pollutionSoil.get(chunkPos);
    }

    public void addChunkLevelSoil(ChunkLevel level) {
        this.pollutionSoil.put(level.getPos(), level);
    }

    public Vec2f getVector(EnumWindSide windSide) {
        switch (windSide) {
            case E: {
                return new Vec2f(1, 0);
            }
            case W: {
                return new Vec2f(-1, 0);
            }
            case N: {
                return new Vec2f(0, 1);
            }
            case S: {
                return new Vec2f(0, -1);
            }
            case NE: {
                return new Vec2f(1, 1);
            }
            case NW: {
                return new Vec2f(-1, 1);
            }
            case SE: {
                return new Vec2f(1, -1);
            }
            case SW: {
                return new Vec2f(-1, -1);
            }
        }
        return new Vec2f(0, 0);
    }

    public void tick(World world) {
        ChunkLevel chunkLevel;
        if (world.field_73011_w.getWorldTime() % 20L != 0L) {
            return;
        }
        HashSet<Map.Entry<ChunkPos, ChunkLevel>> entries = new HashSet<Map.Entry<ChunkPos, ChunkLevel>>(this.pollutionAir.entrySet());
        EnumWindSide windSide = this.wind.getWindSide();
        Vec2f vector = this.getVector(windSide);
        EnumTypeWind windLevel = this.wind.getEnumTypeWind();
        entries.parallelStream().forEach(entry -> {
            ChunkLevel chunkLevel = (ChunkLevel)entry.getValue();
            double distance = this.calculateDistance(chunkLevel.getDefaultPos(), chunkLevel.getPos());
            if (this.canChange(windLevel) && distance <= 10.0) {
                this.pollutionAir.remove(entry.getKey());
                chunkLevel.addChunkPos(vector.x, vector.y);
                this.pollutionAir.put(chunkLevel.getPos(), chunkLevel);
            }
        });
        if (world.field_73011_w.getWorldTime() % 6000L == 0L) {
            for (Map.Entry<ChunkPos, ChunkLevel> entry2 : this.pollutionSoil.entrySet()) {
                chunkLevel = entry2.getValue();
                if (chunkLevel == null) continue;
                chunkLevel.setPollution(chunkLevel.getPollution() / 2.0);
                if (!(chunkLevel.getPollution() < 2.0) || chunkLevel.getLevelPollution() == LevelPollution.VERY_LOW) continue;
                chunkLevel.setPollution(10.0);
                chunkLevel.setLevelPollution(LevelPollution.values()[Math.max(0, chunkLevel.getLevelPollution().ordinal() - 1)]);
            }
        }
        if (world.field_73011_w.getWorldTime() % 6000L == 0L) {
            for (Map.Entry<ChunkPos, Object> entry3 : this.pollutionAir.entrySet()) {
                chunkLevel = (ChunkLevel)entry3.getValue();
                if (chunkLevel == null) continue;
                chunkLevel.setPollution(chunkLevel.getPollution() / 2.0);
                if (!(chunkLevel.getPollution() < 2.0) || chunkLevel.getLevelPollution() == LevelPollution.VERY_LOW) continue;
                chunkLevel.setPollution(10.0);
                chunkLevel.setLevelPollution(LevelPollution.values()[Math.max(0, chunkLevel.getLevelPollution().ordinal() - 1)]);
            }
        }
        for (Map.Entry<ChunkPos, Object> entry4 : this.pollutionAirChunks.entrySet()) {
            chunkLevel = this.pollutionAir.get(entry4.getKey());
            if (chunkLevel == null) {
                chunkLevel = new ChunkLevel(entry4.getKey(), LevelPollution.VERY_LOW, 0.0);
                for (IPollutionMechanism pollutionMechanism : (List)entry4.getValue()) {
                    chunkLevel.addPollution(pollutionMechanism.getPollution());
                }
                this.pollutionAir.put(chunkLevel.getPos(), chunkLevel);
                continue;
            }
            for (IPollutionMechanism pollutionMechanism : (List)entry4.getValue()) {
                chunkLevel.addPollution(pollutionMechanism.getPollution());
            }
        }
        for (Map.Entry<ChunkPos, Object> entry5 : this.pollutionSoilChunks.entrySet()) {
            chunkLevel = this.pollutionSoil.get(entry5.getKey());
            if (chunkLevel == null) {
                chunkLevel = new ChunkLevel(entry5.getKey(), LevelPollution.VERY_LOW, 0.0);
                for (IPollutionMechanism pollutionMechanism : (List)entry5.getValue()) {
                    chunkLevel.addPollution(pollutionMechanism.getPollution());
                }
                this.pollutionSoil.put(chunkLevel.getPos(), chunkLevel);
                continue;
            }
            for (IPollutionMechanism pollutionMechanism : (List)entry5.getValue()) {
                chunkLevel.addPollution(pollutionMechanism.getPollution());
            }
        }
    }

    public double calculateDistance(ChunkPos pos1, ChunkPos pos2) {
        int xDiff = pos1.field_77276_a - pos2.field_77276_a;
        int zDiff = pos1.field_77275_b - pos2.field_77275_b;
        return Math.sqrt(xDiff * xDiff + zDiff * zDiff);
    }

    private boolean canChange(EnumTypeWind windLevel) {
        return this.random.nextInt(100 - windLevel.ordinal() * 5) == 0;
    }
}

