/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.radiationsystem;

import com.denfop.IUPotion;
import com.denfop.api.item.IHazmatLike;
import com.denfop.api.radiationsystem.EventHandler;
import com.denfop.api.radiationsystem.Radiation;
import com.denfop.api.reactors.IAdvReactor;
import com.denfop.network.packet.PacketRadiation;
import com.denfop.network.packet.PacketUpdateRadiation;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class RadiationSystem {
    public static RadiationSystem rad_system;
    public List<Radiation> radiationList = new LinkedList<Radiation>();
    Map<ChunkPos, Radiation> map = new HashMap<ChunkPos, Radiation>();
    Map<ChunkPos, List<IAdvReactor>> iAdvReactorMap = new HashMap<ChunkPos, List<IAdvReactor>>();

    public RadiationSystem() {
        rad_system = this;
        FMLCommonHandler.instance().bus().register((Object)new EventHandler());
    }

    public Map<ChunkPos, List<IAdvReactor>> getAdvReactorMap() {
        return this.iAdvReactorMap;
    }

    public void work(EntityPlayer player) {
        if (player.func_130014_f_().field_73011_w.getDimension() != 0 || player.func_130014_f_().field_72995_K) {
            return;
        }
        if (player.func_130014_f_().func_72820_D() % 200L == 0L) {
            ChunkPos pos = new ChunkPos(player.func_180425_c());
            Radiation rad = this.map.get(pos);
            if (rad != null) {
                if (!IHazmatLike.hasCompleteHazmat((EntityLivingBase)player, rad.getLevel())) {
                    rad.process(player);
                }
            } else {
                NBTTagCompound nbt = player.getEntityData();
                double radiation = nbt.func_74769_h("radiation");
                if (radiation >= 50.0) {
                    player.func_70690_d(new PotionEffect((Potion)IUPotion.radiation, 43200, 0));
                    player.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 400, 0));
                } else if (radiation >= 10.0) {
                    player.func_70690_d(new PotionEffect((Potion)IUPotion.radiation, 1000, 0));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 200, 0));
                } else if (radiation >= 1.0) {
                    player.func_70690_d(new PotionEffect((Potion)IUPotion.radiation, 200, 0));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 200, 0));
                }
            }
        }
    }

    public Map<ChunkPos, Radiation> getMap() {
        return this.map;
    }

    public List<Radiation> getRadiationList() {
        return this.radiationList;
    }

    public void addRadiation(NBTTagCompound tagCompound) {
        Radiation rad = new Radiation(tagCompound);
        this.map.put(rad.getPos(), rad);
        this.radiationList.add(rad);
    }

    public void addRadiation(Radiation radiation) {
        if (!this.map.containsKey(radiation.getPos())) {
            this.map.put(radiation.getPos(), radiation);
            this.radiationList.add(radiation);
        }
    }

    public void update(EntityPlayer player) {
        new PacketRadiation(this.radiationList, player);
    }

    public void clear() {
        this.map.clear();
        this.radiationList.clear();
    }

    public void addRadiationWihoutUpdate(Radiation radiation) {
        if (!this.map.containsKey(radiation.getPos())) {
            this.map.put(radiation.getPos(), radiation);
            this.radiationList.add(radiation);
        }
    }

    public void workDecay(World world) {
        try {
            for (Radiation radiation : this.radiationList) {
                if (!(radiation.getRadiation() > 0.0)) continue;
                switch (radiation.getLevel()) {
                    case LOW: {
                        if (world.field_73011_w.getWorldTime() % 36000L != 0L) break;
                        if (radiation.getRadiation() > 1.0) {
                            radiation.removeRadiation(radiation.getRadiation() / 2.0);
                        } else {
                            radiation.removeRadiation(radiation.getRadiation());
                        }
                        new PacketUpdateRadiation(radiation);
                        break;
                    }
                    case DEFAULT: {
                        if (world.field_73011_w.getWorldTime() % 18000L != 0L) break;
                        if (radiation.getRadiation() > 1.0) {
                            radiation.removeRadiation(radiation.getRadiation() / 2.0);
                        } else {
                            radiation.removeRadiation(radiation.getRadiation());
                        }
                        new PacketUpdateRadiation(radiation);
                        break;
                    }
                    case MEDIUM: {
                        if (world.field_73011_w.getWorldTime() % 12000L != 0L) break;
                        if (radiation.getRadiation() > 1.0) {
                            radiation.removeRadiation(radiation.getRadiation() / 2.0);
                        } else {
                            radiation.removeRadiation(radiation.getRadiation());
                        }
                        new PacketUpdateRadiation(radiation);
                        break;
                    }
                    case HIGH: {
                        if (world.field_73011_w.getWorldTime() % 6000L != 0L) break;
                        if (radiation.getRadiation() > 1.0) {
                            radiation.removeRadiation(radiation.getRadiation() / 2.0);
                        } else {
                            radiation.removeRadiation(radiation.getRadiation());
                        }
                        new PacketUpdateRadiation(radiation);
                        break;
                    }
                    case VERY_HIGH: {
                        if (world.field_73011_w.getWorldTime() % 2400L != 0L) break;
                        if (radiation.getRadiation() > 1.0) {
                            radiation.removeRadiation(radiation.getRadiation() / 2.0);
                        } else {
                            radiation.removeRadiation(radiation.getRadiation());
                        }
                        new PacketUpdateRadiation(radiation);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

