/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.reactors;

import com.denfop.api.reactors.EnumReactors;
import com.denfop.api.reactors.EnumTypeSecurity;
import com.denfop.api.reactors.IAdvReactor;
import com.denfop.api.reactors.ITypeRector;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.invslot.InvSlot;
import com.denfop.utils.Timer;
import net.minecraft.item.ItemStack;

public class CreativeReactor
implements IAdvReactor {
    public static int[] graphite_capacitors = new int[]{1, 6, 8, 8};
    public static int[] heat_graphite = new int[]{1, 2, 4, 8};
    public static double[] graphite_capacitor = new double[]{0.02, 0.04, 0.08, 0.12};
    private final InvSlot slot;
    public int level;
    public Timer timer = new Timer(9999, 0, 0);
    public Timer red_timer = new Timer(0, 2, 30);
    public Timer yellow_timer = new Timer(0, 15, 0);
    public boolean explode = false;
    private EnumReactors enumReactors;
    private double heat;
    private double output;
    private double rad;
    private EnumTypeSecurity security = EnumTypeSecurity.NONE;
    private int col;

    public CreativeReactor(EnumReactors enumReactors, InvSlot slot) {
        if (enumReactors != null) {
            this.enumReactors = enumReactors;
            this.level = enumReactors.ordinal() % 3 + 1;
        } else {
            this.enumReactors = null;
            this.level = 0;
        }
        this.slot = slot;
        this.col = 0;
    }

    public void reset(EnumReactors enumReactors) {
        this.enumReactors = enumReactors;
        this.level = enumReactors.ordinal() % 3 + 1;
        this.col = 0;
    }

    public void tick(double maxHeat) {
        this.workTimer();
        if (!this.timer.canWork()) {
            this.explode();
        } else if (!this.yellow_timer.canWork()) {
            this.explode();
        } else if (!this.red_timer.canWork()) {
            this.explode();
        } else if (this.getHeat() >= (double)this.getMaxHeat() && maxHeat >= (double)this.getMaxHeat() * 1.5) {
            this.explode();
        }
    }

    @Override
    public boolean isWork() {
        return true;
    }

    @Override
    public void setWork(boolean work) {
    }

    @Override
    public double getHeat() {
        return this.heat;
    }

    @Override
    public void setHeat(double var1) {
        this.heat = var1;
        if (this.heat > (double)this.getMaxHeat()) {
            this.heat = this.getMaxHeat();
        }
        if (this.heat < (double)this.getStableMaxHeat()) {
            this.setSecurity(EnumTypeSecurity.STABLE);
            this.setTime(EnumTypeSecurity.STABLE);
        } else if (this.heat >= (double)this.getStableMaxHeat() && this.heat <= (double)this.getStableMaxHeat() + (double)(this.getMaxHeat() - this.getStableMaxHeat()) * 0.75) {
            this.setSecurity(EnumTypeSecurity.UNSTABLE);
            this.setTime(EnumTypeSecurity.UNSTABLE);
        } else {
            this.setSecurity(EnumTypeSecurity.ERROR);
            this.setTime(EnumTypeSecurity.ERROR);
        }
    }

    @Override
    public void setUpdate() {
    }

    @Override
    public void setItemAt(int x, int y) {
        this.slot.set(y * this.getWidth() + x, ItemStack.field_190927_a);
    }

    public double getRad() {
        return this.rad;
    }

    @Override
    public void setRad(double rad) {
        this.rad = rad;
    }

    @Override
    public int getMaxHeat() {
        return this.enumReactors.getMaxHeat();
    }

    @Override
    public int getStableMaxHeat() {
        return this.enumReactors.getMaxStable();
    }

    @Override
    public double getOutput() {
        return this.output;
    }

    @Override
    public void setOutput(double output) {
        this.output = output;
    }

    @Override
    public ItemStack getItemAt(int x, int y) {
        return this.slot.get(y * this.getWidth() + x);
    }

    @Override
    public void explode() {
        this.explode = true;
    }

    @Override
    public ITypeRector getTypeRector() {
        return this.enumReactors.getType();
    }

    @Override
    public Timer getTimer() {
        return this.timer;
    }

    @Override
    public void setTime(EnumTypeSecurity enumTypeSecurity) {
        if (this.security == enumTypeSecurity) {
            switch (enumTypeSecurity) {
                case STABLE: {
                    this.timer = new Timer(9999, 0, 0);
                    break;
                }
                case ERROR: {
                    this.timer = new Timer(0, 2, 30);
                    break;
                }
                case UNSTABLE: {
                    this.timer = new Timer(0, 15, 0);
                }
            }
        }
    }

    @Override
    public void workTimer() {
        switch (this.security) {
            case UNSTABLE: {
                this.yellow_timer.work();
                if (this.red_timer.getMinute(3)) break;
                this.red_timer.rework();
                break;
            }
            case STABLE: {
                this.timer.work();
                if (!this.yellow_timer.getMinute(15)) {
                    this.yellow_timer.rework();
                }
                if (this.red_timer.getMinute(3)) break;
                this.red_timer.rework();
                break;
            }
            case ERROR: {
                this.red_timer.work();
            }
        }
    }

    @Override
    public EnumTypeSecurity getSecurity() {
        return this.security;
    }

    @Override
    public void setSecurity(EnumTypeSecurity enumTypeSecurity) {
        this.security = enumTypeSecurity;
    }

    @Override
    public int getBlockLevel() {
        return this.level;
    }

    @Override
    public double getMulHeatRod(int x, int y, ItemStack stack) {
        if (this.enumReactors != null && this.enumReactors.getType() == ITypeRector.GRAPHITE_FLUID) {
            double coef = 1.0;
            for (int i = 0; i < graphite_capacitors[this.level - 1]; ++i) {
                coef *= 1.0 - graphite_capacitor[this.level - 1];
            }
            return coef *= 1.0727272727272728;
        }
        return IAdvReactor.super.getMulHeatRod(x, y, stack);
    }

    @Override
    public double getMulOutput(int x, int y, ItemStack stack) {
        int maxCol;
        if (this.enumReactors != null && this.enumReactors.getType() == ITypeRector.GRAPHITE_FLUID) {
            double level = 1.2375;
            return 1.0 * level;
        }
        if (this.enumReactors != null && this.enumReactors.getType() == ITypeRector.HIGH_SOLID && this.col < (maxCol = heat_graphite[this.level - 1])) {
            ++this.col;
            double level1 = 1.0;
            double level = 1.2375;
            return level1 *= level;
        }
        return IAdvReactor.super.getMulOutput(x, y, stack);
    }

    @Override
    public int getWidth() {
        return this.enumReactors.getWidth();
    }

    @Override
    public int getHeight() {
        return this.enumReactors.getHeight();
    }

    @Override
    public int getLevelReactor() {
        return this.level;
    }

    @Override
    public int getMaxLevelReactor() {
        return this.level;
    }

    @Override
    public void increaseLevelReactor() {
    }

    @Override
    public ComponentBaseEnergy getRadiation() {
        return null;
    }

    @Override
    public double getModuleStableHeat() {
        return 1.0;
    }

    @Override
    public double getModuleRadiation() {
        return 1.0;
    }

    @Override
    public double getModuleGeneration() {
        return 1.0;
    }

    @Override
    public double getModuleVent() {
        return 1.0;
    }

    @Override
    public double getModuleComponentVent() {
        return 1.0;
    }

    @Override
    public double getModuleCapacitor() {
        return 1.0;
    }

    @Override
    public double getModuleExchanger() {
        return 1.0;
    }
}

