/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.recipe;

import com.denfop.api.inv.IAdvInventory;
import com.denfop.invslot.InvSlot;
import com.denfop.utils.ModUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class InvSlotOutput
extends InvSlot {
    public InvSlotOutput(IAdvInventory<?> base1, int count) {
        super(base1, InvSlot.TypeItemSlot.OUTPUT, count);
    }

    @Override
    public boolean accepts(ItemStack stack, int index) {
        return false;
    }

    @Override
    public boolean add(List<ItemStack> stacks) {
        return this.add(stacks, false);
    }

    @Override
    public boolean add(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), false);
    }

    @Override
    public boolean canAdd(List<ItemStack> stacks) {
        boolean can = true;
        for (ItemStack stack : stacks) {
            can = can && this.canAdd(stack);
        }
        return can;
    }

    @Override
    public boolean canAdd(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), true);
    }

    @Override
    public boolean add(List<ItemStack> stacks, boolean simulate) {
        if (stacks != null && !stacks.isEmpty()) {
            for (ItemStack stack : stacks) {
                int minSlot = this.size();
                for (int i = 0; i < this.size(); ++i) {
                    if (this.get(i).func_190926_b()) {
                        if (i >= minSlot) continue;
                        minSlot = i;
                        continue;
                    }
                    if (!this.get(i).func_77969_a(stack) || this.get(i).func_190916_E() + stack.func_190916_E() > stack.func_77976_d()) continue;
                    if (stack.func_77978_p() == null && this.get(i).func_77978_p() == null) {
                        if (!simulate) {
                            this.get(i).func_190917_f(stack.func_190916_E());
                        }
                        return true;
                    }
                    if (!ModUtils.checkNbtEquality(stack.func_77978_p(), this.get(i).func_77978_p())) continue;
                    if (!simulate) {
                        this.get(i).func_190917_f(stack.func_190916_E());
                    }
                    return true;
                }
                if (minSlot == this.size()) continue;
                if (!simulate) {
                    this.put(minSlot, stack.func_77946_l());
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean addWithoutIgnoring(List<ItemStack> stacks, boolean simulate) {
        if (stacks != null && !stacks.isEmpty()) {
            LinkedList<Integer> linkedList = new LinkedList<Integer>();
            int col = 0;
            block0: for (ItemStack stack : stacks) {
                int minSlot = this.size();
                for (int i = 0; i < this.size(); ++i) {
                    if (this.get(i).func_190926_b()) {
                        if (i >= minSlot || linkedList.contains(i)) continue;
                        minSlot = i;
                        continue;
                    }
                    if (!this.get(i).func_77969_a(stack) || this.get(i).func_190916_E() + stack.func_190916_E() > stack.func_77976_d()) continue;
                    if (stack.func_77978_p() == null && this.get(i).func_77978_p() == null) {
                        if (!simulate) {
                            this.get(i).func_190917_f(stack.func_190916_E());
                        }
                        ++col;
                        linkedList.add(i);
                        continue block0;
                    }
                    if (!ModUtils.checkNbtEquality(stack.func_77978_p(), this.get(i).func_77978_p())) continue;
                    if (!simulate) {
                        this.get(i).func_190917_f(stack.func_190916_E());
                    }
                    ++col;
                    linkedList.add(i);
                    continue block0;
                }
                if (minSlot == this.size()) continue;
                if (!simulate) {
                    this.put(minSlot, stack.func_77946_l());
                }
                ++col;
                linkedList.add(minSlot);
            }
            return col == stacks.size();
        }
        return true;
    }

    public boolean add(List<ItemStack> stacks, int size) {
        if (stacks != null && !stacks.isEmpty()) {
            for (ItemStack stack : stacks) {
                int minSlot = this.size();
                for (int i = 0; i < this.size(); ++i) {
                    if (this.get(i).func_190926_b()) {
                        if (i >= minSlot) continue;
                        minSlot = i;
                        continue;
                    }
                    if (!this.get(i).func_77969_a(stack) || this.get(i).func_190916_E() + stack.func_190916_E() * size > stack.func_77976_d()) continue;
                    if (stack.func_77978_p() == null && this.get(i).func_77978_p() == null) {
                        this.get(i).func_190917_f(stack.func_190916_E() * size);
                        return true;
                    }
                    if (!ModUtils.checkNbtEquality(stack.func_77978_p(), this.get(i).func_77978_p())) continue;
                    this.get(i).func_190917_f(stack.func_190916_E() * size);
                    return true;
                }
                if (minSlot == this.size()) continue;
                stack = stack.func_77946_l();
                stack.func_190920_e(stack.func_190916_E() * size);
                this.put(minSlot, stack);
                return true;
            }
            return false;
        }
        return true;
    }

    public void add(ItemStack stack, int size) {
        int count = size * stack.func_190916_E();
        for (int i = 0; i < this.size(); ++i) {
            int size1;
            ItemStack slot = this.get(i);
            if (slot.func_190926_b()) {
                size1 = Math.min(count, stack.func_77976_d());
                slot = stack.func_77946_l();
                slot.func_190920_e(size1);
                this.put(i, slot);
                if ((count -= size1) != 0) continue;
                return;
            }
            if (!slot.func_77969_a(stack) || slot.func_190916_E() == stack.func_77976_d()) continue;
            if (stack.func_77978_p() == null && slot.func_77978_p() == null) {
                size1 = Math.min(count, stack.func_77976_d() - slot.func_190916_E());
                this.get(i).func_190917_f(size1);
                if ((count -= size1) != 0) continue;
                return;
            }
            if (!ModUtils.checkNbtEquality(stack.func_77978_p(), slot.func_77978_p())) continue;
            size1 = Math.min(count, stack.func_77976_d() - slot.func_190916_E());
            this.get(i).func_190917_f(size1);
            if ((count -= size1) != 0) continue;
            return;
        }
    }
}

