/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.recipe;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.IBaseRecipe;
import com.denfop.componets.Fluids;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class MultiFluidHandlerRecipe {
    private final Fluids component;
    List<FluidTank> inputTank = new ArrayList<FluidTank>();
    List<FluidTank> outputTank = new ArrayList<FluidTank>();
    private BaseFluidMachineRecipe[] output;
    private IBaseRecipe name;
    private List<BaseFluidMachineRecipe> list_recipe;

    public MultiFluidHandlerRecipe(String name, Fluids fluid_component, int col) {
        this.component = fluid_component;
        this.name = Recipes.recipes.getRecipeFluid().getRecipeFromName(name);
        this.list_recipe = Recipes.recipes.getRecipeFluid().getRecipeList(name);
        ArrayList list = new ArrayList();
        fluid_component.getAllTanks().forEach(list::add);
        for (Fluids.InternalFluidTank internalFluidTank : list) {
            if (internalFluidTank.isInput()) {
                this.inputTank.add(internalFluidTank);
                continue;
            }
            this.outputTank.add(internalFluidTank);
        }
        this.output = new BaseFluidMachineRecipe[col];
    }

    public MultiFluidHandlerRecipe(String name, int col, Fluids.InternalFluidTank ... fluid_tank) {
        this.component = null;
        this.name = Recipes.recipes.getRecipeFluid().getRecipeFromName(name);
        this.list_recipe = Recipes.recipes.getRecipeFluid().getRecipeList(name);
        for (Fluids.InternalFluidTank internalFluidTank : fluid_tank) {
            if (internalFluidTank.isInput()) {
                this.inputTank.add(internalFluidTank);
                continue;
            }
            this.outputTank.add(internalFluidTank);
        }
        this.output = new BaseFluidMachineRecipe[col];
    }

    public List<Fluid> getFluids(int i) {
        HashSet<Fluid> fluids = new HashSet<Fluid>();
        for (BaseFluidMachineRecipe machineRecipe : this.list_recipe) {
            fluids.add(machineRecipe.input.getInputs().get(i).getFluid());
        }
        return new ArrayList<Fluid>(fluids);
    }

    public List<Fluid> getOutputFluids(int i) {
        HashSet<Fluid> fluids = new HashSet<Fluid>();
        for (BaseFluidMachineRecipe machineRecipe : this.list_recipe) {
            fluids.add(machineRecipe.output_fluid.get(i).getFluid());
        }
        return new ArrayList<Fluid>(fluids);
    }

    public List<BaseFluidMachineRecipe> getList_recipe() {
        return this.list_recipe;
    }

    public void load(int col) {
        this.list_recipe = Recipes.recipes.getRecipeFluid().getRecipeList(this.name.getName());
        this.getOutput(col);
    }

    public void load(ItemStack stack, int col) {
        this.list_recipe = Recipes.recipes.getRecipeFluid().getRecipeList(this.name.getName());
        this.getOutput(stack, col);
    }

    public void setName(String name, int col) {
        this.name = Recipes.recipes.getRecipeFluid().getRecipeFromName(name);
        this.getOutput(col);
    }

    public Fluids getComponent() {
        return this.component;
    }

    public boolean canOperate(int col) {
        for (int i = 0; i < this.name.getSize(); ++i) {
            if (this.inputTank.get(i).getFluidAmount() >= this.output[col].input.getInputs().get((int)i).amount) continue;
            return false;
        }
        return true;
    }

    public void consume(int col) {
        for (int i = 0; i < this.name.getSize(); ++i) {
            this.inputTank.get(i).drain(this.output[col].input.getInputs().get(i), true);
        }
    }

    public BaseFluidMachineRecipe output(int col) {
        return this.output[col];
    }

    public BaseFluidMachineRecipe getOutput(int col) {
        if (this.output[col] != null) {
            return this.output[col];
        }
        ArrayList<FluidStack> fluidStackList = new ArrayList<FluidStack>();
        for (FluidTank tank : this.inputTank) {
            if (tank.getFluidAmount() == 0) {
                return null;
            }
            fluidStackList.add(tank.getFluid());
            if (fluidStackList.size() != this.name.getSize()) continue;
            break;
        }
        this.output[col] = Recipes.recipes.getRecipeFluid().getRecipeOutput(this.name, this.list_recipe, false, fluidStackList);
        return this.output[col];
    }

    public BaseFluidMachineRecipe getOutput(ItemStack stack, int col) {
        if (this.output[col] != null) {
            return this.output[col];
        }
        ArrayList<FluidStack> fluidStackList = new ArrayList<FluidStack>();
        for (FluidTank tank : this.inputTank) {
            if (tank.getFluidAmount() == 0) {
                return null;
            }
            fluidStackList.add(tank.getFluid());
            if (fluidStackList.size() != this.name.getSize()) continue;
            break;
        }
        this.output[col] = Recipes.recipes.getRecipeFluid().getRecipeOutput(this.name, this.list_recipe, false, stack);
        return this.output[col];
    }

    public void checkOutput(int col) {
        ArrayList<FluidStack> fluidStackList = new ArrayList<FluidStack>();
        for (FluidTank tank : this.inputTank) {
            if (tank.getFluidAmount() == 0) {
                if (this.output[col] != null) {
                    this.output[col] = null;
                }
                return;
            }
            fluidStackList.add(tank.getFluid());
            if (fluidStackList.size() != this.name.getSize()) continue;
            break;
        }
        this.output[col] = Recipes.recipes.getRecipeFluid().getRecipeOutput(this.name, this.list_recipe, false, fluidStackList);
    }

    public void setOutput(BaseFluidMachineRecipe baseFluidMachineRecipe, int col) {
        this.output[col] = baseFluidMachineRecipe;
    }

    public boolean canFillFluid(int col) {
        if (this.output[col] != null) {
            for (int i = 0; i < this.outputTank.size(); ++i) {
                FluidTank fluidTank = this.outputTank.get(i);
                if (fluidTank.getFluidAmount() + this.output[col].output_fluid.get((int)i).amount <= fluidTank.getCapacity() || fluidTank.getFluid() != null && fluidTank.getFluid().getFluid() != this.output[col].output_fluid.get(i).getFluid()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void fillFluid(int col) {
        if (this.output[col] != null) {
            for (int i = 0; i < this.outputTank.size(); ++i) {
                this.outputTank.get(i).fill(this.output[col].output_fluid.get(i), true);
            }
        }
    }

    public boolean checkFluids(int col) {
        if (this.output[col] != null) {
            for (FluidTank fluidTank : this.inputTank) {
                if (fluidTank.getFluidAmount() != 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

