/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.recipe;

import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IBaseRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IInput;
import com.denfop.api.recipe.IRecipeInputStack;
import com.denfop.api.recipe.IRecipes;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeAdder;
import com.denfop.api.recipe.RecipeArrayList;
import com.denfop.api.recipe.RecipeFluidAdder;
import com.denfop.api.recipe.RecipeFluidRemove;
import com.denfop.api.recipe.RecipeInputStack;
import com.denfop.api.recipe.RecipeManager;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.recipe.RecipeRemove;
import com.denfop.api.recipe.RecipesFluidCore;
import com.denfop.recipe.IInputItemStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class RecipesCore
implements IRecipes {
    private final List<IHasRecipe> recipes = new LinkedList<IHasRecipe>();
    private final List<String> registeredRecipes = new LinkedList<String>();
    private final RecipesFluidCore fluid_recipe;
    public Map<String, List<BaseMachineRecipe>> map_recipes = new HashMap<String, List<BaseMachineRecipe>>();
    public Map<String, IBaseRecipe> map_recipe_managers = new HashMap<String, IBaseRecipe>();
    public Map<String, RecipeArrayList<IRecipeInputStack>> map_recipe_managers_itemStack = new HashMap<String, RecipeArrayList<IRecipeInputStack>>();
    public Map<String, List<Fluid>> map_fluid_input = new HashMap<String, List<Fluid>>();
    public List<RecipeRemove> recipeRemoves = new ArrayList<RecipeRemove>();
    public List<RecipeFluidRemove> recipeFluidRemoves = new ArrayList<RecipeFluidRemove>();
    public List<RecipeFluidAdder> recipeFluidAdders = new ArrayList<RecipeFluidAdder>();
    public List<RecipeAdder> recipeAdders = new ArrayList<RecipeAdder>();
    public boolean canAdd = true;

    public RecipesCore() {
        this.init();
        this.fluid_recipe = new RecipesFluidCore();
        this.fluid_recipe.init();
    }

    @Override
    public List<Fluid> getInputFluidsFromRecipe(String name) {
        return this.map_fluid_input.getOrDefault(name, Collections.emptyList());
    }

    public void init() {
        this.addRecipeManager("alloysmelter", 2, true);
        this.addRecipeManager("enrichment", 2, true);
        this.addRecipeManager("painter", 2, true);
        this.addRecipeManager("sunnuriumpanel", 2, true);
        this.addRecipeManager("synthesis", 2, true);
        this.addRecipeManager("upgradeblock", 2, true);
        this.addRecipeManager("antiupgradeblock", 1, true);
        this.addRecipeManager("advalloysmelter", 3, true);
        this.addRecipeManager("genstone", 2, false);
        this.addRecipeManager("microchip", 5, true);
        this.addRecipeManager("sunnurium", 4, true);
        this.addRecipeManager("wither", 7, true, true);
        this.addRecipeManager("doublemolecular", 2, true);
        this.addRecipeManager("molecular", 1, true);
        this.addRecipeManager("plastic", 2, true);
        this.addRecipeManager("plasticplate", 1, true);
        this.addRecipeManager("converter", 1, false, true);
        this.addRecipeManager("macerator", 1, true, true);
        this.addRecipeManager("compressor", 1, true, true);
        this.addRecipeManager("extractor", 1, true, true);
        this.addRecipeManager("recycler", 1, true, true);
        this.addRecipeManager("furnace", 1, true, true);
        this.addRecipeManager("extruding", 1, true, true);
        this.addRecipeManager("cutting", 1, true, true);
        this.addRecipeManager("rolling", 1, true, true);
        this.addRecipeManager("farmer", 1, true, true);
        this.addRecipeManager("scrap", 1, true, true);
        this.addRecipeManager("comb_macerator", 1, true, true);
        this.addRecipeManager("handlerho", 1, true, true);
        this.addRecipeManager("matter", 1, false, false);
        this.addRecipeManager("rotor_assembler", 5, true, true);
        this.addRecipeManager("rod_assembler", 6, true, true);
        this.addRecipeManager("rotor_upgrade", 2, false, true);
        this.addRecipeManager("endcollector", 1, true, true);
        this.addRecipeManager("aercollector", 1, true, true);
        this.addRecipeManager("earthcollector", 1, true, true);
        this.addRecipeManager("nethercollector", 1, true, true);
        this.addRecipeManager("aquacollector", 1, true, true);
        this.addRecipeManager("defaultcollector", 1, true, true);
        this.addRecipeManager("orewashing", 1, true, false);
        this.addRecipeManager("centrifuge", 1, true, false);
        this.addRecipeManager("gearing", 1, true, false);
        this.addRecipeManager("water_rotor_assembler", 5, true, true);
        this.addRecipeManager("water_rotor_upgrade", 2, false, true);
        this.addRecipeManager("welding", 2, true, true);
        this.addRecipeManager("replicator", 1, false, false);
        this.addRecipeManager("cannerbottle", 2, true, true);
        this.addRecipeManager("cannerenrich", 2, true, true);
        this.addRecipeManager("empty", 1, false, true);
        this.addRecipeManager("matterAmplifier", 1, true, true);
        this.addRecipeManager("scrapbox", 1, true, true);
        this.addRecipeManager("battery_factory", 9, true, true);
        this.addRecipeManager("socket_factory", 6, true, true);
        this.addRecipeManager("active_matter_factory", 1, true, true);
        this.addRecipeManager("laser", 1, true, true);
        this.addRecipeManager("graphite_recipe", 2, true, true);
        this.addRecipeManager("silicon_recipe", 2, true, true);
        this.addRecipeManager("solar_glass_recipe", 1, true, true);
        this.addRecipeManager("stamp_vent", 4, true, false);
        this.addRecipeManager("stamp_plate", 4, true, false);
        this.addRecipeManager("stamp_exchanger", 4, true, false);
        this.addRecipeManager("stamp_coolant", 4, true, false);
        this.addRecipeManager("stamp_capacitor", 4, true, false);
        this.addRecipeManager("reactor_simple_rod", 5, true, true);
        this.addRecipeManager("reactor_dual_rod", 3, true, true);
        this.addRecipeManager("reactor_quad_rod", 7, true, true);
        this.addRecipeManager("waste_recycler", 1, true, true);
        this.addRecipeManager("enchanter_books", 2, true, true);
        this.addRecipeManager("anvil", 1, true, true);
        this.addRecipeManager("upgrade_machine", 9, true, true, true);
        this.addRecipeManager("item_divider", 1, true, true);
        this.addRecipeManager("item_divider_fluid", 1, true, true);
        this.addRecipeManager("fluid_adapter", 2, true, false);
        this.addRecipeManager("fluid_integrator", 1, true, true);
        this.addRecipeManager("solid_electrolyzer", 1, true, true);
        this.addRecipeManager("squeezer", 1, true, true);
        this.addRecipeManager("impalloysmelter", 4, true);
        this.addRecipeManager("peralloysmelter", 5, true);
        this.addRecipeManager("solid_fluid_mixer", 1, true, true);
        this.addRecipeManager("primal_fluid_integrator", 1, true, true);
        this.addRecipeManager("neutron_separator", 1, true, true);
        this.addRecipeManager("positrons", 2, true, false);
        this.addRecipeManager("primal_laser_polisher", 1, true, false);
        this.addRecipeManager("cyclotron", 1, true, false);
        this.addRecipeManager("smeltery", 1, true, false);
        this.addRecipeManager("solid_mixer", 2, true, false);
        this.addRecipeManager("triple_solid_mixer", 3, true, false);
        this.addRecipeManager("single_fluid_adapter", 1, true, false);
        this.addRecipeManager("programming", 1, true, false);
        this.addRecipeManager("electronics", 5, true, false);
        this.addRecipeManager("sharpener", 1, true, false);
        this.addRecipeManager("radioactive_handler", 1, true, false);
        this.addRecipeManager("ore_purifier", 1, true, false);
        this.addRecipeManager("quantummolecular", 2, true, true);
        this.addRecipeManager("wire_insulator", 2, true, true);
        this.addRecipeManager("charger", 1, true, true);
        this.addRecipeManager("biomass", 1, true, true);
        this.addRecipeManager("strong_anvil", 1, true, true);
        this.addRecipeManager("refractory_furnace", 1, true, true);
        this.addRecipeManager("elec_refractory_furnace", 1, true, true);
        this.addRecipeManager("brewing", 2, true, false);
        this.addRecipeManager("sawmill", 1, true, false);
        this.addRecipeManager("genadditionstone", 2, true, false);
        this.addRecipeManager("incubator", 1, true, false);
        this.addRecipeManager("insulator", 1, true, false);
        this.addRecipeManager("rna_collector", 1, true, false);
        this.addRecipeManager("genetic_stabilizer", 1, true, false);
        this.addRecipeManager("genetic_centrifuge", 1, true, false);
        this.addRecipeManager("inoculator", 2, true, false);
        this.addRecipeManager("genetic_transposer", 4, true, false);
        this.addRecipeManager("genetic_polymerizer", 5, true, true);
        this.addRecipeManager("roverupgradeblock", 2, true, true);
        this.addRecipeManager("roverassembler", 40, true, true);
        this.addRecipeManager("probeassembler", 36, true, true);
        this.addRecipeManager("satelliteassembler", 36, true, true);
        this.addRecipeManager("rocketassembler", 37, true, true);
    }

    public void setCanAdd(boolean canAdd) {
        this.canAdd = canAdd;
    }

    @Override
    public void addRemoveRecipe(String name, ItemStack stack, boolean allRemove) {
        this.recipeRemoves.add(new RecipeRemove(name, stack, allRemove));
    }

    @Override
    public void addRemoveRecipe(String name, ItemStack stack) {
        this.recipeRemoves.add(new RecipeRemove(name, stack, false));
    }

    @Override
    public void addFluidRemoveRecipe(String name, FluidStack stack) {
        this.recipeFluidRemoves.add(new RecipeFluidRemove(name, stack, false));
    }

    @Override
    public void removeAllRecipesFromList() {
        this.recipeRemoves.forEach(recipeRemove -> this.removeAllRecipe(recipeRemove.getNameRecipe(), new RecipeOutput(null, recipeRemove.getStack())));
        this.recipeFluidRemoves.forEach(recipeRemove -> this.getRecipeFluid().removeAllRecipe(recipeRemove.getNameRecipe(), recipeRemove.getStack()));
    }

    @Override
    public void addAdderRecipe(String name, BaseMachineRecipe baseMachineRecipe) {
        this.recipeAdders.add(new RecipeAdder(name, baseMachineRecipe));
    }

    @Override
    public void addFluidAdderRecipe(String name, BaseFluidMachineRecipe baseMachineRecipe) {
        this.recipeFluidAdders.add(new RecipeFluidAdder(name, baseMachineRecipe));
    }

    @Override
    public void addAllRecipesFromList() {
        this.recipeAdders.forEach(recipeAdder -> this.addRecipe(recipeAdder.getName(), recipeAdder.getBaseMachineRecipe()));
        this.recipeFluidAdders.forEach(recipeAdder -> this.getRecipeFluid().addRecipe(recipeAdder.getName(), recipeAdder.getBaseMachineRecipe()));
    }

    @Override
    public IBaseRecipe getRecipe(String name) {
        return this.map_recipe_managers.get(name);
    }

    @Override
    public void addRecipeManager(String name, int size, boolean consume) {
        this.map_recipe_managers.put(name, new RecipeManager(name, size, consume));
    }

    @Override
    public RecipesFluidCore getRecipeFluid() {
        return this.fluid_recipe;
    }

    public void addRecipeManager(String name, int size, boolean consume, boolean require) {
        this.map_recipe_managers.put(name, new RecipeManager(name, size, consume, require));
        if (!this.map_recipes.containsKey(name)) {
            LinkedList lst = new LinkedList();
            RecipeArrayList lst1 = new RecipeArrayList();
            this.map_recipes.put(name, lst);
            this.map_recipe_managers_itemStack.put(name, lst1);
        }
    }

    public void addRecipeManager(String name, int size, boolean consume, boolean require, boolean workbench) {
        this.map_recipe_managers.put(name, new RecipeManager(name, size, consume, require, workbench));
        if (!this.map_recipes.containsKey(name)) {
            LinkedList lst = new LinkedList();
            RecipeArrayList lst1 = new RecipeArrayList();
            this.map_recipes.put(name, lst);
            this.map_recipe_managers_itemStack.put(name, lst1);
        }
    }

    @Override
    public void removeRecipe(String name, RecipeOutput output) {
        List recipes = this.map_recipes.getOrDefault(name, new ArrayList());
        BaseMachineRecipe deleteRecipe = null;
        for (BaseMachineRecipe recipe : recipes) {
            for (ItemStack stack : output.items) {
                for (ItemStack output_stack : recipe.output.items) {
                    if (!stack.func_77969_a(output_stack)) continue;
                    deleteRecipe = recipe;
                    break;
                }
                if (deleteRecipe == null) continue;
                break;
            }
            if (deleteRecipe == null) continue;
            break;
        }
        if (deleteRecipe != null) {
            recipes.remove(deleteRecipe);
            List list = this.map_recipe_managers_itemStack.get(name);
            IInput input = deleteRecipe.input;
            List<IInputItemStack> list2 = input.getInputs();
            for (IInputItemStack input1 : list2) {
                RecipeInputStack iRecipeInputStack = new RecipeInputStack(input1);
                list.remove(iRecipeInputStack);
            }
        }
    }

    @Override
    public void removeAllRecipe(String name, RecipeOutput output) {
        List<BaseMachineRecipe> recipes = this.map_recipes.get(name);
        ArrayList<BaseMachineRecipe> deleteRecipes = new ArrayList<BaseMachineRecipe>();
        block0: for (BaseMachineRecipe recipe : recipes) {
            boolean find = false;
            for (ItemStack stack : output.items) {
                for (ItemStack output_stack : recipe.output.items) {
                    if (!stack.func_77969_a(output_stack)) continue;
                    deleteRecipes.add(recipe);
                    find = true;
                    break;
                }
                if (!find) continue;
                continue block0;
            }
        }
        for (BaseMachineRecipe deleteRecipe : deleteRecipes) {
            recipes.remove(deleteRecipe);
            List list = this.map_recipe_managers_itemStack.get(name);
            IInput input = deleteRecipe.input;
            List<IInputItemStack> list2 = input.getInputs();
            for (IInputItemStack input1 : list2) {
                RecipeInputStack iRecipeInputStack = new RecipeInputStack(input1);
                list.remove(iRecipeInputStack);
            }
        }
    }

    @Override
    public void removeRecipe(String name, ItemStack input) {
        List<BaseMachineRecipe> recipes = this.map_recipes.get(name);
        recipes.removeIf(recipe -> recipe.input.getInputs().get(0).matches(input));
    }

    @Override
    public BaseMachineRecipe getRecipeOutputFluid(IBaseRecipe recipe, MachineRecipe recipeOutput, boolean consume, List<ItemStack> list, FluidTank tank) {
        if (recipeOutput == null) {
            return null;
        }
        List<Integer> list1 = recipeOutput.getList();
        if (consume) {
            for (int i = 0; i < list.size(); ++i) {
                list.get(i).func_190918_g(list1.get(i).intValue());
            }
            tank.drain(recipeOutput.getRecipe().input.getFluid(), true);
        }
        return recipeOutput.getRecipe();
    }

    @Override
    public BaseMachineRecipe getRecipeOutputFluid(String name, boolean adjustInput, List<ItemStack> list, FluidTank tank) {
        List<BaseMachineRecipe> recipes = this.map_recipes.get(name);
        int size = this.map_recipe_managers.get(name).getSize();
        for (BaseMachineRecipe baseMachineRecipe : recipes) {
            int j;
            int[] col = new int[size];
            int[] col1 = new int[size];
            ArrayList<Integer> lst = new ArrayList<Integer>();
            for (int i = 0; i < size; ++i) {
                lst.add(i);
            }
            List<IInputItemStack> recipeInputList = baseMachineRecipe.input.getInputs();
            ArrayList<Integer> lst1 = new ArrayList<Integer>();
            if (tank.getFluid() == null) {
                return null;
            }
            if (!tank.getFluid().isFluidEqual(baseMachineRecipe.input.getFluid())) {
                return null;
            }
            if (tank.getFluidAmount() < 1000) {
                return null;
            }
            block2: for (j = 0; j < list.size(); ++j) {
                for (int i = 0; i < recipeInputList.size(); ++i) {
                    if (!recipeInputList.get(i).matches(list.get(j)) || lst1.contains(i)) continue;
                    lst1.add(i);
                    col1[j] = i;
                    continue block2;
                }
            }
            if (lst.size() != lst1.size()) continue;
            for (j = 0; j < list.size(); ++j) {
                ItemStack stack2 = recipeInputList.get(col1[j]).getInputs().get(0);
                ItemStack stack = list.get(j);
                if (stack.func_190916_E() < stack2.func_190916_E()) {
                    return null;
                }
                col[j] = stack2.func_190916_E();
            }
            if (adjustInput) {
                for (j = 0; j < list.size(); ++j) {
                    list.get(j).func_190920_e(list.get(j).func_190916_E() - col[j]);
                }
                tank.drain(baseMachineRecipe.input.getFluid(), true);
                break;
            }
            return baseMachineRecipe;
        }
        return null;
    }

    @Override
    public MachineRecipe getRecipeOutputMachineFluid(IBaseRecipe recipe, List<BaseMachineRecipe> recipe_list, boolean adjustInput, List<ItemStack> list, FluidTank tank) {
        int size = recipe.getSize();
        for (BaseMachineRecipe baseMachineRecipe : recipe_list) {
            int j;
            if (!recipe.require()) {
                int j2;
                int[] col = new int[size];
                int[] col1 = new int[size];
                ArrayList<Integer> lst = new ArrayList<Integer>();
                for (int i = 0; i < size; ++i) {
                    lst.add(i);
                }
                List<IInputItemStack> recipeInputList = baseMachineRecipe.input.getInputs();
                ArrayList<Integer> lst1 = new ArrayList<Integer>();
                block2: for (j2 = 0; j2 < list.size(); ++j2) {
                    for (int i = 0; i < recipeInputList.size(); ++i) {
                        if (!recipeInputList.get(i).matches(list.get(j2)) || lst1.contains(i)) continue;
                        lst1.add(i);
                        col1[j2] = i;
                        continue block2;
                    }
                }
                if (lst.size() != lst1.size()) continue;
                for (j2 = 0; j2 < list.size(); ++j2) {
                    ItemStack stack2 = recipeInputList.get(col1[j2]).getInputs().get(0);
                    col[j2] = stack2.func_190916_E();
                }
                if (adjustInput) {
                    for (j2 = 0; j2 < list.size(); ++j2) {
                        list.get(j2).func_190920_e(list.get(j2).func_190916_E() - col[j2]);
                    }
                    tank.drain(baseMachineRecipe.input.getFluid(), true);
                    break;
                }
                return new MachineRecipe(baseMachineRecipe, Arrays.stream(col).boxed().collect(Collectors.toList()));
            }
            List<IInputItemStack> recipeInputList = baseMachineRecipe.input.getInputs();
            boolean need = true;
            for (int i = 0; i < size; ++i) {
                if (!recipeInputList.get(i).matches(list.get(i))) {
                    need = true;
                    break;
                }
                if (recipeInputList.get(i).getInputs().get(0).func_190916_E() > list.get(i).func_190916_E()) {
                    need = true;
                    break;
                }
                need = false;
            }
            if (need) continue;
            ArrayList<Integer> integer = new ArrayList<Integer>();
            for (j = 0; j < list.size(); ++j) {
                integer.add(recipeInputList.get(j).getInputs().get(0).func_190916_E());
            }
            if (adjustInput) {
                for (j = 0; j < list.size(); ++j) {
                    list.get(j).func_190920_e(list.get(j).func_190916_E() - recipeInputList.get(j).getAmount());
                }
                tank.drain(baseMachineRecipe.input.getFluid(), true);
                break;
            }
            return new MachineRecipe(baseMachineRecipe, integer);
        }
        return null;
    }

    @Override
    public void addInitRecipes(IHasRecipe hasRecipe) {
        if (this.canAdd) {
            this.recipes.add(hasRecipe);
        }
    }

    @Override
    public MachineRecipe getRecipeOutputMachineFluid(String name, boolean consume, List<ItemStack> list, FluidTank tank) {
        List<BaseMachineRecipe> recipes = this.map_recipes.get(name);
        int size = this.map_recipe_managers.get(name).getSize();
        for (BaseMachineRecipe baseMachineRecipe : recipes) {
            int j;
            int[] col = new int[size];
            int[] col1 = new int[size];
            ArrayList<Integer> lst = new ArrayList<Integer>();
            for (int i = 0; i < size; ++i) {
                lst.add(i);
            }
            List<IInputItemStack> recipeInputList = baseMachineRecipe.input.getInputs();
            ArrayList<Integer> lst1 = new ArrayList<Integer>();
            if (tank.getFluid() == null) {
                return null;
            }
            if (!tank.getFluid().isFluidEqual(baseMachineRecipe.input.getFluid())) {
                return null;
            }
            if (tank.getFluidAmount() < 1000) {
                return null;
            }
            block2: for (j = 0; j < list.size(); ++j) {
                for (int i = 0; i < recipeInputList.size(); ++i) {
                    if (!recipeInputList.get(i).matches(list.get(j)) || lst1.contains(i)) continue;
                    lst1.add(i);
                    col1[j] = i;
                    continue block2;
                }
            }
            if (lst.size() != lst1.size()) continue;
            for (j = 0; j < list.size(); ++j) {
                ItemStack stack2 = recipeInputList.get(col1[j]).getInputs().get(0);
                ItemStack stack = list.get(j);
                if (stack.func_190916_E() < stack2.func_190916_E()) {
                    return null;
                }
                col[j] = stack2.func_190916_E();
            }
            if (consume) {
                for (j = 0; j < list.size(); ++j) {
                    list.get(j).func_190920_e(list.get(j).func_190916_E() - col[j]);
                }
                tank.drain(baseMachineRecipe.input.getFluid(), true);
                break;
            }
            return new MachineRecipe(baseMachineRecipe, Arrays.stream(col).boxed().collect(Collectors.toList()));
        }
        return null;
    }

    @Override
    public void addRecipeList(String name, List<BaseMachineRecipe> list) {
        if (!this.map_recipes.containsKey(name)) {
            this.map_recipes.put(name, list);
        } else {
            this.map_recipes.replace(name, list);
        }
    }

    @Override
    public RecipeArrayList<IRecipeInputStack> getMap_recipe_managers_itemStack(String name) {
        return this.map_recipe_managers_itemStack.get(name);
    }

    @Override
    public List<IHasRecipe> getRecipesForInit() {
        return this.recipes;
    }

    @Override
    public void addRecipe(String name, BaseMachineRecipe recipe) {
        if (!this.map_recipes.containsKey(name)) {
            List<IInputItemStack> iInputItemStackList = recipe.input.getInputs();
            RecipeArrayList inputStackList = new RecipeArrayList();
            for (IInputItemStack recipeInput : iInputItemStackList) {
                inputStackList.add(new RecipeInputStack(recipeInput));
            }
            this.map_recipe_managers_itemStack.put(name, inputStackList);
            if (recipe.input.hasFluids()) {
                ArrayList<Fluid> fluidStackList = new ArrayList<Fluid>();
                fluidStackList.add(recipe.input.getFluid().getFluid());
                this.map_fluid_input.put(name, fluidStackList);
            }
            LinkedList<BaseMachineRecipe> lst = new LinkedList<BaseMachineRecipe>();
            if (name.equals("comb_macerator")) {
                recipe.output.items.get(0).func_190920_e(3);
            }
            lst.add(recipe);
            this.map_recipes.put(name, lst);
        } else {
            if (name.equals("comb_macerator")) {
                recipe.output.items.get(0).func_190920_e(3);
            }
            RecipeArrayList<IRecipeInputStack> iRecipeInputList = this.map_recipe_managers_itemStack.get(name);
            if (recipe.input.hasFluids()) {
                List<Fluid> fluidStackList = this.map_fluid_input.get(name);
                if (fluidStackList != null) {
                    fluidStackList.add(recipe.input.getFluid().getFluid());
                } else {
                    fluidStackList = new ArrayList<Fluid>();
                    fluidStackList.add(recipe.input.getFluid().getFluid());
                    this.map_fluid_input.put(name, fluidStackList);
                }
            }
            if (iRecipeInputList.isEmpty()) {
                for (IInputItemStack input1 : recipe.input.getInputs()) {
                    iRecipeInputList.add(new RecipeInputStack(input1));
                }
            } else {
                block2: for (IInputItemStack input1 : recipe.input.getInputs()) {
                    for (ItemStack stack : input1.getInputs()) {
                        boolean continues1 = false;
                        for (IRecipeInputStack input : iRecipeInputList) {
                            if (input.matched(stack)) continue;
                            iRecipeInputList.add(new RecipeInputStack(input1));
                            continues1 = true;
                            break;
                        }
                        if (!continues1) continue;
                        continue block2;
                    }
                }
            }
            this.map_recipe_managers_itemStack.replace(name, iRecipeInputList);
            this.map_recipes.get(name).add(recipe);
        }
    }

    @Override
    public List<BaseMachineRecipe> getRecipeList(String name) {
        return this.map_recipes.get(name);
    }

    @Override
    public void optimize() {
        for (Map.Entry<String, List<BaseMachineRecipe>> entry : this.map_recipes.entrySet()) {
            entry.setValue(new ArrayList(entry.getValue()));
        }
    }

    @Override
    public Set<Map.Entry<ItemStack, BaseMachineRecipe>> getRecipeStack(String name) {
        List<BaseMachineRecipe> list = this.map_recipes.get(name);
        HashMap<ItemStack, BaseMachineRecipe> baseMachineRecipeMap = new HashMap<ItemStack, BaseMachineRecipe>();
        for (BaseMachineRecipe baseMachineRecipe : list) {
            baseMachineRecipeMap.put(baseMachineRecipe.input.getInputs().get(0).getInputs().get(0), baseMachineRecipe);
        }
        return baseMachineRecipeMap.entrySet();
    }

    @Override
    public void removeAll(String recipe) {
        this.map_recipes.remove(recipe);
        this.map_recipe_managers_itemStack.remove(recipe);
    }

    @Override
    public void reloadRecipes(String className) {
        this.getRecipesForInit().forEach(iHasRecipe -> {
            if (className.equals(iHasRecipe.getClass().getName())) {
                iHasRecipe.init();
            }
        });
    }

    @Override
    public void initializationRecipes() {
        this.getRecipesForInit().forEach(iHasRecipe -> {
            if (!this.registeredRecipes.contains(iHasRecipe.getName())) {
                this.registeredRecipes.add(iHasRecipe.getName());
                iHasRecipe.init();
            }
        });
        this.fluid_recipe.initializationRecipes();
    }

    @Override
    public BaseMachineRecipe getRecipeOutput(IBaseRecipe recipe, List<BaseMachineRecipe> recipes, boolean adjustInput, ItemStack ... stacks) {
        List<ItemStack> stack1 = Arrays.asList(stacks);
        int size = recipe.getSize();
        if (size > 1) {
            if (!recipe.require()) {
                int[] col = new int[size];
                int[] col1 = new int[size];
                for (BaseMachineRecipe baseMachineRecipe : recipes) {
                    int j;
                    List<IInputItemStack> recipeInputList = baseMachineRecipe.input.getInputs();
                    int count = 0;
                    block1: for (int j2 = 0; j2 < stack1.size(); ++j2) {
                        for (int i = 0; i < recipeInputList.size(); ++i) {
                            if (!recipeInputList.get(i).matches(stack1.get(j2))) continue;
                            ++count;
                            col1[j2] = i;
                            continue block1;
                        }
                    }
                    if (count != size) continue;
                    boolean canMatch = true;
                    for (j = 0; j < stack1.size(); ++j) {
                        IInputItemStack inputStack = recipeInputList.get(col1[j]);
                        if (stack1.get(j).func_190916_E() < inputStack.getInputs().get(0).func_190916_E()) {
                            canMatch = false;
                            break;
                        }
                        col[j] = inputStack.getInputs().get(0).func_190916_E();
                    }
                    if (!canMatch) continue;
                    if (adjustInput) {
                        for (j = 0; j < stack1.size(); ++j) {
                            stack1.get(j).func_190920_e(stack1.get(j).func_190916_E() - col[j]);
                        }
                        break;
                    }
                    return baseMachineRecipe;
                }
            } else {
                for (BaseMachineRecipe baseMachineRecipe : recipes) {
                    List<IInputItemStack> recipeInputList = baseMachineRecipe.input.getInputs();
                    boolean matchesAll = true;
                    for (int i = 0; i < size; ++i) {
                        if (recipeInputList.get(i).matches(stack1.get(i)) && recipeInputList.get(i).getInputs().get(0).func_190916_E() <= stack1.get(i).func_190916_E()) continue;
                        matchesAll = false;
                        break;
                    }
                    if (!matchesAll) continue;
                    if (adjustInput) {
                        for (int j = 0; j < stack1.size(); ++j) {
                            stack1.get(j).func_190920_e(stack1.get(j).func_190916_E() - recipeInputList.get(j).getAmount());
                        }
                        continue;
                    }
                    return baseMachineRecipe;
                }
            }
        } else {
            return this.getRecipeMultiOutput(recipe, recipes, adjustInput, stack1);
        }
        return null;
    }

    @Override
    public BaseMachineRecipe getRecipeOutput(String name, boolean adjustInput, ItemStack ... stacks) {
        List<ItemStack> stackList = Arrays.asList(stacks);
        IBaseRecipe recipe = this.getRecipe(name);
        List<BaseMachineRecipe> recipes = this.getRecipeList(name);
        int size = recipe.getSize();
        if (size > 1) {
            if (!recipe.require()) {
                int[] requiredCounts = new int[size];
                int[] matchingIndices = new int[size];
                for (BaseMachineRecipe baseMachineRecipe : recipes) {
                    int j;
                    boolean[] matched = new boolean[size];
                    List<IInputItemStack> recipeInputList = baseMachineRecipe.input.getInputs();
                    block1: for (j = 0; j < stackList.size(); ++j) {
                        for (int i = 0; i < recipeInputList.size(); ++i) {
                            if (matched[i] || !recipeInputList.get(i).matches(stackList.get(j))) continue;
                            matched[i] = true;
                            matchingIndices[j] = i;
                            continue block1;
                        }
                    }
                    if (!IntStream.range(0, size).allMatch(idx -> matched[idx])) continue;
                    for (j = 0; j < stackList.size(); ++j) {
                        ItemStack requiredStack = recipeInputList.get(matchingIndices[j]).getInputs().get(0);
                        ItemStack providedStack = stackList.get(j);
                        if (providedStack.func_190916_E() < requiredStack.func_190916_E()) {
                            return null;
                        }
                        requiredCounts[j] = requiredStack.func_190916_E();
                    }
                    if (adjustInput) {
                        for (j = 0; j < stackList.size(); ++j) {
                            stackList.get(j).func_190920_e(stackList.get(j).func_190916_E() - requiredCounts[j]);
                        }
                        break;
                    }
                    return baseMachineRecipe;
                }
            } else {
                for (BaseMachineRecipe baseMachineRecipe : recipes) {
                    List<IInputItemStack> recipeInputList = baseMachineRecipe.input.getInputs();
                    boolean isValid = true;
                    for (int i = 0; i < size; ++i) {
                        if (recipeInputList.get(i).matches(stackList.get(i)) && recipeInputList.get(i).getInputs().get(0).func_190916_E() <= stackList.get(i).func_190916_E()) continue;
                        isValid = false;
                        break;
                    }
                    if (!isValid) continue;
                    if (adjustInput) {
                        for (int j = 0; j < stackList.size(); ++j) {
                            stackList.get(j).func_190920_e(stackList.get(j).func_190916_E() - recipeInputList.get(j).getAmount());
                        }
                        break;
                    }
                    return baseMachineRecipe;
                }
            }
        } else {
            return this.getRecipeMultiOutput(recipe, recipes, adjustInput, stackList);
        }
        return null;
    }

    @Override
    public MachineRecipe getRecipeMachineOutput(String name, boolean adjustInput, ItemStack ... stacks) {
        List<ItemStack> stack1 = Arrays.asList(stacks);
        IBaseRecipe recipe = this.getRecipe(name);
        List<BaseMachineRecipe> recipes = this.getRecipeList(name);
        int size = recipe.getSize();
        if (size > 1) {
            if (!recipe.require()) {
                for (BaseMachineRecipe baseMachineRecipe : recipes) {
                    int j;
                    int[] col = new int[size];
                    int[] col1 = new int[size];
                    ArrayList<Integer> lst = new ArrayList<Integer>();
                    for (int i = 0; i < size; ++i) {
                        lst.add(i);
                    }
                    List<IInputItemStack> recipeInputList = baseMachineRecipe.input.getInputs();
                    ArrayList<Integer> lst1 = new ArrayList<Integer>();
                    block2: for (j = 0; j < stack1.size(); ++j) {
                        for (int i = 0; i < recipeInputList.size(); ++i) {
                            if (!recipeInputList.get(i).matches(stack1.get(j)) || lst1.contains(i)) continue;
                            lst1.add(i);
                            col1[j] = i;
                            continue block2;
                        }
                    }
                    if (lst.size() != lst1.size()) continue;
                    for (j = 0; j < stack1.size(); ++j) {
                        ItemStack stack2 = recipeInputList.get(col1[j]).getInputs().get(0);
                        ItemStack stack = stack1.get(j);
                        if (stack.func_190916_E() < stack2.func_190916_E()) {
                            return null;
                        }
                        col[j] = stack2.func_190916_E();
                    }
                    if (adjustInput) {
                        for (j = 0; j < stack1.size(); ++j) {
                            stack1.get(j).func_190920_e(stack1.get(j).func_190916_E() - col[j]);
                        }
                        break;
                    }
                    return new MachineRecipe(baseMachineRecipe, Arrays.stream(col).boxed().collect(Collectors.toList()));
                }
            } else {
                for (BaseMachineRecipe baseMachineRecipe : recipes) {
                    int j;
                    List<IInputItemStack> recipeInputList = baseMachineRecipe.input.getInputs();
                    boolean need = true;
                    for (int i = 0; i < size; ++i) {
                        if (!recipeInputList.get(i).matches(stack1.get(i))) {
                            need = true;
                            break;
                        }
                        if (recipeInputList.get(i).getInputs().get(0).func_190916_E() > stack1.get(i).func_190916_E()) {
                            need = true;
                            break;
                        }
                        need = false;
                    }
                    if (need) continue;
                    ArrayList<Integer> integer = new ArrayList<Integer>();
                    for (j = 0; j < stack1.size(); ++j) {
                        integer.add(recipeInputList.get(j).getInputs().get(0).func_190916_E());
                    }
                    if (adjustInput) {
                        for (j = 0; j < stack1.size(); ++j) {
                            stack1.get(j).func_190920_e(stack1.get(j).func_190916_E() - recipeInputList.get(j).getAmount());
                        }
                        continue;
                    }
                    return new MachineRecipe(baseMachineRecipe, integer);
                }
            }
        } else {
            return this.getRecipeMachineMultiOutput(recipe, recipes, adjustInput, Arrays.asList(stacks));
        }
        return null;
    }

    @Override
    public boolean needContinue(MachineRecipe recipe, InvSlotRecipes slot) {
        if (recipe == null) {
            return false;
        }
        BaseMachineRecipe recipe1 = recipe.getRecipe();
        if (slot.getRecipe().workbench()) {
            for (int i = 0; i < recipe1.input.getInputs().size(); ++i) {
                if (slot.get(i).func_190916_E() >= recipe.getList().get(i)) continue;
                return false;
            }
        } else {
            for (int i = 0; i < recipe1.input.getInputs().size(); ++i) {
                if (!slot.get(i).func_190926_b() && slot.get(i).func_190916_E() >= recipe.getList().get(i)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean needContinue(MachineRecipe recipe, InvSlotRecipes slot, FluidTank tank) {
        if (recipe == null) {
            return false;
        }
        BaseMachineRecipe recipe1 = recipe.getRecipe();
        for (int i = 0; i < recipe1.input.getInputs().size(); ++i) {
            if (!slot.get(i).func_190926_b() && slot.get(i).func_190916_E() >= recipe.getList().get(i)) continue;
            return false;
        }
        return !recipe.getRecipe().input.hasFluids() || tank.getFluid() != null && tank.getFluid().getFluid().equals(recipe1.input.getFluid().getFluid()) && tank.getFluidAmount() >= recipe1.input.getFluid().amount;
    }

    @Override
    public BaseMachineRecipe getRecipeOutputFromInstruments(String name, boolean adjustInput, ItemStack ... stacks) {
        List<BaseMachineRecipe> recipes = this.map_recipes.get(name);
        List<ItemStack> stack1 = Arrays.asList(stacks);
        IBaseRecipe recipe = this.map_recipe_managers.get(name);
        int size = recipe.getSize();
        if (!recipe.require()) {
            for (BaseMachineRecipe baseMachineRecipe : recipes) {
                int j;
                int[] col = new int[size];
                int[] col1 = new int[size];
                ArrayList<Integer> lst = new ArrayList<Integer>();
                for (int i = 0; i < size; ++i) {
                    lst.add(i);
                }
                List<IInputItemStack> recipeInputList = baseMachineRecipe.input.getInputs();
                ArrayList<Integer> lst1 = new ArrayList<Integer>();
                block2: for (j = 0; j < stack1.size(); ++j) {
                    for (int i = 0; i < recipeInputList.size(); ++i) {
                        if (!recipeInputList.get(i).matches(stack1.get(j)) || lst1.contains(i)) continue;
                        lst1.add(i);
                        col1[j] = i;
                        continue block2;
                    }
                }
                if (lst.size() != lst1.size()) continue;
                for (j = 0; j < stack1.size(); ++j) {
                    ItemStack stack2 = recipeInputList.get(col1[j]).getInputs().get(0);
                    ItemStack stack = stack1.get(j);
                    if (stack.func_190916_E() < stack2.func_190916_E()) {
                        return null;
                    }
                    col[j] = stack2.func_190916_E();
                }
                if (adjustInput) {
                    for (j = 0; j < stack1.size(); ++j) {
                        stack1.get(j).func_190920_e(stack1.get(j).func_190916_E() - col[j]);
                    }
                    break;
                }
                return baseMachineRecipe;
            }
        } else {
            for (BaseMachineRecipe baseMachineRecipe : recipes) {
                List<IInputItemStack> recipeInputList = baseMachineRecipe.input.getInputs();
                boolean need = true;
                for (int i = 0; i < size; ++i) {
                    if (!recipeInputList.get(i).matches(stack1.get(i))) {
                        need = true;
                        break;
                    }
                    if (recipeInputList.get(i).getInputs().get(0).func_190916_E() > stack1.get(i).func_190916_E()) {
                        need = true;
                        break;
                    }
                    need = false;
                }
                if (need) continue;
                if (adjustInput) {
                    for (int j = 0; j < stack1.size(); ++j) {
                        stack1.get(j).func_190920_e(stack1.get(j).func_190916_E() - recipeInputList.get(j).getAmount());
                    }
                    break;
                }
                return baseMachineRecipe;
            }
        }
        return null;
    }

    @Override
    public BaseMachineRecipe getRecipeOutput(IBaseRecipe recipe, List<BaseMachineRecipe> recipes, boolean adjustInput, List<ItemStack> stacks) {
        int size = recipe.getSize();
        if (!recipe.require()) {
            for (BaseMachineRecipe baseMachineRecipe : recipes) {
                int j;
                int[] col = new int[size];
                int[] col1 = new int[size];
                ArrayList<Integer> lst = new ArrayList<Integer>();
                for (int i = 0; i < size; ++i) {
                    lst.add(i);
                }
                List<IInputItemStack> recipeInputList = baseMachineRecipe.input.getInputs();
                ArrayList<Integer> lst1 = new ArrayList<Integer>();
                block2: for (j = 0; j < stacks.size(); ++j) {
                    for (int i = 0; i < recipeInputList.size(); ++i) {
                        if (!recipeInputList.get(i).matches(stacks.get(j)) || lst1.contains(i)) continue;
                        lst1.add(i);
                        col1[j] = i;
                        continue block2;
                    }
                }
                if (lst.size() != lst1.size()) continue;
                for (j = 0; j < stacks.size(); ++j) {
                    ItemStack stack2 = recipeInputList.get(col1[j]).getInputs().get(0);
                    ItemStack stack = stacks.get(j);
                    if (stack.func_190916_E() < stack2.func_190916_E()) {
                        return null;
                    }
                    col[j] = stack2.func_190916_E();
                }
                if (adjustInput) {
                    for (j = 0; j < stacks.size(); ++j) {
                        stacks.get(j).func_190920_e(stacks.get(j).func_190916_E() - col[j]);
                    }
                    break;
                }
                return baseMachineRecipe;
            }
        } else {
            for (BaseMachineRecipe baseMachineRecipe : recipes) {
                List<IInputItemStack> recipeInputList = baseMachineRecipe.input.getInputs();
                boolean need = true;
                for (int i = 0; i < size; ++i) {
                    if (!recipeInputList.get(i).matches(stacks.get(i))) {
                        need = true;
                        break;
                    }
                    need = false;
                }
                if (need) continue;
                if (adjustInput) {
                    for (int j = 0; j < stacks.size(); ++j) {
                        stacks.get(j).func_190920_e(stacks.get(j).func_190916_E() - recipeInputList.get(j).getAmount());
                    }
                    break;
                }
                return baseMachineRecipe;
            }
        }
        return null;
    }

    @Override
    public BaseMachineRecipe getRecipeConsume(IBaseRecipe recipe, MachineRecipe recipes, boolean adjustInput, List<ItemStack> stacks) {
        List<Integer> integerList = recipes.getList();
        if (adjustInput) {
            for (int i = 0; i < stacks.size(); ++i) {
                stacks.get(i).func_190918_g(integerList.get(i).intValue());
            }
        }
        return recipes.getRecipe();
    }

    @Override
    public MachineRecipe getMachineRecipeConsume(IBaseRecipe recipe, MachineRecipe recipes, boolean adjustInput, List<ItemStack> stacks) {
        if (recipes == null) {
            return null;
        }
        List<Integer> integerList = recipes.getList();
        if (adjustInput) {
            for (int i = 0; i < stacks.size(); ++i) {
                stacks.get(i).func_190918_g(integerList.get(i).intValue());
            }
        }
        return recipes;
    }

    @Override
    public MachineRecipe getRecipeMachineRecipeOutput(IBaseRecipe recipe, List<BaseMachineRecipe> recipes, boolean adjustInput, List<ItemStack> stacks) {
        int size = recipe.getSize();
        if (!recipe.require()) {
            for (BaseMachineRecipe baseMachineRecipe : recipes) {
                int j;
                int[] col = new int[size];
                int[] col1 = new int[size];
                ArrayList<Integer> lst = new ArrayList<Integer>();
                for (int i = 0; i < size; ++i) {
                    lst.add(i);
                }
                List<IInputItemStack> recipeInputList = baseMachineRecipe.input.getInputs();
                ArrayList<Integer> lst1 = new ArrayList<Integer>();
                block2: for (j = 0; j < stacks.size(); ++j) {
                    for (int i = 0; i < recipeInputList.size(); ++i) {
                        if (!recipeInputList.get(i).matches(stacks.get(j)) || lst1.contains(i)) continue;
                        lst1.add(i);
                        col1[j] = i;
                        continue block2;
                    }
                }
                if (lst.size() != lst1.size()) continue;
                for (j = 0; j < stacks.size(); ++j) {
                    ItemStack stack2 = recipeInputList.get(col1[j]).getInputs().get(0);
                    col[j] = stack2.func_190916_E();
                }
                if (adjustInput) {
                    for (j = 0; j < stacks.size(); ++j) {
                        stacks.get(j).func_190920_e(stacks.get(j).func_190916_E() - col[j]);
                    }
                    break;
                }
                return new MachineRecipe(baseMachineRecipe, Arrays.stream(col).boxed().collect(Collectors.toList()));
            }
        } else {
            for (BaseMachineRecipe baseMachineRecipe : recipes) {
                int j;
                List<IInputItemStack> recipeInputList = baseMachineRecipe.input.getInputs();
                boolean need = true;
                for (int i = 0; i < size; ++i) {
                    if (!recipeInputList.get(i).matches(stacks.get(i))) {
                        need = true;
                        break;
                    }
                    need = false;
                }
                if (need) continue;
                ArrayList<Integer> integer = new ArrayList<Integer>();
                for (j = 0; j < size; ++j) {
                    integer.add(recipeInputList.get(j).getInputs().get(0).func_190916_E());
                }
                if (adjustInput) {
                    for (j = 0; j < stacks.size(); ++j) {
                        stacks.get(j).func_190920_e(stacks.get(j).func_190916_E() - recipeInputList.get(j).getAmount());
                    }
                    break;
                }
                return new MachineRecipe(baseMachineRecipe, integer);
            }
        }
        return null;
    }

    @Override
    public BaseMachineRecipe getRecipeMultiOutput(IBaseRecipe recipe, List<BaseMachineRecipe> recipes, boolean adjustInput, List<ItemStack> stacks) {
        int size = recipe.getSize();
        if (!recipe.require()) {
            int[] col = new int[size];
            int[] col1 = new int[size];
            for (BaseMachineRecipe baseMachineRecipe : recipes) {
                int j;
                boolean[] matched = new boolean[size];
                List<IInputItemStack> recipeInputList = baseMachineRecipe.input.getInputs();
                block1: for (j = 0; j < stacks.size(); ++j) {
                    for (int i = 0; i < recipeInputList.size(); ++i) {
                        if (matched[i] || !recipeInputList.get(i).matches(stacks.get(j))) continue;
                        matched[i] = true;
                        col1[j] = i;
                        continue block1;
                    }
                }
                if (!IntStream.range(0, size).allMatch(idx -> matched[idx])) continue;
                for (j = 0; j < stacks.size(); ++j) {
                    ItemStack stack2 = recipeInputList.get(col1[j]).getInputs().get(0);
                    col[j] = stack2.func_190916_E();
                }
                if (adjustInput) {
                    for (j = 0; j < stacks.size(); ++j) {
                        stacks.get(j).func_190920_e(stacks.get(j).func_190916_E() - col[j]);
                    }
                    break;
                }
                return baseMachineRecipe;
            }
        } else {
            for (BaseMachineRecipe baseMachineRecipe : recipes) {
                List<IInputItemStack> recipeInputList = baseMachineRecipe.input.getInputs();
                if (!recipeInputList.get(0).matches(stacks.get(0))) continue;
                if (adjustInput) {
                    for (int j = 0; j < stacks.size(); ++j) {
                        stacks.get(j).func_190920_e(stacks.get(j).func_190916_E() - recipeInputList.get(j).getAmount());
                    }
                    continue;
                }
                return baseMachineRecipe;
            }
        }
        return null;
    }

    @Override
    public MachineRecipe getRecipeMachineMultiOutput(IBaseRecipe recipe, List<BaseMachineRecipe> recipes, boolean adjustInput, List<ItemStack> stacks) {
        int size = recipe.getSize();
        if (!recipe.require()) {
            int[] col = new int[size];
            int[] col1 = new int[size];
            for (BaseMachineRecipe baseMachineRecipe : recipes) {
                int j;
                boolean[] matched = new boolean[size];
                List<IInputItemStack> recipeInputList = baseMachineRecipe.input.getInputs();
                block1: for (j = 0; j < stacks.size(); ++j) {
                    for (int i = 0; i < recipeInputList.size(); ++i) {
                        if (matched[i] || !recipeInputList.get(i).matches(stacks.get(j))) continue;
                        matched[i] = true;
                        col1[j] = i;
                        continue block1;
                    }
                }
                if (!IntStream.range(0, size).allMatch(idx -> matched[idx])) continue;
                for (j = 0; j < stacks.size(); ++j) {
                    ItemStack stack2 = recipeInputList.get(col1[j]).getInputs().get(0);
                    col[j] = stack2.func_190916_E();
                }
                if (adjustInput) {
                    for (j = 0; j < stacks.size(); ++j) {
                        stacks.get(j).func_190920_e(stacks.get(j).func_190916_E() - col[j]);
                    }
                    break;
                }
                return new MachineRecipe(baseMachineRecipe, Arrays.stream(col).boxed().collect(Collectors.toList()));
            }
        } else {
            for (BaseMachineRecipe baseMachineRecipe : recipes) {
                int j;
                List<IInputItemStack> recipeInputList = baseMachineRecipe.input.getInputs();
                if (!recipeInputList.get(0).matches(stacks.get(0))) continue;
                ArrayList<Integer> amounts = new ArrayList<Integer>();
                for (j = 0; j < stacks.size(); ++j) {
                    amounts.add(recipeInputList.get(j).getInputs().get(0).func_190916_E());
                }
                if (adjustInput) {
                    for (j = 0; j < stacks.size(); ++j) {
                        stacks.get(j).func_190920_e(stacks.get(j).func_190916_E() - recipeInputList.get(j).getAmount());
                    }
                    break;
                }
                return new MachineRecipe(baseMachineRecipe, amounts);
            }
        }
        return null;
    }
}

