/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.research;

import com.denfop.api.research.BaseResearchSystemParts;
import com.denfop.api.research.DataResearches;
import com.denfop.api.research.IDataResearches;
import com.denfop.api.research.IResearchSystem;
import com.denfop.api.research.IResearchSystemParts;
import com.denfop.api.research.ResearchSystem;
import com.denfop.api.research.event.EventDownloadData;
import com.denfop.api.research.event.EventLoadData;
import com.denfop.api.research.event.EventLoadResearchItem;
import com.denfop.api.research.event.EventUnLoadData;
import com.denfop.api.research.main.BaseLevelSystem;
import com.denfop.api.research.main.EnumLeveling;
import com.denfop.api.research.main.IResearch;
import com.denfop.api.research.main.IResearchPages;
import com.denfop.api.research.main.IResearchPart;
import com.denfop.network.packet.PacketResearchSystem;
import com.denfop.network.packet.PacketResearchSystemAdd;
import com.denfop.network.packet.PacketResearchSystemDelete;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntityDamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class BaseResearchSystem
implements IResearchSystem {
    public int max = 0;
    List<String> list_uuids = new ArrayList<String>();
    List<IResearch> list_research;
    List<IResearchPages> list_research_pages;
    List<IResearchPart> list_researcher_parts;
    Map<String, List<IResearch>> map_players;
    Map<Integer, IResearch> map_research;
    Map<String, BaseLevelSystem> map_level;
    IDataResearches data = new DataResearches();
    IResearchSystemParts systemParts;

    public BaseResearchSystem() {
        this.map_players = new HashMap<String, List<IResearch>>();
        this.systemParts = ResearchSystem.systemParts = new BaseResearchSystemParts();
        this.map_research = new HashMap<Integer, IResearch>();
        this.list_research = new ArrayList<IResearch>();
        this.list_research_pages = new ArrayList<IResearchPages>();
        this.list_researcher_parts = new ArrayList<IResearchPart>();
        this.map_level = new HashMap<String, BaseLevelSystem>();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public Map<String, BaseLevelSystem> getMap_level() {
        return this.map_level;
    }

    @Override
    public Map<String, List<IResearch>> getMap_players() {
        return this.map_players;
    }

    @SubscribeEvent
    public void loadDataItem(EventDownloadData event) {
        ItemStack stack = event.stack;
        NBTTagCompound nbt = ModUtils.nbt(stack);
        int id = this.max++;
        nbt.func_74768_a("research_id", id);
        this.map_research.put(id, event.research);
        NBTTagCompound tag = ModUtils.nbt();
        nbt.func_74782_a("research_parts", (NBTBase)tag);
    }

    @Override
    public List<IResearchPart> getCopy(IResearch research) {
        return new ArrayList<IResearchPart>(research.getPartsResearch());
    }

    @Override
    public BaseLevelSystem getLevel(EntityPlayer player) {
        return this.map_level.get(player.func_70005_c_());
    }

    @SubscribeEvent
    public void loadDataItem(EventLoadResearchItem event) {
        int[] list_id;
        ItemStack stack = event.stack;
        NBTTagCompound nbt = ModUtils.nbt(stack);
        List<IResearchPart> list = this.getCopy(event.item.getResearch(stack));
        int id = this.max++;
        nbt.func_74768_a("research_id", id);
        boolean full = nbt.func_74767_n("iu.research.full");
        if (full) {
            this.map_research.put(id, event.item.getResearch(stack));
            return;
        }
        NBTTagCompound tag = (NBTTagCompound)nbt.func_74781_a("research_parts");
        ArrayList<IResearchPart> list_copy = new ArrayList<IResearchPart>();
        for (int j : list_id = tag.func_74759_k("list_parts")) {
            list_copy.add(list.get(j));
        }
        IResearch research = event.item.getResearch(stack);
        research.setPartsResearch(list_copy);
        this.map_research.put(id, research);
    }

    @SubscribeEvent
    public void downloadData(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player.func_130014_f_().field_72995_K) {
            return;
        }
        if (!this.checkData(event.player)) {
            MinecraftForge.EVENT_BUS.post((Event)new EventLoadData(event.player));
        }
    }

    @SubscribeEvent
    public void downloadData(EventLoadData event) {
        this.downloadData(event.player);
    }

    @SubscribeEvent
    public void uploadData(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.checkData(event.player)) {
            MinecraftForge.EVENT_BUS.post((Event)new EventUnLoadData(event.player));
        }
    }

    @SubscribeEvent
    public void attackEntity(LivingDeathEvent event) {
        if (event.getEntity().func_130014_f_().field_72995_K) {
            return;
        }
        if (event.getSource().field_76373_n.equals("player")) {
            if (event.getSource() instanceof EntityDamageSource && !(event.getSource().func_76346_g() instanceof FakePlayer)) {
                EntityDamageSource damage = (EntityDamageSource)event.getSource();
                BaseLevelSystem system = ResearchSystem.instance.getLevel((EntityPlayer)damage.func_76346_g());
                system.addLevel(EnumLeveling.PVP, 1);
                new PacketResearchSystemAdd(EnumLeveling.PVP, 1, (EntityPlayer)damage.func_76346_g());
            }
        } else if (event.getSource().field_76373_n.equals("arrow") && event.getSource().func_76346_g() instanceof EntityPlayer && event.getSource() instanceof EntityDamageSource && !(event.getSource().func_76346_g() instanceof FakePlayer)) {
            EntityDamageSource damage = (EntityDamageSource)event.getSource();
            BaseLevelSystem system = ResearchSystem.instance.getLevel((EntityPlayer)damage.func_76346_g());
            system.addLevel(EnumLeveling.PVP, 1);
            new PacketResearchSystemAdd(EnumLeveling.PVP, 1, (EntityPlayer)damage.func_76346_g());
        }
    }

    @SubscribeEvent
    public void uploadData(EventUnLoadData event) {
        if (event.player.func_130014_f_().field_72995_K) {
            return;
        }
        this.uploadData(event.player);
    }

    @Override
    public void uploadData(EntityPlayer player) {
        this.map_players.remove(player.func_70005_c_());
        this.map_level.remove(player.func_70005_c_());
        this.getUUIDs().remove(player.func_70005_c_());
        new PacketResearchSystemDelete(player);
    }

    @Override
    public void downloadData(EntityPlayer player) {
        NBTTagCompound nbt = player.getEntityData();
        List<IResearch> list = this.data.getListResearches();
        ArrayList<IResearch> list_researches = new ArrayList<IResearch>();
        for (IResearch research : list) {
            if (!nbt.func_74767_n("iu.research." + research.getName())) continue;
            list_researches.add(research);
        }
        BaseLevelSystem levelSystem = new BaseLevelSystem(player);
        this.map_level.put(player.func_70005_c_(), levelSystem);
        this.map_players.put(player.func_70005_c_(), list_researches);
        this.getUUIDs().add(player.func_70005_c_());
        new PacketResearchSystem(levelSystem);
    }

    @Override
    public boolean checkData(EntityPlayer player) {
        return this.getUUIDs().contains(player.func_70005_c_());
    }

    @Override
    public List<String> getUUIDs() {
        return this.list_uuids;
    }

    @Override
    public IResearch getResearchFromItem(ItemStack stack) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        int id = nbt.func_74762_e("research_id");
        return this.map_research.get(id);
    }

    @Override
    public IResearch getResearchFromID(int id) {
        return this.data.getListResearches().get(id);
    }
}

