/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space;

import com.denfop.api.space.IBaseResource;
import com.denfop.api.space.IBody;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.rovers.enums.EnumTypeRovers;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class BaseResource
implements IBaseResource {
    private final FluidStack fluidStack;
    private final EnumTypeRovers typeRovers;
    private ItemStack stack;
    private int max;
    private int min;
    private IBody body;
    private int percentplanet;

    public BaseResource(ItemStack stack, int minchance, int maxchance, int percentplanet, IBody body, EnumTypeRovers typeRovers) {
        this.stack = stack;
        this.fluidStack = null;
        this.max = maxchance;
        this.typeRovers = typeRovers;
        this.min = minchance;
        this.body = body;
        this.percentplanet = percentplanet;
        SpaceNet.instance.addResource(this);
    }

    public BaseResource(FluidStack fluidStack, int minchance, int maxchance, int percentplanet, IBody body, EnumTypeRovers typeRovers) {
        this.stack = null;
        this.fluidStack = fluidStack;
        this.max = maxchance;
        this.min = minchance;
        this.body = body;
        this.typeRovers = typeRovers;
        this.percentplanet = percentplanet;
        SpaceNet.instance.addResource(this);
    }

    public BaseResource(NBTTagCompound tagCompound) {
        this.percentplanet = tagCompound.func_74771_c("percentplanet");
        this.min = tagCompound.func_74771_c("min");
        this.max = tagCompound.func_74771_c("max");
        this.stack = tagCompound.func_74767_n("hasItem") ? new ItemStack(tagCompound.func_74775_l("stack")) : null;
        this.fluidStack = tagCompound.func_74767_n("hasFluid") ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound.func_74775_l("fluidStack")) : null;
        this.typeRovers = EnumTypeRovers.values()[tagCompound.func_74771_c("rovers")];
    }

    @Override
    public ItemStack getItemStack() {
        return this.stack;
    }

    @Override
    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    @Override
    public int getPercentResearchBody() {
        return this.percentplanet;
    }

    @Override
    public int getChance() {
        return this.min;
    }

    @Override
    public int getMaxChance() {
        return this.max;
    }

    @Override
    public IBody getBody() {
        return this.body;
    }

    @Override
    public int getPercentPanel() {
        return this.percentplanet;
    }

    @Override
    public NBTTagCompound writeNBTTag(NBTTagCompound tagCompound) {
        tagCompound.func_74774_a("percentplanet", (byte)this.percentplanet);
        tagCompound.func_74774_a("min", (byte)this.min);
        tagCompound.func_74774_a("max", (byte)this.max);
        tagCompound.func_74774_a("rovers", (byte)this.typeRovers.ordinal());
        tagCompound.func_74757_a("hasItem", this.stack != null);
        if (this.stack != null) {
            tagCompound.func_74782_a("stack", (NBTBase)this.stack.func_77955_b(new NBTTagCompound()));
        }
        tagCompound.func_74757_a("hasFluid", this.fluidStack != null);
        if (this.fluidStack != null) {
            tagCompound.func_74782_a("fluidStack", (NBTBase)this.fluidStack.writeToNBT(new NBTTagCompound()));
        }
        return tagCompound;
    }

    @Override
    public EnumTypeRovers getTypeRovers() {
        return this.typeRovers;
    }
}

