/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space;

import com.denfop.IUItem;
import com.denfop.api.space.Asteroid;
import com.denfop.api.space.BaseResource;
import com.denfop.api.space.EnumLevels;
import com.denfop.api.space.EnumRing;
import com.denfop.api.space.EnumType;
import com.denfop.api.space.IBody;
import com.denfop.api.space.Planet;
import com.denfop.api.space.Satellite;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.Star;
import com.denfop.api.space.System;
import com.denfop.api.space.rovers.enums.EnumTypeRovers;
import com.denfop.blocks.FluidName;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class SpaceInit {
    public static System solarSystem;
    public static Star sun;
    public static Planet mercury;
    public static Planet venus;
    public static Planet earth;
    public static Planet mars;
    public static Planet pluto;
    public static Planet jupiter;
    public static Planet saturn;
    public static Planet uranus;
    public static Planet neptune;
    public static Satellite moon;
    public static Satellite deimos;
    public static Satellite phobos;
    public static System sextantis24;
    public static System cancri55;
    public static System kapteyn;
    public static System kepler148;
    public static System kepler149;
    public static System kepler186;
    public static Satellite io;
    public static Satellite callisto;
    public static Satellite ganymede;
    public static Satellite europe;
    public static Planet ceres;
    public static Satellite charon;
    public static Satellite enceladus;
    public static Satellite titan;
    public static Satellite dione;
    public static Satellite mimas;
    public static Satellite rhea;
    public static Satellite titania;
    public static Satellite umbriel;
    public static Satellite oberon;
    public static Satellite ariel;
    public static Satellite miranda;
    public static Satellite triton;
    public static Satellite proteus;
    public static Satellite tethys;
    public static Planet eris;
    public static Planet makemake;
    public static Planet haumea;
    public static Asteroid asteroids;
    private static Star sextantis;
    private static Star cancri;
    private static Star kapteynSun;
    private static Star kepler186Sun;

    public static void init() {
        solarSystem = new System("solarsystem");
        sextantis24 = new System("sextantis");
        cancri55 = new System("cancri");
        kapteyn = new System("kapteyn");
        kepler148 = new System("kepler148");
        kepler149 = new System("kepler149");
        kepler186 = new System("kepler186");
        sun = new Star("sun", solarSystem, SpaceInit.getTexture("sun"), 7, 0.5);
        sextantis = new Star("24sextantis", sextantis24, SpaceInit.getTexture("24sextantis"), 7, 0.5);
        cancri = new Star("55cancri", cancri55, SpaceInit.getTexture("55cancri"), 7, 0.5);
        kapteynSun = new Star("kapteyn", kapteyn, SpaceInit.getTexture("kapteyn"), 7, 0.5);
        kepler186Sun = new Star("kepler186", kepler186, SpaceInit.getTexture("kepler186"), 7, 0.5);
        asteroids = new Asteroid("asteroid", solarSystem, SpaceInit.getTexture("asteroid"), EnumLevels.SECOND, sun, -108, 0.0, EnumType.NEUTRAL, false, 0, 0.0, 1.0, 0.0, 1.8, 2.0, 500);
        mercury = new Planet("mercury", solarSystem, SpaceInit.getTexture("mercury"), EnumLevels.SECOND, sun, 167, false, 0.55, EnumType.NEUTRAL, false, true, 0, 1.0, 0.05, 4.5);
        venus = new Planet("venus", solarSystem, SpaceInit.getTexture("venus"), EnumLevels.FIRST, sun, 464, true, 0.7, EnumType.DANGEROUS, false, true, 177, 0.75, 0.075, 5.5);
        earth = new Planet("earth", solarSystem, SpaceInit.getTexture("earth"), EnumLevels.NONE, sun, 20, false, 0.9, EnumType.SAFE, true, false, 23, 0.6, 0.1, 4.1);
        moon = new Satellite("moon", solarSystem, SpaceInit.getTexture("moon"), EnumLevels.FIRST, earth, -20, false, 0.12, EnumType.NEUTRAL, false, true, 0, 1.5, 0.035, 1.1);
        mars = new Planet("mars", solarSystem, SpaceInit.getTexture("mars"), EnumLevels.FIRST, sun, -65, false, 1.5, EnumType.NEUTRAL, false, true, 25, 0.5, 0.088, 3.3);
        deimos = new Satellite("deimos", solarSystem, SpaceInit.getTexture("deimos"), EnumLevels.FIRST, mars, -65, false, 0.12f, EnumType.NEUTRAL, false, true, 0, 1.5, 0.025, 6.1);
        phobos = new Satellite("phobos", solarSystem, SpaceInit.getTexture("phobos"), EnumLevels.FIRST, mars, -65, false, 0.15, EnumType.NEUTRAL, false, true, 0, 0.8, 0.025, 7.1);
        ceres = new Planet("ceres", solarSystem, SpaceInit.getTexture("ceres"), EnumLevels.SECOND, sun, -45, false, 1.8, EnumType.NEUTRAL, false, true, 1, 0.45, 0.03, 3.3);
        jupiter = new Planet("jupiter", solarSystem, SpaceInit.getTexture("jupiter"), EnumLevels.NONE, sun, -110, false, 2.8, EnumType.DANGEROUS, false, false, 3, 0.4, 0.5, 3.2);
        europe = new Satellite("europe", solarSystem, SpaceInit.getTexture("europe"), EnumLevels.SECOND, jupiter, -110, false, 0.52, EnumType.NEUTRAL, false, true, 3, 1.844, 0.045, 3.2);
        ganymede = new Satellite("ganymede", solarSystem, SpaceInit.getTexture("ganymede"), EnumLevels.SECOND, jupiter, -110, false, 0.57, EnumType.NEUTRAL, false, true, 3, 0.353, 0.0425, 3.2);
        io = new Satellite("io", solarSystem, SpaceInit.getTexture("io"), EnumLevels.SECOND, jupiter, -110, false, 0.45, EnumType.NEUTRAL, false, true, 3, 0.844, 0.05, 3.2);
        callisto = new Satellite("callisto", solarSystem, SpaceInit.getTexture("callisto"), EnumLevels.SECOND, jupiter, -110, false, 0.63, EnumType.NEUTRAL, false, true, 3, 0.65, 0.04, 3.2);
        saturn = new Planet("saturn", solarSystem, SpaceInit.getTexture("saturn"), EnumLevels.NONE, sun, -140, false, 4.5, EnumType.DANGEROUS, false, false, 26, 0.3, 0.35, 2.8, EnumRing.HORIZONTAL);
        enceladus = new Satellite("enceladus", solarSystem, SpaceInit.getTexture("enceladus"), EnumLevels.THIRD, saturn, -140, false, 0.4, EnumType.NEUTRAL, false, true, 1, 1.4, 0.05, 2.8);
        titan = new Satellite("titan", solarSystem, SpaceInit.getTexture("titan"), EnumLevels.THIRD, saturn, -140, false, 0.625, EnumType.NEUTRAL, false, true, 1, 2.0, 0.0375, 2.8);
        dione = new Satellite("dione", solarSystem, SpaceInit.getTexture("dione"), EnumLevels.THIRD, saturn, -140, false, 0.475, EnumType.NEUTRAL, false, true, 1, 1.6, 0.0425, 2.8);
        mimas = new Satellite("mimas", solarSystem, SpaceInit.getTexture("mimas"), EnumLevels.THIRD, saturn, -140, false, 0.325, EnumType.NEUTRAL, false, true, 1, 1.2, 0.05, 2.8);
        rhea = new Satellite("rhea", solarSystem, SpaceInit.getTexture("rhea"), EnumLevels.THIRD, saturn, -140, false, 0.55, EnumType.NEUTRAL, false, true, 1, 1.8, 0.04, 2.8);
        tethys = new Satellite("tethys", solarSystem, SpaceInit.getTexture("tethys"), EnumLevels.THIRD, saturn, -187, false, 0.665, EnumType.NEUTRAL, false, true, 1, 2.15, 0.03, 3.0);
        uranus = new Planet("uranus", solarSystem, SpaceInit.getTexture("uranus"), EnumLevels.NONE, sun, -195, false, 6.2, EnumType.DANGEROUS, false, false, 28, 0.25, 0.25, 2.4, EnumRing.VERTICAL);
        titania = new Satellite("titania", solarSystem, SpaceInit.getTexture("titania"), EnumLevels.FOURTH, uranus, -195, false, 0.55, EnumType.NEUTRAL, false, true, 1, 1.8, 0.0375, 2.4);
        umbriel = new Satellite("umbriel", solarSystem, SpaceInit.getTexture("umbriel"), EnumLevels.FOURTH, uranus, -195, false, 0.475, EnumType.NEUTRAL, false, true, 1, 1.6, 0.04, 2.4);
        oberon = new Satellite("oberon", solarSystem, SpaceInit.getTexture("oberon"), EnumLevels.FOURTH, uranus, -195, false, 0.625, EnumType.NEUTRAL, false, true, 1, 2.0, 0.035, 2.4);
        ariel = new Satellite("ariel", solarSystem, SpaceInit.getTexture("ariel"), EnumLevels.FOURTH, uranus, -195, false, 0.4, EnumType.NEUTRAL, false, true, 1, 1.4, 0.045, 2.4);
        miranda = new Satellite("miranda", solarSystem, SpaceInit.getTexture("miranda"), EnumLevels.FOURTH, uranus, -195, false, 0.325, EnumType.NEUTRAL, false, true, 1, 1.2, 0.05, 2.4);
        neptune = new Planet("neptune", solarSystem, SpaceInit.getTexture("neptune"), EnumLevels.NONE, sun, -220, false, 7.45, EnumType.DANGEROUS, false, false, 85, 0.25, 0.25, 2.1);
        triton = new Satellite("triton", solarSystem, SpaceInit.getTexture("triton"), EnumLevels.FIVE, neptune, -220, false, 0.425, EnumType.NEUTRAL, false, true, 1, 1.66, 0.045, 2.1);
        proteus = new Satellite("proteus", solarSystem, SpaceInit.getTexture("proteus"), EnumLevels.FIVE, neptune, -220, false, 0.325, EnumType.NEUTRAL, false, true, 1, 1.2, 0.05, 2.1);
        pluto = new Planet("pluto", solarSystem, SpaceInit.getTexture("pluto"), EnumLevels.SIX, sun, -247, false, 8.3, EnumType.NEUTRAL, false, true, 119, 0.15, 0.05, 1.8);
        charon = new Satellite("charon", solarSystem, SpaceInit.getTexture("charon"), EnumLevels.SIX, pluto, -247, false, 0.125, EnumType.NEUTRAL, false, true, 119, 0.15, 0.035, 1.8);
        eris = new Planet("eris", solarSystem, SpaceInit.getTexture("eris"), EnumLevels.SEVEN, sun, -243, false, 8.9, EnumType.NEUTRAL, false, true, 1, 0.1, 0.04, 1.2);
        makemake = new Planet("makemake", solarSystem, SpaceInit.getTexture("makemake"), EnumLevels.SEVEN, sun, -243, false, 9.3, EnumType.NEUTRAL, false, true, 1, 0.075, 0.03, 1.0);
        haumea = new Planet("haumea", solarSystem, SpaceInit.getTexture("haumea"), EnumLevels.SEVEN, sun, -243, false, 9.75, EnumType.NEUTRAL, false, true, 1, 0.05, 0.025, 0.85);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 45), 50, 100, 1, (IBody)mercury, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 45), 75, 100, 3, (IBody)mercury, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 15), 20, 100, 7, (IBody)mercury, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 2, 15), 35, 100, 12, (IBody)mercury, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 15), 40, 100, 20, (IBody)mercury, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 1, 15), 20, 100, 20, (IBody)mercury, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 1, 15), 40, 100, 30, (IBody)mercury, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 2, 15), 20, 100, 40, (IBody)mercury, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone, 1, 15), 20, 100, 55, (IBody)mercury, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone, 4, 15), 40, 100, 65, (IBody)mercury, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 1, 1), 40, 100, 70, (IBody)mercury, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 2, 1), 40, 100, 75, (IBody)mercury, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 2, 1), 50, 100, 80, (IBody)mercury, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 1, 2), 40, 100, 85, (IBody)mercury, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 2, 1), 60, 100, 85, (IBody)mercury, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 2, 2), 70, 100, 90, (IBody)mercury, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 2, 1), 80, 100, 90, (IBody)mercury, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 2, 2), 100, 100, 100, (IBody)mercury, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 4, 1), 100, 100, 100, (IBody)mercury, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 48), 50, 100, 1, (IBody)moon, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 48), 75, 100, 3, (IBody)moon, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 18), 20, 100, 7, (IBody)moon, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 2, 18), 35, 100, 12, (IBody)moon, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 18), 40, 100, 20, (IBody)moon, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 1, 2), 20, 100, 20, (IBody)moon, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 1, 2), 40, 100, 30, (IBody)moon, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 2, 2), 20, 100, 40, (IBody)moon, EnumTypeRovers.PROBE);
        new BaseResource(new FluidStack(FluidName.fluidhyd.getInstance(), 400), 40, 100, 40, (IBody)moon, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone1, 1, 2), 20, 100, 55, (IBody)moon, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone1, 4, 2), 40, 100, 65, (IBody)moon, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 1, 7), 40, 100, 70, (IBody)moon, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 2, 7), 40, 100, 75, (IBody)moon, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluidhyd.getInstance(), 1000), 50, 100, 40, (IBody)moon, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 2, 7), 50, 100, 80, (IBody)moon, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 1, 6), 40, 100, 85, (IBody)moon, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 2, 6), 70, 100, 90, (IBody)moon, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 2, 7), 80, 100, 90, (IBody)moon, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidhyd.getInstance(), 2500), 90, 100, 80, (IBody)moon, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 2, 6), 100, 100, 100, (IBody)moon, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 4, 7), 100, 100, 100, (IBody)moon, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 59), 50, 100, 1, (IBody)venus, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 59), 75, 100, 3, (IBody)venus, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 29), 20, 100, 7, (IBody)venus, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 2, 29), 35, 100, 12, (IBody)venus, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 29), 40, 100, 20, (IBody)venus, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 1, 13), 20, 100, 20, (IBody)venus, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 1, 13), 40, 100, 30, (IBody)venus, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 2, 13), 20, 100, 40, (IBody)venus, EnumTypeRovers.PROBE);
        new BaseResource(new FluidStack(FluidName.fluidhydrogensulfide.getInstance(), 500), 40, 100, 40, (IBody)venus, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone1, 1, 13), 20, 100, 55, (IBody)venus, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone1, 4, 13), 40, 100, 65, (IBody)venus, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 1, 12), 10, 100, 70, (IBody)venus, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 1, 12), 20, 100, 75, (IBody)venus, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluidhydrogensulfide.getInstance(), 1000), 50, 100, 40, (IBody)venus, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 1, 12), 50, 100, 80, (IBody)venus, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 1, 12), 70, 100, 85, (IBody)venus, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 1, 12), 90, 100, 90, (IBody)venus, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidhydrogensulfide.getInstance(), 2000), 90, 100, 80, (IBody)venus, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 2, 12), 100, 100, 100, (IBody)venus, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 44), 50, 100, 1, (IBody)mars, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 44), 75, 100, 3, (IBody)mars, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 14), 20, 100, 7, (IBody)mars, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 2, 14), 35, 100, 12, (IBody)mars, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 14), 40, 100, 20, (IBody)mars, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 1, 14), 20, 100, 20, (IBody)mars, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 1, 14), 40, 100, 30, (IBody)mars, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 2, 14), 20, 100, 40, (IBody)mars, EnumTypeRovers.PROBE);
        new BaseResource(new FluidStack(FluidName.fluidazot.getInstance(), 500), 40, 100, 40, (IBody)mars, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone, 1, 14), 20, 100, 55, (IBody)mars, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone, 4, 14), 40, 100, 65, (IBody)mars, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 1, 0), 40, 100, 70, (IBody)mars, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 2, 0), 40, 100, 75, (IBody)mars, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluidazot.getInstance(), 1000), 50, 100, 40, (IBody)mars, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 2, 0), 50, 100, 80, (IBody)mars, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 1, 15), 40, 100, 85, (IBody)mars, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 2, 15), 70, 100, 90, (IBody)mars, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 2, 0), 80, 100, 90, (IBody)mars, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidazot.getInstance(), 2000), 90, 100, 80, (IBody)mars, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 2, 15), 100, 100, 100, (IBody)mars, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 4, 0), 100, 100, 100, (IBody)mars, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 33), 50, 100, 1, (IBody)ceres, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 33), 75, 100, 3, (IBody)ceres, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 3), 20, 100, 7, (IBody)ceres, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 2, 3), 35, 100, 12, (IBody)ceres, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 3), 40, 100, 20, (IBody)ceres, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 1, 3), 20, 100, 20, (IBody)ceres, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 1, 3), 40, 100, 30, (IBody)ceres, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 2, 3), 20, 100, 40, (IBody)ceres, EnumTypeRovers.PROBE);
        new BaseResource(new FluidStack(FluidName.fluidacetylene.getInstance(), 500), 40, 100, 40, (IBody)ceres, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone, 1, 3), 20, 100, 55, (IBody)ceres, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone, 4, 3), 40, 100, 65, (IBody)ceres, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 6), 40, 100, 70, (IBody)ceres, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 7), 40, 100, 70, (IBody)ceres, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluidacetylene.getInstance(), 1000), 50, 100, 40, (IBody)ceres, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 6), 60, 100, 80, (IBody)ceres, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 7), 60, 100, 80, (IBody)ceres, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 2, 6), 80, 100, 90, (IBody)ceres, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 2, 7), 80, 100, 90, (IBody)ceres, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidacetylene.getInstance(), 2000), 90, 100, 80, (IBody)ceres, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 2, 6), 100, 100, 100, (IBody)ceres, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 2, 7), 100, 100, 100, (IBody)ceres, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 31), 50, 100, 1, (IBody)asteroids, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 31), 75, 100, 3, (IBody)asteroids, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 1), 20, 100, 7, (IBody)asteroids, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 2, 1), 15, 100, 12, (IBody)asteroids, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 1), 40, 100, 20, (IBody)asteroids, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 1, 1), 20, 100, 20, (IBody)asteroids, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 1, 1), 40, 100, 10, (IBody)asteroids, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 2, 1), 20, 100, 40, (IBody)asteroids, EnumTypeRovers.PROBE);
        new BaseResource(new FluidStack(FluidName.fluidazot.getInstance(), 500), 40, 100, 40, (IBody)asteroids, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone, 1, 1), 20, 100, 55, (IBody)asteroids, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone, 4, 1), 40, 100, 65, (IBody)asteroids, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 1), 40, 100, 70, (IBody)asteroids, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 2), 40, 100, 70, (IBody)asteroids, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluidazot.getInstance(), 1000), 50, 100, 40, (IBody)asteroids, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 1), 60, 100, 80, (IBody)asteroids, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 2), 60, 100, 80, (IBody)asteroids, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 2, 1), 80, 100, 90, (IBody)asteroids, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 2, 2), 80, 100, 90, (IBody)asteroids, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidhyd.getInstance(), 2500), 75, 100, 95, (IBody)asteroids, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidazot.getInstance(), 2500), 90, 100, 80, (IBody)asteroids, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 2, 1), 100, 100, 100, (IBody)asteroids, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 2, 2), 100, 100, 100, (IBody)asteroids, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 50), 50, 100, 1, (IBody)phobos, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 50), 75, 100, 3, (IBody)phobos, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 20), 20, 100, 7, (IBody)phobos, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 2, 20), 15, 100, 12, (IBody)phobos, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 20), 40, 100, 20, (IBody)phobos, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 1, 4), 20, 100, 20, (IBody)phobos, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 1, 4), 40, 100, 10, (IBody)phobos, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 2, 4), 20, 100, 40, (IBody)phobos, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone1, 1, 4), 20, 100, 55, (IBody)phobos, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone1, 4, 4), 40, 100, 65, (IBody)phobos, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 1, 10), 40, 100, 70, (IBody)phobos, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 1, 11), 40, 100, 70, (IBody)phobos, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 1, 10), 60, 100, 80, (IBody)phobos, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 1, 11), 60, 100, 80, (IBody)phobos, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 2, 10), 80, 100, 90, (IBody)phobos, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 2, 11), 80, 100, 90, (IBody)phobos, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 2, 10), 100, 100, 100, (IBody)phobos, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 2, 11), 100, 100, 100, (IBody)phobos, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 35), 50, 100, 1, (IBody)deimos, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 35), 75, 100, 3, (IBody)deimos, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 5), 20, 100, 7, (IBody)deimos, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 2, 5), 15, 100, 12, (IBody)deimos, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 5), 40, 100, 20, (IBody)deimos, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 1, 5), 20, 100, 20, (IBody)deimos, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 1, 5), 40, 100, 10, (IBody)deimos, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 2, 5), 20, 100, 40, (IBody)deimos, EnumTypeRovers.PROBE);
        new BaseResource(new FluidStack(FluidName.fluidHelium.getInstance(), 500), 40, 100, 40, (IBody)deimos, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone, 1, 5), 20, 100, 55, (IBody)deimos, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone, 4, 5), 40, 100, 65, (IBody)deimos, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 10), 10, 100, 70, (IBody)deimos, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluidHelium.getInstance(), 1000), 50, 100, 40, (IBody)deimos, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 10), 40, 100, 80, (IBody)deimos, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 10), 70, 100, 90, (IBody)deimos, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidHelium.getInstance(), 2500), 90, 100, 80, (IBody)deimos, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 10), 100, 100, 100, (IBody)deimos, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidHelium.getInstance(), 5000), 100, 100, 100, (IBody)deimos, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 42), 50, 100, 1, (IBody)io, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 42), 75, 100, 3, (IBody)io, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 12), 20, 100, 7, (IBody)io, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 2, 12), 35, 100, 12, (IBody)io, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 12), 40, 100, 20, (IBody)io, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 1, 12), 20, 100, 20, (IBody)io, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 1, 12), 40, 100, 30, (IBody)io, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 2, 12), 20, 100, 40, (IBody)io, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone, 1, 12), 20, 100, 55, (IBody)io, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone, 4, 12), 40, 100, 65, (IBody)io, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 1, 10), 40, 100, 70, (IBody)io, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 1, 11), 40, 100, 70, (IBody)io, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 1, 10), 60, 100, 80, (IBody)io, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 1, 11), 60, 100, 80, (IBody)io, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 2, 10), 80, 100, 90, (IBody)io, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 2, 11), 80, 100, 90, (IBody)io, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 2, 10), 100, 100, 100, (IBody)io, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 2, 11), 100, 100, 100, (IBody)io, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 32), 50, 100, 1, (IBody)callisto, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 32), 75, 100, 3, (IBody)callisto, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 2), 20, 100, 7, (IBody)callisto, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 2, 2), 35, 100, 12, (IBody)callisto, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 2), 40, 100, 20, (IBody)callisto, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 1, 2), 20, 100, 20, (IBody)callisto, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 1, 2), 40, 100, 30, (IBody)callisto, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 2, 2), 20, 100, 40, (IBody)callisto, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone, 1, 2), 20, 100, 55, (IBody)callisto, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone, 4, 2), 40, 100, 65, (IBody)callisto, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 3), 40, 100, 70, (IBody)callisto, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 4), 40, 100, 70, (IBody)callisto, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 5), 40, 100, 70, (IBody)callisto, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 3), 60, 100, 80, (IBody)callisto, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 4), 60, 100, 80, (IBody)callisto, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 5), 60, 100, 80, (IBody)callisto, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 2, 3), 80, 100, 90, (IBody)callisto, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 2, 4), 80, 100, 90, (IBody)callisto, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 2, 5), 80, 100, 90, (IBody)callisto, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 2, 3), 100, 100, 100, (IBody)callisto, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 2, 4), 100, 100, 100, (IBody)callisto, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 2, 5), 100, 100, 100, (IBody)callisto, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 40), 50, 100, 1, (IBody)ganymede, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 40), 75, 100, 3, (IBody)ganymede, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 10), 20, 100, 7, (IBody)ganymede, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 2, 10), 35, 100, 12, (IBody)ganymede, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 10), 40, 100, 20, (IBody)ganymede, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 1, 10), 20, 100, 20, (IBody)ganymede, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 1, 10), 40, 100, 30, (IBody)ganymede, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 2, 10), 20, 100, 40, (IBody)ganymede, EnumTypeRovers.PROBE);
        new BaseResource(new FluidStack(FluidName.fluidcarbonmonoxide.getInstance(), 500), 40, 100, 40, (IBody)ganymede, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone, 1, 10), 20, 100, 55, (IBody)ganymede, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone, 4, 10), 40, 100, 65, (IBody)ganymede, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 1, 2), 40, 100, 70, (IBody)ganymede, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 1, 3), 40, 100, 70, (IBody)ganymede, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluidcarbonmonoxide.getInstance(), 1000), 50, 100, 40, (IBody)ganymede, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 1, 2), 60, 100, 80, (IBody)ganymede, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 1, 3), 60, 100, 80, (IBody)ganymede, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 2, 2), 80, 100, 90, (IBody)ganymede, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 2, 3), 80, 100, 90, (IBody)ganymede, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidcarbonmonoxide.getInstance(), 2000), 90, 100, 80, (IBody)ganymede, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 2, 2), 100, 100, 100, (IBody)ganymede, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 2, 3), 100, 100, 100, (IBody)ganymede, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidcarbonmonoxide.getInstance(), 5000), 100, 100, 100, (IBody)ganymede, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 39), 50, 100, 1, (IBody)europe, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 39), 75, 100, 3, (IBody)europe, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 9), 20, 100, 7, (IBody)europe, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 2, 9), 35, 100, 12, (IBody)europe, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 9), 40, 100, 20, (IBody)europe, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 1, 9), 20, 100, 20, (IBody)europe, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 1, 9), 40, 100, 30, (IBody)europe, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 2, 9), 20, 100, 40, (IBody)europe, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone, 1, 9), 20, 100, 55, (IBody)europe, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone, 4, 9), 40, 100, 65, (IBody)europe, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 1, 0), 40, 100, 70, (IBody)europe, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 1, 1), 40, 100, 70, (IBody)europe, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 1, 4), 40, 100, 70, (IBody)europe, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 1, 0), 60, 100, 80, (IBody)europe, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 1, 1), 60, 100, 80, (IBody)europe, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 1, 4), 60, 100, 80, (IBody)europe, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 2, 0), 80, 100, 90, (IBody)europe, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 2, 1), 80, 100, 90, (IBody)europe, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 2, 4), 80, 100, 90, (IBody)europe, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 2, 0), 100, 100, 100, (IBody)europe, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 2, 1), 100, 100, 100, (IBody)europe, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 2, 4), 100, 100, 100, (IBody)europe, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 37), 50, 100, 1, (IBody)enceladus, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 37), 75, 100, 3, (IBody)enceladus, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 7), 20, 100, 7, (IBody)enceladus, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 2, 7), 35, 100, 12, (IBody)enceladus, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 7), 40, 100, 20, (IBody)enceladus, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 1, 7), 20, 100, 20, (IBody)enceladus, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 1, 7), 40, 100, 30, (IBody)enceladus, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 2, 7), 20, 100, 40, (IBody)enceladus, EnumTypeRovers.PROBE);
        new BaseResource(new FluidStack(FluidName.fluidacetylene.getInstance(), 500), 40, 100, 40, (IBody)enceladus, EnumTypeRovers.PROBE);
        new BaseResource(new FluidStack(FluidName.fluidHelium.getInstance(), 500), 40, 100, 40, (IBody)enceladus, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone, 1, 7), 20, 100, 55, (IBody)enceladus, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone, 4, 7), 40, 100, 65, (IBody)enceladus, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 13), 40, 100, 70, (IBody)enceladus, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluidacetylene.getInstance(), 1000), 50, 100, 40, (IBody)enceladus, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluidHelium.getInstance(), 1000), 50, 100, 40, (IBody)enceladus, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 13), 60, 100, 80, (IBody)enceladus, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 2, 13), 80, 100, 90, (IBody)enceladus, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidacetylene.getInstance(), 2000), 90, 100, 80, (IBody)enceladus, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidHelium.getInstance(), 2000), 90, 100, 80, (IBody)enceladus, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 2, 13), 100, 100, 100, (IBody)enceladus, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 55), 50, 100, 1, (IBody)titan, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 55), 75, 100, 3, (IBody)titan, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 25), 20, 100, 7, (IBody)titan, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 2, 25), 35, 100, 12, (IBody)titan, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 25), 40, 100, 20, (IBody)titan, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 1, 9), 20, 100, 20, (IBody)titan, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 1, 9), 40, 100, 30, (IBody)titan, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 2, 9), 20, 100, 40, (IBody)titan, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone1, 1, 9), 20, 100, 55, (IBody)titan, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone1, 4, 9), 40, 100, 65, (IBody)titan, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 1, 5), 40, 100, 70, (IBody)titan, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 1, 6), 40, 100, 70, (IBody)titan, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 1, 5), 60, 100, 80, (IBody)titan, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 1, 6), 60, 100, 80, (IBody)titan, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 2, 5), 80, 100, 90, (IBody)titan, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 2, 6), 80, 100, 90, (IBody)titan, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 2, 5), 100, 100, 100, (IBody)titan, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 2, 6), 100, 100, 100, (IBody)titan, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 36), 50, 100, 1, (IBody)dione, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 36), 75, 100, 3, (IBody)dione, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 6), 20, 100, 7, (IBody)dione, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 2, 6), 35, 100, 12, (IBody)dione, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 6), 40, 100, 20, (IBody)dione, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 1, 6), 20, 100, 20, (IBody)dione, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 1, 6), 40, 100, 30, (IBody)dione, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 2, 6), 20, 100, 40, (IBody)dione, EnumTypeRovers.PROBE);
        new BaseResource(new FluidStack(FluidName.fluidmethane.getInstance(), 500), 40, 100, 40, (IBody)dione, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone, 1, 6), 20, 100, 55, (IBody)dione, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone, 4, 6), 40, 100, 65, (IBody)dione, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 11), 40, 100, 70, (IBody)dione, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 12), 40, 100, 70, (IBody)dione, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluidmethane.getInstance(), 1000), 50, 100, 40, (IBody)dione, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 11), 60, 100, 80, (IBody)dione, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 12), 60, 100, 80, (IBody)dione, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 2, 11), 80, 100, 90, (IBody)dione, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 2, 12), 80, 100, 90, (IBody)dione, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidmethane.getInstance(), 2000), 80, 100, 80, (IBody)dione, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 2, 11), 100, 100, 100, (IBody)dione, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 2, 12), 100, 100, 100, (IBody)dione, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidmethane.getInstance(), 9500), 100, 100, 100, (IBody)dione, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 46), 50, 100, 1, (IBody)mimas, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 46), 75, 100, 3, (IBody)mimas, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 16), 20, 100, 7, (IBody)mimas, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 2, 16), 35, 100, 12, (IBody)mimas, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 16), 40, 100, 20, (IBody)mimas, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 1, 0), 20, 100, 20, (IBody)mimas, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 1, 0), 40, 100, 30, (IBody)mimas, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 2, 0), 20, 100, 40, (IBody)mimas, EnumTypeRovers.PROBE);
        new BaseResource(new FluidStack(FluidName.fluidpropane.getInstance(), 500), 40, 100, 40, (IBody)mimas, EnumTypeRovers.PROBE);
        new BaseResource(new FluidStack(FluidName.fluidbutene.getInstance(), 500), 40, 100, 40, (IBody)mimas, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone1, 1, 0), 20, 100, 55, (IBody)mimas, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone1, 4, 0), 40, 100, 65, (IBody)mimas, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 1, 3), 20, 100, 70, (IBody)mimas, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluidpropane.getInstance(), 1000), 50, 100, 70, (IBody)mimas, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluidbutene.getInstance(), 1000), 50, 100, 70, (IBody)mimas, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 1, 3), 40, 100, 80, (IBody)mimas, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidpropane.getInstance(), 2000), 80, 100, 80, (IBody)mimas, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidbutene.getInstance(), 2000), 80, 100, 80, (IBody)mimas, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 1, 3), 60, 100, 90, (IBody)mimas, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 1, 3), 100, 100, 100, (IBody)mimas, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidpropane.getInstance(), 5000), 90, 100, 100, (IBody)mimas, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidbutene.getInstance(), 5000), 90, 100, 100, (IBody)mimas, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 53), 50, 100, 1, (IBody)rhea, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 53), 75, 100, 3, (IBody)rhea, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 23), 20, 100, 7, (IBody)rhea, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 2, 23), 35, 100, 12, (IBody)rhea, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 23), 40, 100, 20, (IBody)rhea, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 1, 7), 20, 100, 20, (IBody)rhea, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 1, 7), 40, 100, 30, (IBody)rhea, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 2, 7), 20, 100, 40, (IBody)rhea, EnumTypeRovers.PROBE);
        new BaseResource(new FluidStack(FluidName.fluidnitrogenhydride.getInstance(), 1000), 50, 100, 40, (IBody)rhea, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone1, 1, 7), 20, 100, 55, (IBody)rhea, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone1, 4, 7), 40, 100, 65, (IBody)rhea, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 1, 0), 40, 100, 70, (IBody)rhea, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 1, 1), 40, 100, 70, (IBody)rhea, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluidnitrogenhydride.getInstance(), 1000), 50, 100, 40, (IBody)rhea, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 1, 0), 60, 100, 80, (IBody)rhea, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 1, 2), 60, 100, 80, (IBody)rhea, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 2, 1), 80, 100, 90, (IBody)rhea, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 2, 0), 80, 100, 90, (IBody)rhea, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 2, 1), 100, 100, 100, (IBody)rhea, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidnitrogenhydride.getInstance(), 1000), 50, 100, 40, (IBody)rhea, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 2, 2), 100, 100, 100, (IBody)rhea, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 54), 50, 100, 1, (IBody)tethys, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 54), 75, 100, 3, (IBody)tethys, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 24), 20, 100, 7, (IBody)tethys, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 2, 24), 35, 100, 12, (IBody)tethys, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 24), 40, 100, 20, (IBody)tethys, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 1, 8), 20, 100, 20, (IBody)tethys, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 1, 8), 40, 100, 30, (IBody)tethys, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 2, 8), 20, 100, 40, (IBody)tethys, EnumTypeRovers.PROBE);
        new BaseResource(new FluidStack(FluidName.fluiddecane.getInstance(), 500), 40, 100, 40, (IBody)tethys, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone1, 1, 8), 20, 100, 55, (IBody)tethys, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone1, 4, 8), 40, 100, 65, (IBody)tethys, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 1, 3), 40, 100, 70, (IBody)tethys, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 1, 4), 40, 100, 70, (IBody)tethys, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluiddecane.getInstance(), 1000), 50, 100, 40, (IBody)tethys, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 1, 3), 60, 100, 80, (IBody)tethys, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 1, 4), 60, 100, 80, (IBody)tethys, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 2, 3), 80, 100, 90, (IBody)tethys, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 2, 4), 80, 100, 90, (IBody)tethys, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluiddecane.getInstance(), 2000), 80, 100, 80, (IBody)tethys, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 2, 3), 100, 100, 100, (IBody)tethys, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 2, 4), 100, 100, 100, (IBody)tethys, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluiddecane.getInstance(), 5000), 100, 100, 100, (IBody)tethys, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 56), 50, 100, 1, (IBody)titania, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 56), 75, 100, 3, (IBody)titania, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 26), 20, 100, 7, (IBody)titania, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 2, 26), 35, 100, 12, (IBody)titania, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 26), 40, 100, 20, (IBody)titania, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 1, 10), 20, 100, 20, (IBody)titania, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 1, 10), 40, 100, 30, (IBody)titania, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 2, 10), 20, 100, 40, (IBody)titania, EnumTypeRovers.PROBE);
        new BaseResource(new FluidStack(FluidName.fluidchlorum.getInstance(), 500), 40, 100, 40, (IBody)titania, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone1, 1, 10), 20, 100, 55, (IBody)titania, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone1, 4, 10), 40, 100, 65, (IBody)titania, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 1, 7), 40, 100, 70, (IBody)titania, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 1, 8), 40, 100, 70, (IBody)titania, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluidchlorum.getInstance(), 1000), 50, 100, 40, (IBody)titania, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 1, 7), 60, 100, 80, (IBody)titania, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 1, 8), 60, 100, 80, (IBody)titania, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 2, 7), 80, 100, 90, (IBody)titania, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 2, 8), 80, 100, 90, (IBody)titania, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidchlorum.getInstance(), 2000), 80, 100, 80, (IBody)titania, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 2, 7), 100, 100, 100, (IBody)titania, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 2, 8), 100, 100, 100, (IBody)titania, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidchlorum.getInstance(), 4000), 100, 100, 100, (IBody)titania, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 58), 50, 100, 1, (IBody)umbriel, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 58), 75, 100, 3, (IBody)umbriel, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 28), 20, 100, 7, (IBody)umbriel, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 2, 28), 35, 100, 12, (IBody)umbriel, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 28), 40, 100, 20, (IBody)umbriel, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 1, 12), 20, 100, 20, (IBody)umbriel, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 1, 12), 40, 100, 30, (IBody)umbriel, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 2, 12), 20, 100, 40, (IBody)umbriel, EnumTypeRovers.PROBE);
        new BaseResource(new FluidStack(FluidName.fluidfluor.getInstance(), 500), 40, 100, 40, (IBody)umbriel, EnumTypeRovers.PROBE);
        new BaseResource(new FluidStack(FluidName.fluidHelium.getInstance(), 500), 40, 100, 40, (IBody)umbriel, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone1, 1, 12), 20, 100, 55, (IBody)umbriel, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone1, 4, 12), 40, 100, 65, (IBody)umbriel, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 1, 11), 20, 100, 70, (IBody)umbriel, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluidfluor.getInstance(), 1000), 50, 100, 70, (IBody)umbriel, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluidHelium.getInstance(), 1000), 50, 100, 70, (IBody)umbriel, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 1, 11), 40, 100, 80, (IBody)umbriel, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidfluor.getInstance(), 2000), 80, 100, 80, (IBody)umbriel, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidHelium.getInstance(), 2000), 80, 100, 80, (IBody)umbriel, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 1, 11), 80, 100, 90, (IBody)umbriel, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidfluor.getInstance(), 5000), 90, 100, 100, (IBody)umbriel, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidHelium.getInstance(), 5000), 90, 100, 100, (IBody)umbriel, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidmethane.getInstance(), 4000), 90, 100, 100, (IBody)umbriel, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 49), 50, 100, 1, (IBody)oberon, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 49), 75, 100, 3, (IBody)oberon, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 19), 20, 100, 7, (IBody)oberon, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 2, 19), 35, 100, 12, (IBody)oberon, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 19), 40, 100, 20, (IBody)oberon, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 1, 3), 20, 100, 20, (IBody)oberon, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 1, 3), 40, 100, 30, (IBody)oberon, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 2, 3), 20, 100, 40, (IBody)oberon, EnumTypeRovers.PROBE);
        new BaseResource(new FluidStack(FluidName.fluidethane.getInstance(), 500), 40, 100, 40, (IBody)oberon, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone1, 1, 3), 20, 100, 55, (IBody)oberon, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone1, 4, 3), 40, 100, 65, (IBody)oberon, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 1, 8), 40, 100, 70, (IBody)oberon, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 1, 9), 40, 100, 70, (IBody)oberon, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluidethane.getInstance(), 1000), 50, 100, 40, (IBody)oberon, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 1, 9), 60, 100, 80, (IBody)oberon, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 1, 8), 60, 100, 80, (IBody)oberon, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 2, 9), 80, 100, 90, (IBody)oberon, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 2, 8), 80, 100, 90, (IBody)oberon, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidethane.getInstance(), 2000), 80, 100, 80, (IBody)oberon, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 2, 9), 100, 100, 100, (IBody)oberon, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 2, 8), 100, 100, 100, (IBody)oberon, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidethane.getInstance(), 4000), 100, 100, 100, (IBody)oberon, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 30), 50, 100, 1, (IBody)ariel, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 30), 75, 100, 3, (IBody)ariel, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 0), 20, 100, 7, (IBody)ariel, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 2, 0), 35, 100, 12, (IBody)ariel, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 0), 40, 100, 20, (IBody)ariel, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 1, 0), 20, 100, 20, (IBody)ariel, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 1, 0), 40, 100, 30, (IBody)ariel, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 2, 0), 20, 100, 40, (IBody)ariel, EnumTypeRovers.PROBE);
        new BaseResource(new FluidStack(FluidName.fluidbromine.getInstance(), 500), 40, 100, 40, (IBody)ariel, EnumTypeRovers.PROBE);
        new BaseResource(new FluidStack(FluidName.fluidethylene.getInstance(), 500), 40, 100, 40, (IBody)ariel, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone, 1, 0), 20, 100, 55, (IBody)ariel, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone, 4, 0), 40, 100, 65, (IBody)ariel, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 0), 20, 100, 70, (IBody)ariel, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluidbromine.getInstance(), 1000), 50, 100, 70, (IBody)ariel, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluidethylene.getInstance(), 1000), 50, 100, 70, (IBody)ariel, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 0), 40, 100, 80, (IBody)ariel, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidbromine.getInstance(), 2000), 80, 100, 80, (IBody)ariel, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidethylene.getInstance(), 2000), 80, 100, 80, (IBody)ariel, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 0), 60, 100, 90, (IBody)ariel, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 0), 80, 100, 100, (IBody)ariel, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidbromine.getInstance(), 4000), 100, 100, 100, (IBody)ariel, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidethylene.getInstance(), 4000), 100, 100, 100, (IBody)ariel, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 47), 50, 100, 1, (IBody)miranda, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 47), 75, 100, 3, (IBody)miranda, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 17), 20, 100, 7, (IBody)miranda, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 2, 17), 35, 100, 12, (IBody)miranda, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 17), 40, 100, 20, (IBody)miranda, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 1, 1), 20, 100, 20, (IBody)miranda, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 1, 1), 40, 100, 30, (IBody)miranda, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 2, 1), 20, 100, 40, (IBody)miranda, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone1, 1, 1), 20, 100, 55, (IBody)miranda, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone1, 4, 1), 40, 100, 65, (IBody)miranda, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 1, 4), 40, 100, 70, (IBody)miranda, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 1, 5), 40, 100, 70, (IBody)miranda, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluidnitrogenoxy.getInstance(), 1000), 40, 100, 70, (IBody)miranda, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluidsulfurtrioxide.getInstance(), 1000), 50, 100, 70, (IBody)miranda, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 1, 4), 60, 100, 80, (IBody)miranda, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 1, 5), 60, 100, 80, (IBody)miranda, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 2, 4), 80, 100, 90, (IBody)miranda, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 2, 5), 80, 100, 90, (IBody)miranda, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 2, 4), 100, 100, 100, (IBody)miranda, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 2, 5), 100, 100, 100, (IBody)miranda, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidnitrogenoxy.getInstance(), 3000), 90, 100, 90, (IBody)miranda, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidsulfurtrioxide.getInstance(), 3000), 90, 100, 90, (IBody)miranda, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 57), 50, 100, 1, (IBody)triton, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 57), 75, 100, 3, (IBody)triton, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 27), 20, 100, 7, (IBody)triton, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 2, 27), 35, 100, 12, (IBody)triton, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 27), 40, 100, 20, (IBody)triton, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 1, 11), 20, 100, 20, (IBody)triton, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 1, 11), 40, 100, 30, (IBody)triton, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 2, 11), 20, 100, 40, (IBody)triton, EnumTypeRovers.PROBE);
        new BaseResource(new FluidStack(FluidName.fluidiodine.getInstance(), 500), 40, 100, 40, (IBody)triton, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone1, 1, 11), 20, 100, 55, (IBody)triton, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone1, 4, 11), 40, 100, 65, (IBody)triton, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 1, 9), 40, 100, 70, (IBody)triton, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 1, 10), 40, 100, 70, (IBody)triton, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluidiodine.getInstance(), 1000), 50, 100, 60, (IBody)triton, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 1, 9), 60, 100, 80, (IBody)triton, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 1, 10), 60, 100, 80, (IBody)triton, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 2, 9), 80, 100, 90, (IBody)triton, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 2, 10), 80, 100, 90, (IBody)triton, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidiodine.getInstance(), 2000), 80, 100, 80, (IBody)triton, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 2, 9), 100, 100, 100, (IBody)triton, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore3, 2, 10), 100, 100, 100, (IBody)triton, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidiodine.getInstance(), 4000), 100, 100, 100, (IBody)triton, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 52), 50, 100, 1, (IBody)proteus, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 52), 75, 100, 3, (IBody)proteus, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 22), 20, 100, 7, (IBody)proteus, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 2, 22), 35, 100, 12, (IBody)proteus, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 22), 40, 100, 20, (IBody)proteus, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 1, 6), 20, 100, 20, (IBody)proteus, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 1, 6), 40, 100, 30, (IBody)proteus, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 2, 6), 20, 100, 40, (IBody)proteus, EnumTypeRovers.PROBE);
        new BaseResource(new FluidStack(FluidName.fluidxenon.getInstance(), 500), 40, 100, 40, (IBody)proteus, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone1, 1, 6), 20, 100, 55, (IBody)proteus, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone1, 4, 6), 40, 100, 65, (IBody)proteus, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 1, 14), 40, 100, 70, (IBody)proteus, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 1, 15), 40, 100, 70, (IBody)proteus, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluidxenon.getInstance(), 1000), 50, 100, 60, (IBody)proteus, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 1, 14), 60, 100, 80, (IBody)proteus, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 1, 15), 60, 100, 80, (IBody)proteus, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 2, 14), 80, 100, 90, (IBody)proteus, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 2, 15), 80, 100, 90, (IBody)proteus, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidxenon.getInstance(), 2000), 80, 100, 80, (IBody)proteus, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 2, 14), 100, 100, 100, (IBody)proteus, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 2, 15), 100, 100, 100, (IBody)proteus, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidxenon.getInstance(), 4000), 100, 100, 100, (IBody)proteus, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 51), 50, 100, 1, (IBody)pluto, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 51), 75, 100, 3, (IBody)pluto, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 21), 20, 100, 7, (IBody)pluto, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 2, 21), 35, 100, 12, (IBody)pluto, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 21), 40, 100, 20, (IBody)pluto, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 1, 5), 20, 100, 20, (IBody)pluto, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 1, 5), 40, 100, 30, (IBody)pluto, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone1, 2, 5), 20, 100, 40, (IBody)pluto, EnumTypeRovers.PROBE);
        new BaseResource(new FluidStack(FluidName.fluidnitricacid.getInstance(), 500), 40, 100, 40, (IBody)pluto, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone1, 1, 5), 20, 100, 55, (IBody)pluto, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 1, 13), 60, 100, 60, (IBody)pluto, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone1, 4, 5), 40, 100, 65, (IBody)pluto, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluidnitricacid.getInstance(), 1000), 50, 100, 70, (IBody)pluto, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 1, 12), 80, 100, 70, (IBody)pluto, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 1, 13), 80, 100, 70, (IBody)pluto, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 2, 12), 100, 100, 80, (IBody)pluto, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 2, 13), 100, 100, 80, (IBody)pluto, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidnitricacid.getInstance(), 2000), 80, 100, 80, (IBody)pluto, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidnitricacid.getInstance(), 5000), 90, 100, 90, (IBody)pluto, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 4, 12), 100, 100, 90, (IBody)pluto, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore2, 4, 13), 100, 100, 90, (IBody)pluto, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidnitricacid.getInstance(), 9500), 100, 100, 100, (IBody)pluto, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 34), 50, 100, 1, (IBody)charon, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 34), 75, 100, 3, (IBody)charon, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 4), 20, 100, 7, (IBody)charon, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 2, 4), 35, 100, 12, (IBody)charon, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 3, 4), 40, 100, 20, (IBody)charon, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 1, 4), 20, 100, 20, (IBody)charon, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 1, 4), 40, 100, 30, (IBody)charon, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 2, 4), 20, 100, 40, (IBody)charon, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone, 1, 4), 20, 100, 55, (IBody)charon, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone, 4, 4), 40, 100, 65, (IBody)charon, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 8), 40, 100, 70, (IBody)charon, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 9), 40, 100, 70, (IBody)charon, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluidpropylene.getInstance(), 1000), 40, 100, 70, (IBody)charon, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluidethylene.getInstance(), 1000), 50, 100, 70, (IBody)charon, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 8), 60, 100, 80, (IBody)charon, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 9), 60, 100, 80, (IBody)charon, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 2, 8), 80, 100, 90, (IBody)charon, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 2, 9), 80, 100, 90, (IBody)charon, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 2, 8), 100, 100, 100, (IBody)charon, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 2, 9), 100, 100, 100, (IBody)charon, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidpropylene.getInstance(), 5000), 90, 100, 90, (IBody)charon, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidethylene.getInstance(), 5000), 90, 100, 90, (IBody)charon, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 38), 50, 100, 1, (IBody)eris, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 38), 20, 100, 7, (IBody)eris, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 1, 8), 20, 100, 20, (IBody)eris, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 2, 8), 20, 100, 40, (IBody)eris, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone, 2, 8), 40, 100, 65, (IBody)eris, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 14), 40, 100, 70, (IBody)eris, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 15), 40, 100, 70, (IBody)eris, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluidfluor.getInstance(), 1000), 40, 100, 70, (IBody)eris, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluidchlorum.getInstance(), 1000), 50, 100, 70, (IBody)eris, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluidbromine.getInstance(), 1000), 50, 100, 70, (IBody)eris, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluidiodine.getInstance(), 1000), 50, 100, 70, (IBody)eris, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 14), 60, 100, 80, (IBody)eris, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 1, 15), 60, 100, 80, (IBody)eris, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidfluor.getInstance(), 3000), 90, 100, 90, (IBody)eris, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidbromine.getInstance(), 3000), 90, 100, 90, (IBody)eris, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidiodine.getInstance(), 3000), 90, 100, 90, (IBody)eris, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 2, 14), 100, 100, 100, (IBody)eris, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore, 2, 15), 100, 100, 100, (IBody)eris, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidfluor.getInstance(), 5000), 90, 100, 100, (IBody)eris, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidchlorum.getInstance(), 5000), 90, 100, 100, (IBody)eris, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidbromine.getInstance(), 5000), 90, 100, 100, (IBody)eris, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidiodine.getInstance(), 3000), 90, 100, 100, (IBody)eris, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 43), 50, 100, 1, (IBody)makemake, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 43), 20, 100, 7, (IBody)makemake, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 13), 20, 100, 20, (IBody)makemake, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 2, 13), 20, 100, 40, (IBody)makemake, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone, 1, 13), 40, 100, 65, (IBody)makemake, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 1, 12), 40, 100, 70, (IBody)makemake, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 1, 13), 40, 100, 70, (IBody)makemake, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 1, 14), 40, 100, 70, (IBody)makemake, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluiddecane.getInstance(), 1000), 40, 100, 70, (IBody)makemake, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluidsulfuricacid.getInstance(), 1000), 50, 100, 70, (IBody)makemake, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 1, 12), 60, 100, 80, (IBody)makemake, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 1, 13), 60, 100, 80, (IBody)makemake, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 1, 14), 60, 100, 80, (IBody)makemake, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluiddecane.getInstance(), 3000), 90, 100, 90, (IBody)makemake, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidsulfuricacid.getInstance(), 3000), 90, 100, 90, (IBody)makemake, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 2, 12), 100, 100, 100, (IBody)makemake, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 2, 13), 100, 100, 100, (IBody)makemake, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 2, 14), 100, 100, 100, (IBody)makemake, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluiddecane.getInstance(), 5000), 90, 100, 100, (IBody)makemake, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidsulfuricacid.getInstance(), 5000), 90, 100, 100, (IBody)makemake, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 41), 50, 100, 1, (IBody)haumea, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 41), 20, 100, 7, (IBody)haumea, EnumTypeRovers.ROVERS);
        new BaseResource(new ItemStack((Item)IUItem.spaceItem, 1, 11), 20, 100, 20, (IBody)haumea, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_cobblestone, 2, 11), 20, 100, 40, (IBody)haumea, EnumTypeRovers.PROBE);
        new BaseResource(new ItemStack((Block)IUItem.space_stone, 1, 11), 40, 100, 65, (IBody)haumea, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluidxenon.getInstance(), 1000), 40, 100, 70, (IBody)haumea, EnumTypeRovers.SATELLITE);
        new BaseResource(new FluidStack(FluidName.fluiddecane.getInstance(), 1000), 50, 100, 70, (IBody)haumea, EnumTypeRovers.SATELLITE);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 2, 5), 60, 100, 80, (IBody)haumea, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 2, 6), 60, 100, 80, (IBody)haumea, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 2, 7), 60, 100, 80, (IBody)haumea, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 2, 8), 60, 100, 80, (IBody)haumea, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 2, 9), 60, 100, 80, (IBody)haumea, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidxenon.getInstance(), 3000), 90, 100, 90, (IBody)haumea, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluiddecane.getInstance(), 3000), 90, 100, 90, (IBody)haumea, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 4, 5), 100, 100, 100, (IBody)haumea, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 4, 6), 100, 100, 100, (IBody)haumea, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 4, 7), 100, 100, 100, (IBody)haumea, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 4, 8), 100, 100, 100, (IBody)haumea, EnumTypeRovers.ROCKET);
        new BaseResource(new ItemStack((Block)IUItem.space_ore1, 4, 9), 100, 100, 100, (IBody)haumea, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluidxenon.getInstance(), 5000), 90, 100, 100, (IBody)haumea, EnumTypeRovers.ROCKET);
        new BaseResource(new FluidStack(FluidName.fluiddecane.getInstance(), 5000), 90, 100, 100, (IBody)haumea, EnumTypeRovers.ROCKET);
        SpaceNet.instance.getColonieNet().addItemStack(mercury, (short)10, new ItemStack((Block)IUItem.space_ore2, 1, 1));
        SpaceNet.instance.getColonieNet().addItemStack(mercury, (short)20, new ItemStack((Block)IUItem.space_ore2, 1, 2));
        SpaceNet.instance.getColonieNet().addItemStack(venus, (short)15, new ItemStack((Block)IUItem.space_ore3, 1, 12));
        SpaceNet.instance.getColonieNet().addFluidStack(venus, (short)10, new FluidStack(FluidName.fluidhydrogensulfide.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addItemStack(mars, (short)15, new ItemStack((Block)IUItem.space_ore2, 1, 0));
        SpaceNet.instance.getColonieNet().addFluidStack(mars, (short)10, new FluidStack(FluidName.fluidazot.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addItemStack(mars, (short)25, new ItemStack((Block)IUItem.space_ore1, 1, 15));
        SpaceNet.instance.getColonieNet().addItemStack(ceres, (short)10, new ItemStack((Block)IUItem.space_ore, 1, 7));
        SpaceNet.instance.getColonieNet().addItemStack(ceres, (short)15, new ItemStack((Block)IUItem.space_ore, 1, 6));
        SpaceNet.instance.getColonieNet().addFluidStack(ceres, (short)20, new FluidStack(FluidName.fluidacetylene.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addItemStack(moon, (short)10, new ItemStack((Block)IUItem.space_ore2, 1, 7));
        SpaceNet.instance.getColonieNet().addItemStack(moon, (short)25, new ItemStack((Block)IUItem.space_ore2, 1, 6));
        SpaceNet.instance.getColonieNet().addFluidStack(moon, (short)17, new FluidStack(FluidName.fluidhyd.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addItemStack(deimos, (short)25, new ItemStack((Block)IUItem.space_ore, 1, 10));
        SpaceNet.instance.getColonieNet().addFluidStack(deimos, (short)15, new FluidStack(FluidName.fluidHelium.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addItemStack(phobos, (short)10, new ItemStack((Block)IUItem.space_ore2, 1, 10));
        SpaceNet.instance.getColonieNet().addItemStack(phobos, (short)15, new ItemStack((Block)IUItem.space_ore2, 1, 11));
        SpaceNet.instance.getColonieNet().addItemStack(io, (short)10, new ItemStack((Block)IUItem.space_ore1, 1, 10));
        SpaceNet.instance.getColonieNet().addItemStack(io, (short)15, new ItemStack((Block)IUItem.space_ore1, 1, 11));
        SpaceNet.instance.getColonieNet().addItemStack(callisto, (short)10, new ItemStack((Block)IUItem.space_ore, 1, 3));
        SpaceNet.instance.getColonieNet().addItemStack(callisto, (short)15, new ItemStack((Block)IUItem.space_ore, 1, 5));
        SpaceNet.instance.getColonieNet().addItemStack(callisto, (short)25, new ItemStack((Block)IUItem.space_ore, 1, 4));
        SpaceNet.instance.getColonieNet().addItemStack(ganymede, (short)10, new ItemStack((Block)IUItem.space_ore1, 1, 3));
        SpaceNet.instance.getColonieNet().addItemStack(ganymede, (short)25, new ItemStack((Block)IUItem.space_ore1, 1, 2));
        SpaceNet.instance.getColonieNet().addFluidStack(ganymede, (short)17, new FluidStack(FluidName.fluidcarbonmonoxide.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addItemStack(europe, (short)10, new ItemStack((Block)IUItem.space_ore1, 1, 4));
        SpaceNet.instance.getColonieNet().addItemStack(europe, (short)15, new ItemStack((Block)IUItem.space_ore1, 1, 1));
        SpaceNet.instance.getColonieNet().addItemStack(europe, (short)22, new ItemStack((Block)IUItem.space_ore1, 1, 0));
        SpaceNet.instance.getColonieNet().addItemStack(enceladus, (short)10, new ItemStack((Block)IUItem.space_ore, 1, 13));
        SpaceNet.instance.getColonieNet().addFluidStack(enceladus, (short)17, new FluidStack(FluidName.fluidacetylene.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addFluidStack(enceladus, (short)22, new FluidStack(FluidName.fluidHelium.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addItemStack(titan, (short)10, new ItemStack((Block)IUItem.space_ore3, 1, 5));
        SpaceNet.instance.getColonieNet().addItemStack(titan, (short)15, new ItemStack((Block)IUItem.space_ore3, 1, 6));
        SpaceNet.instance.getColonieNet().addItemStack(dione, (short)10, new ItemStack((Block)IUItem.space_ore, 1, 12));
        SpaceNet.instance.getColonieNet().addItemStack(dione, (short)15, new ItemStack((Block)IUItem.space_ore, 1, 11));
        SpaceNet.instance.getColonieNet().addFluidStack(dione, (short)22, new FluidStack(FluidName.fluidmethane.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addItemStack(mimas, (short)22, new ItemStack((Block)IUItem.space_ore2, 1, 3));
        SpaceNet.instance.getColonieNet().addFluidStack(mimas, (short)17, new FluidStack(FluidName.fluidpropane.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addFluidStack(mimas, (short)26, new FluidStack(FluidName.fluidbutene.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addItemStack(rhea, (short)10, new ItemStack((Block)IUItem.space_ore3, 1, 0));
        SpaceNet.instance.getColonieNet().addItemStack(rhea, (short)15, new ItemStack((Block)IUItem.space_ore3, 1, 1));
        SpaceNet.instance.getColonieNet().addItemStack(rhea, (short)20, new ItemStack((Block)IUItem.space_ore3, 1, 2));
        SpaceNet.instance.getColonieNet().addFluidStack(rhea, (short)25, new FluidStack(FluidName.fluidnitrogenhydride.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addItemStack(tethys, (short)15, new ItemStack((Block)IUItem.space_ore3, 1, 3));
        SpaceNet.instance.getColonieNet().addItemStack(tethys, (short)20, new ItemStack((Block)IUItem.space_ore3, 1, 4));
        SpaceNet.instance.getColonieNet().addFluidStack(tethys, (short)25, new FluidStack(FluidName.fluiddecane.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addItemStack(titania, (short)15, new ItemStack((Block)IUItem.space_ore3, 1, 7));
        SpaceNet.instance.getColonieNet().addItemStack(titania, (short)20, new ItemStack((Block)IUItem.space_ore3, 1, 8));
        SpaceNet.instance.getColonieNet().addFluidStack(titania, (short)25, new FluidStack(FluidName.fluidchlorum.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addItemStack(umbriel, (short)15, new ItemStack((Block)IUItem.space_ore3, 1, 11));
        SpaceNet.instance.getColonieNet().addFluidStack(umbriel, (short)10, new FluidStack(FluidName.fluidfluor.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addFluidStack(umbriel, (short)20, new FluidStack(FluidName.fluidHelium.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addFluidStack(umbriel, (short)25, new FluidStack(FluidName.fluidmethane.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addItemStack(oberon, (short)15, new ItemStack((Block)IUItem.space_ore2, 1, 8));
        SpaceNet.instance.getColonieNet().addItemStack(oberon, (short)20, new ItemStack((Block)IUItem.space_ore2, 1, 9));
        SpaceNet.instance.getColonieNet().addFluidStack(oberon, (short)25, new FluidStack(FluidName.fluidethane.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addItemStack(ariel, (short)22, new ItemStack((Block)IUItem.space_ore, 1, 0));
        SpaceNet.instance.getColonieNet().addFluidStack(ariel, (short)16, new FluidStack(FluidName.fluidbromine.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addFluidStack(ariel, (short)26, new FluidStack(FluidName.fluidethylene.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addItemStack(miranda, (short)10, new ItemStack((Block)IUItem.space_ore2, 1, 4));
        SpaceNet.instance.getColonieNet().addItemStack(miranda, (short)20, new ItemStack((Block)IUItem.space_ore2, 1, 5));
        SpaceNet.instance.getColonieNet().addFluidStack(miranda, (short)15, new FluidStack(FluidName.fluidsulfurtrioxide.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addFluidStack(miranda, (short)25, new FluidStack(FluidName.fluidnitrogenoxy.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addItemStack(triton, (short)10, new ItemStack((Block)IUItem.space_ore3, 1, 9));
        SpaceNet.instance.getColonieNet().addItemStack(triton, (short)15, new ItemStack((Block)IUItem.space_ore3, 1, 10));
        SpaceNet.instance.getColonieNet().addFluidStack(triton, (short)20, new FluidStack(FluidName.fluidiodine.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addItemStack(proteus, (short)10, new ItemStack((Block)IUItem.space_ore2, 1, 14));
        SpaceNet.instance.getColonieNet().addItemStack(proteus, (short)15, new ItemStack((Block)IUItem.space_ore2, 1, 15));
        SpaceNet.instance.getColonieNet().addFluidStack(proteus, (short)25, new FluidStack(FluidName.fluidxenon.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addItemStack(pluto, (short)10, new ItemStack((Block)IUItem.space_ore2, 1, 13));
        SpaceNet.instance.getColonieNet().addItemStack(pluto, (short)22, new ItemStack((Block)IUItem.space_ore2, 1, 12));
        SpaceNet.instance.getColonieNet().addFluidStack(pluto, (short)16, new FluidStack(FluidName.fluidnitricacid.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addItemStack(charon, (short)10, new ItemStack((Block)IUItem.space_ore, 1, 9));
        SpaceNet.instance.getColonieNet().addItemStack(charon, (short)20, new ItemStack((Block)IUItem.space_ore, 1, 8));
        SpaceNet.instance.getColonieNet().addFluidStack(charon, (short)15, new FluidStack(FluidName.fluidethylene.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addFluidStack(charon, (short)25, new FluidStack(FluidName.fluidpropylene.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addItemStack(eris, (short)10, new ItemStack((Block)IUItem.space_ore, 1, 14));
        SpaceNet.instance.getColonieNet().addItemStack(eris, (short)20, new ItemStack((Block)IUItem.space_ore, 1, 15));
        SpaceNet.instance.getColonieNet().addFluidStack(eris, (short)25, new FluidStack(FluidName.fluidchlorum.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addFluidStack(eris, (short)15, new FluidStack(FluidName.fluidfluor.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addFluidStack(eris, (short)30, new FluidStack(FluidName.fluidbromine.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addFluidStack(eris, (short)35, new FluidStack(FluidName.fluidiodine.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addItemStack(makemake, (short)25, new ItemStack((Block)IUItem.space_ore1, 1, 12));
        SpaceNet.instance.getColonieNet().addItemStack(makemake, (short)10, new ItemStack((Block)IUItem.space_ore1, 1, 13));
        SpaceNet.instance.getColonieNet().addItemStack(makemake, (short)15, new ItemStack((Block)IUItem.space_ore1, 1, 14));
        SpaceNet.instance.getColonieNet().addFluidStack(makemake, (short)20, new FluidStack(FluidName.fluidsulfuricacid.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addFluidStack(makemake, (short)35, new FluidStack(FluidName.fluiddecane.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addItemStack(haumea, (short)25, new ItemStack((Block)IUItem.space_ore1, 1, 5));
        SpaceNet.instance.getColonieNet().addItemStack(haumea, (short)30, new ItemStack((Block)IUItem.space_ore1, 1, 6));
        SpaceNet.instance.getColonieNet().addItemStack(haumea, (short)15, new ItemStack((Block)IUItem.space_ore1, 1, 7));
        SpaceNet.instance.getColonieNet().addItemStack(haumea, (short)20, new ItemStack((Block)IUItem.space_ore1, 1, 8));
        SpaceNet.instance.getColonieNet().addItemStack(haumea, (short)10, new ItemStack((Block)IUItem.space_ore1, 1, 9));
        SpaceNet.instance.getColonieNet().addFluidStack(haumea, (short)35, new FluidStack(FluidName.fluiddecane.getInstance(), 1));
        SpaceNet.instance.getColonieNet().addFluidStack(haumea, (short)50, new FluidStack(FluidName.fluidxenon.getInstance(), 1));
    }

    public static ResourceLocation getTexture(String name) {
        return new ResourceLocation("industrialupgrade", "textures/planet/" + name + ".png");
    }
}

