/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.colonies;

import com.denfop.api.space.IBody;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.colonies.Colony;
import com.denfop.api.space.colonies.DataItem;
import com.denfop.api.space.colonies.Sends;
import com.denfop.api.space.colonies.api.IBuildingItem;
import com.denfop.api.space.colonies.api.IColony;
import com.denfop.api.space.colonies.api.IColonyBuilding;
import com.denfop.api.space.colonies.api.IColonyNet;
import com.denfop.api.space.colonies.api.building.IStorage;
import com.denfop.api.space.colonies.building.ColonyHouse;
import com.denfop.api.space.colonies.building.ColonyPanelFactory;
import com.denfop.api.space.colonies.building.Factory;
import com.denfop.api.space.colonies.building.OxygenFactory;
import com.denfop.api.space.colonies.building.ProtectionBuilding;
import com.denfop.api.space.colonies.enums.EnumHousesLevel;
import com.denfop.api.space.colonies.enums.EnumProtectionLevel;
import com.denfop.api.space.colonies.enums.EnumTypeFactory;
import com.denfop.api.space.colonies.enums.EnumTypeSolarPanel;
import com.denfop.api.space.fakebody.Data;
import com.denfop.network.packet.PacketSuccessUpdateColony;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;

public class ColonyNet
implements IColonyNet {
    Map<UUID, List<IColony>> fakePlayerListMap;
    List<IColony> colonyList;
    List<UUID> fakePlayerList;
    Map<IBody, List<DataItem<ItemStack>>> bodyItemStackList = new HashMap<IBody, List<DataItem<ItemStack>>>();
    Map<IBody, List<DataItem<FluidStack>>> bodyFluidStackList = new HashMap<IBody, List<DataItem<FluidStack>>>();
    Map<UUID, List<Sends>> sends = new HashMap<UUID, List<Sends>>();
    List<IColony> deleteList = new LinkedList<IColony>();

    public ColonyNet() {
        this.fakePlayerListMap = new HashMap<UUID, List<IColony>>();
        this.colonyList = new LinkedList<IColony>();
        this.fakePlayerList = new LinkedList<UUID>();
    }

    @Override
    public Map<UUID, List<IColony>> getMap() {
        return this.fakePlayerListMap;
    }

    @Override
    public boolean canAddColony(IBody body, EntityPlayer player) {
        Data data = SpaceNet.instance.getFakeSpaceSystem().getDataFromUUID(player.func_110124_au()).get(body);
        if (data == null) {
            return false;
        }
        IColonyBuilding houses = this.hasItemInInventory(player, ColonyHouse.class, 3);
        if (houses == null) {
            return false;
        }
        if (((ColonyHouse)houses).getLevel() != EnumHousesLevel.LOW) {
            return false;
        }
        IColonyBuilding oxygen = this.hasItemInInventory(player, OxygenFactory.class, 1);
        if (oxygen == null) {
            return false;
        }
        IColonyBuilding factory = this.hasItemInInventory(player, Factory.class, 2);
        if (factory == null) {
            return false;
        }
        if (((Factory)factory).getType() != EnumTypeFactory.LOW) {
            return false;
        }
        IColonyBuilding protection = this.hasItemInInventory(player, ProtectionBuilding.class, 1);
        if (protection == null) {
            return false;
        }
        if (((ProtectionBuilding)protection).getProtectionBuilding() != EnumProtectionLevel.LOW) {
            return false;
        }
        IColonyBuilding panel = this.hasItemInInventory(player, ColonyPanelFactory.class, 1);
        if (panel == null) {
            return false;
        }
        if (((ColonyPanelFactory)panel).getType() != EnumTypeSolarPanel.LOW) {
            return false;
        }
        List<IColony> list = this.fakePlayerListMap.get(player.func_110124_au());
        if (list == null) {
            return true;
        }
        for (IColony colony : list) {
            if (!colony.matched(body)) continue;
            return false;
        }
        return true;
    }

    private IColonyBuilding hasItemInInventory(EntityPlayer player, Class<?> colonyClass, int count) {
        NonNullList mainInventory = player.field_71071_by.field_70462_a;
        for (ItemStack stack : mainInventory) {
            IBuildingItem buildingItem;
            IColonyBuilding building;
            if (!(stack.func_77973_b() instanceof IBuildingItem) || stack.func_190916_E() < count || !colonyClass.isInstance(building = (buildingItem = (IBuildingItem)stack.func_77973_b()).getBuilding(null, stack, true))) continue;
            return building;
        }
        return null;
    }

    private void consumeItemInInventory(EntityPlayer player, Class<?> colonyClass, int count, Colony colony) {
        NonNullList mainInventory = player.field_71071_by.field_70462_a;
        for (ItemStack stack : mainInventory) {
            IBuildingItem buildingItem;
            IColonyBuilding building;
            if (!(stack.func_77973_b() instanceof IBuildingItem) || stack.func_190916_E() < count || !colonyClass.isInstance(building = (buildingItem = (IBuildingItem)stack.func_77973_b()).getBuilding(colony, stack, true))) continue;
            for (int i = 0; i < count; ++i) {
                buildingItem.getBuilding(colony, stack, false);
            }
            stack.func_190918_g(count);
        }
    }

    @Override
    public void addItemToColony(IBody body, EntityPlayer player) {
        List<IColony> list = this.fakePlayerListMap.get(player.func_110124_au());
        if (list == null) {
            return;
        }
        for (IColony colony : list) {
            if (!colony.matched(body)) continue;
            ItemStack stack = player.field_71071_by.func_70445_o();
            if (!(stack.func_77973_b() instanceof IBuildingItem)) break;
            IBuildingItem buildingItem = (IBuildingItem)stack.func_77973_b();
            IColonyBuilding building = buildingItem.getBuilding(colony, stack, true);
            if (colony.getLevel() < building.getMinLevelColony() || colony.getAvailableBuilding() <= 0) break;
            buildingItem.getBuilding(colony, stack, false);
            stack.func_190918_g(1);
            new PacketSuccessUpdateColony(player);
            break;
        }
    }

    @Override
    public void addColony(IBody body, EntityPlayer player) {
        if (this.canAddColony(body, player)) {
            Colony colony = new Colony(body, player.func_110124_au());
            this.consumeItemInInventory(player, ColonyHouse.class, 3, colony);
            this.consumeItemInInventory(player, Factory.class, 2, colony);
            this.consumeItemInInventory(player, OxygenFactory.class, 1, colony);
            this.consumeItemInInventory(player, ProtectionBuilding.class, 1, colony);
            this.consumeItemInInventory(player, ColonyPanelFactory.class, 1, colony);
            List colonyList = this.fakePlayerListMap.computeIfAbsent(player.func_110124_au(), l -> new LinkedList());
            if (colonyList.isEmpty()) {
                this.fakePlayerList.add(player.func_110124_au());
            }
            colonyList.add(colony);
            this.colonyList.add(colony);
        }
    }

    @Override
    public void removeColony(IColony colony, UUID player) {
        List<IColony> colonyList = this.fakePlayerListMap.get(player);
        colonyList.remove(colony);
        this.colonyList.remove(colony);
    }

    @Override
    public void removeColony(IBody body, UUID player) {
        List<IColony> colonyList = this.fakePlayerListMap.get(player);
        IColony colony = null;
        for (IColony colony1 : colonyList) {
            if (colony1.getBody() != body) continue;
            colony = colony1;
        }
        colonyList.remove(colony);
        this.colonyList.remove(colony);
    }

    @Override
    public List<Sends> getSendsFromUUID(UUID uuid) {
        return this.sends.getOrDefault(uuid, Collections.emptyList());
    }

    @Override
    public void working() {
        for (Map.Entry<UUID, List<Sends>> uuidListEntry : this.sends.entrySet()) {
            Iterator<Sends> iter = uuidListEntry.getValue().iterator();
            while (iter.hasNext()) {
                Sends sends = iter.next();
                sends.works();
                if (!sends.needRemove()) continue;
                iter.remove();
            }
        }
        for (IColony colony : this.colonyList) {
            colony.update();
            if (colony.getTimeToDelete() > 0) continue;
            this.deleteList.add(colony);
        }
        for (IColony colony : this.deleteList) {
            this.removeColony(colony, colony.getFakePlayer());
        }
        this.deleteList.clear();
    }

    @Override
    public List<IColony> getColonies() {
        return this.colonyList;
    }

    @Override
    public void addFluidStack(IBody body, short level, FluidStack fluidStack) {
        List list = this.bodyFluidStackList.computeIfAbsent(body, k -> new ArrayList());
        list.add(new DataItem<FluidStack>(level, fluidStack));
    }

    @Override
    public void addItemStack(IBody body, short level, ItemStack fluidStack) {
        List list = this.bodyItemStackList.computeIfAbsent(body, k -> new ArrayList());
        list.add(new DataItem<ItemStack>(level, fluidStack));
    }

    @Override
    public List<DataItem<FluidStack>> getFluidsFromBody(IBody body) {
        return this.bodyFluidStackList.getOrDefault(body, Collections.emptyList());
    }

    @Override
    public List<DataItem<ItemStack>> getItemsFromBody(IBody body) {
        return this.bodyItemStackList.getOrDefault(body, Collections.emptyList());
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound tag, UUID player) {
        List list = this.fakePlayerListMap.getOrDefault(player, Collections.emptyList());
        NBTTagList nbt = new NBTTagList();
        tag.func_186854_a("player", player);
        for (IColony colonies : list) {
            nbt.func_74742_a((NBTBase)colonies.writeNBT(new NBTTagCompound()));
        }
        NBTTagList nbt1 = new NBTTagList();
        for (Sends sends1 : this.sends.getOrDefault(player, Collections.emptyList())) {
            nbt1.func_74742_a((NBTBase)sends1.writeToNbt());
        }
        tag.func_74782_a("sends", (NBTBase)nbt1);
        tag.func_74782_a("colonial", (NBTBase)nbt);
        return tag;
    }

    @Override
    public void addColony(NBTTagCompound tag) {
        NBTTagCompound nbt2;
        int i;
        NBTTagList nbt = tag.func_150295_c("colonial", 10);
        NBTTagList nbt1 = tag.func_150295_c("sends", 10);
        UUID player = tag.func_186857_a("player");
        if (this.fakePlayerList.contains(player)) {
            return;
        }
        this.fakePlayerList.add(player);
        LinkedList<Colony> list = new LinkedList<Colony>();
        LinkedList<Sends> list1 = new LinkedList<Sends>();
        for (i = 0; i < nbt1.func_74745_c(); ++i) {
            nbt2 = nbt1.func_150305_b(i);
            Sends sends1 = new Sends(nbt2);
            list1.add(sends1);
        }
        for (i = 0; i < nbt.func_74745_c(); ++i) {
            nbt2 = nbt.func_150305_b(i);
            Colony colonies = new Colony(nbt2, player);
            list.add(colonies);
            this.colonyList.add(colonies);
        }
        this.sends.put(player, list1);
        this.fakePlayerListMap.put(player, new ArrayList(list));
    }

    @Override
    public List<UUID> getList() {
        return this.fakePlayerList;
    }

    @Override
    public void unload() {
        this.fakePlayerListMap.clear();
        this.colonyList.clear();
        this.fakePlayerList.clear();
        this.sends.clear();
    }

    @Override
    public void sendResourceToPlanet(UUID uniqueID, IBody body1) {
        List<IColony> colonies = this.fakePlayerListMap.get(uniqueID);
        if (colonies != null) {
            for (IColony colony : colonies) {
                if (!colony.matched(body1)) continue;
                Sends sends1 = new Sends(uniqueID, body1, colony);
                List<IStorage> storages = colony.getStorageList();
                for (IStorage storage : storages) {
                    for (ItemStack stack : storage.getStacks()) {
                        if (sends1.stacks.size() == 27) break;
                        if (stack == null || stack.func_190926_b()) continue;
                        sends1.addStack(stack.func_77946_l());
                    }
                    for (FluidStack fluidStack : storage.getFluidStacks()) {
                        if (sends1.fluidStacks.size() == 9) break;
                        if (fluidStack == null) continue;
                        sends1.addStack(fluidStack.copy());
                    }
                    storage.getStacks().clear();
                    storage.getFluidStacks().clear();
                }
                if (sends1.stacks.isEmpty() && sends1.fluidStacks.isEmpty()) break;
                List list = this.sends.computeIfAbsent(uniqueID, k -> new LinkedList());
                list.add(sends1);
                break;
            }
        }
    }

    @Override
    public void setAutoSends(UUID uniqueID, IBody body1) {
        List<IColony> colonies = this.fakePlayerListMap.get(uniqueID);
        if (colonies != null) {
            for (IColony colony : colonies) {
                if (!colony.matched(body1)) continue;
                colony.setAuto(!colony.isAuto());
                break;
            }
        }
    }
}

