/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.colonies;

import com.denfop.api.space.IAsteroid;
import com.denfop.api.space.IBody;
import com.denfop.api.space.IPlanet;
import com.denfop.api.space.ISatellite;
import com.denfop.api.space.SpaceInit;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.colonies.api.IColony;
import com.denfop.api.space.research.api.IRocketLaunchPad;
import com.denfop.utils.Timer;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;

public class Sends {
    private final UUID uuid;
    private final Timer timerToPlanet;
    private final IBody body;
    List<ItemStack> stacks = new LinkedList<ItemStack>();
    List<FluidStack> fluidStacks = new LinkedList<FluidStack>();

    public Sends(UUID uuid, IBody body, IColony colony) {
        this.uuid = uuid;
        int seconds = 0;
        this.body = body;
        if (body instanceof IPlanet) {
            seconds = (int)(Math.abs(body.getDistance() - SpaceInit.earth.getDistance()) / (SpaceInit.mars.getDistance() - SpaceInit.earth.getDistance()) * 799.6800000000001);
        } else if (body instanceof ISatellite) {
            double distancePlanetToPlanet = (((ISatellite)body).getPlanet().getDistance() - SpaceInit.earth.getDistance()) / (SpaceInit.mars.getDistance() - SpaceInit.earth.getDistance());
            double distanceSatellite = Math.abs(SpaceInit.moon.getDistanceFromPlanet() - ((ISatellite)body).getDistanceFromPlanet()) / SpaceInit.moon.getDistanceFromPlanet();
            if (((ISatellite)body).getPlanet() == SpaceInit.earth) {
                distanceSatellite = 1.0;
            }
            seconds = (int)Math.abs(distanceSatellite * 5.0 * 60.0 * 0.8 + distancePlanetToPlanet * 799.6800000000001);
        } else {
            seconds = (int)(Math.abs((((IAsteroid)body).getMaxDistance() - ((IAsteroid)body).getMinDistance()) / 2.0 + ((IAsteroid)body).getMinDistance() - SpaceInit.earth.getDistance()) / (SpaceInit.mars.getDistance() - SpaceInit.earth.getDistance()) * 799.6800000000001);
        }
        int dop = colony.getLevel() / 10;
        this.timerToPlanet = new Timer(seconds / (4 + dop));
    }

    public IBody getBody() {
        return this.body;
    }

    public Sends(NBTTagCompound tagCompound) {
        this.uuid = tagCompound.func_186857_a("uuid");
        this.body = SpaceNet.instance.getBodyFromName(tagCompound.func_74779_i("body"));
        this.timerToPlanet = new Timer(tagCompound.func_74775_l("time"));
        NBTTagList nbtTagList = tagCompound.func_150295_c("items", 10);
        this.stacks.clear();
        for (int i = 0; i < nbtTagList.func_74745_c(); ++i) {
            this.stacks.add(new ItemStack(nbtTagList.func_150305_b(i)));
        }
        NBTTagList nbtTagList1 = tagCompound.func_150295_c("fluids", 10);
        this.fluidStacks.clear();
        for (int i = 0; i < nbtTagList1.func_74745_c(); ++i) {
            this.fluidStacks.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtTagList1.func_150305_b(i)));
        }
    }

    public NBTTagCompound writeToNbt() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_186854_a("uuid", this.uuid);
        tagCompound.func_74778_a("body", this.body.getName());
        tagCompound.func_74782_a("time", (NBTBase)this.timerToPlanet.writeNBT(new NBTTagCompound()));
        NBTTagList nbtTagList = new NBTTagList();
        for (ItemStack stack : this.stacks) {
            nbtTagList.func_74742_a((NBTBase)stack.serializeNBT());
        }
        tagCompound.func_74782_a("items", (NBTBase)nbtTagList);
        NBTTagList nbtTagList1 = new NBTTagList();
        for (FluidStack fluidStack : this.fluidStacks) {
            nbtTagList1.func_74742_a((NBTBase)fluidStack.writeToNBT(new NBTTagCompound()));
        }
        tagCompound.func_74782_a("fluids", (NBTBase)nbtTagList1);
        return tagCompound;
    }

    public Timer getTimerToPlanet() {
        return this.timerToPlanet;
    }

    public boolean needRemove() {
        return !this.timerToPlanet.canWork();
    }

    public void works() {
        this.timerToPlanet.work();
        if (!this.timerToPlanet.canWork()) {
            IRocketLaunchPad spacePad = SpaceNet.instance.getFakeSpaceSystem().getRocketPadMap().get(this.uuid);
            if (spacePad != null) {
                for (ItemStack stack : this.stacks) {
                    spacePad.getSlotOutput().add(stack);
                }
                for (FluidStack fluidStack : this.fluidStacks) {
                    spacePad.addFluidStack(fluidStack);
                }
            } else {
                this.timerToPlanet.setCanWork(true);
            }
        }
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void addStack(FluidStack fluidStack) {
        this.fluidStacks.add(fluidStack);
    }

    public void addStack(ItemStack itemStack) {
        this.stacks.add(itemStack);
    }
}

