/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.colonies.building;

import com.denfop.api.space.colonies.Building;
import com.denfop.api.space.colonies.Colony;
import com.denfop.api.space.colonies.api.IColony;
import com.denfop.api.space.colonies.api.building.IColonyPanelFactory;
import com.denfop.api.space.colonies.enums.EnumTypeBuilding;
import com.denfop.api.space.colonies.enums.EnumTypeSolarPanel;
import com.denfop.network.packet.CustomPacketBuffer;
import net.minecraft.nbt.NBTTagCompound;

public class ColonyPanelFactory
extends Building
implements IColonyPanelFactory {
    private final EnumTypeSolarPanel type;
    private byte people;

    public ColonyPanelFactory(IColony colonie, EnumTypeSolarPanel type, boolean simulate) {
        super(colonie);
        this.type = type;
        this.people = 0;
        if (!simulate) {
            this.getColony().addMaxEnergy(5000 * type.getGeneration());
            this.getColony().addBuilding(this);
        }
    }

    public ColonyPanelFactory(NBTTagCompound tag, IColony colonie) {
        super(colonie);
        this.type = EnumTypeSolarPanel.getID(tag.func_74771_c("id"));
        this.people = tag.func_74771_c("people");
        this.getColony().addMaxEnergy(5000 * this.type.getGeneration());
        this.getColony().addBuilding(this);
    }

    public ColonyPanelFactory(CustomPacketBuffer packetBuffer, Colony colonie) {
        super(colonie);
        this.type = EnumTypeSolarPanel.getID(packetBuffer.readByte());
        this.people = packetBuffer.readByte();
        this.getColony().addMaxEnergy(5000 * this.type.getGeneration());
        this.getColony().addBuilding(this);
    }

    @Override
    public byte getId() {
        return 1;
    }

    @Override
    public int getEnergy() {
        return this.type.getGeneration();
    }

    @Override
    public int getPeople() {
        return this.people;
    }

    @Override
    public int needWorkers() {
        return this.type.getPeople() - this.people;
    }

    @Override
    public void addWorkers(int workers) {
        this.people = (byte)(this.people + workers);
    }

    @Override
    public void removeWorkers(int remove) {
        this.people = (byte)(this.people - remove);
    }

    @Override
    public int getWorkers() {
        return this.people;
    }

    @Override
    public EnumTypeSolarPanel getType() {
        return this.type;
    }

    @Override
    public void work() {
        if (this.getColony().getEnergy() < this.getColony().getMaxEnergy()) {
            int temp = Math.min(this.getEnergy(), this.getColony().getMaxEnergy() - this.getColony().getEnergy());
            this.getColony().addEnergy(temp);
        }
    }

    @Override
    public EnumTypeBuilding getTypeBuilding() {
        return EnumTypeBuilding.GENERATORS;
    }

    @Override
    public CustomPacketBuffer writePacket(CustomPacketBuffer customPacketBuffer) {
        super.writePacket(customPacketBuffer);
        customPacketBuffer.writeByte((byte)this.getType().ordinal());
        customPacketBuffer.writeByte(this.people);
        return customPacketBuffer;
    }

    @Override
    public NBTTagCompound writeTag(NBTTagCompound tag) {
        super.writeTag(tag);
        tag.func_74774_a("people", this.people);
        tag.func_74774_a("id", (byte)this.getType().ordinal());
        return tag;
    }

    @Override
    public int getMinLevelColony() {
        return this.type.getLevel();
    }
}

