/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.colonies.building;

import com.denfop.api.space.colonies.Building;
import com.denfop.api.space.colonies.Colony;
import com.denfop.api.space.colonies.api.IColony;
import com.denfop.api.space.colonies.api.building.IFactory;
import com.denfop.api.space.colonies.enums.EnumProblems;
import com.denfop.api.space.colonies.enums.EnumTypeBuilding;
import com.denfop.api.space.colonies.enums.EnumTypeFactory;
import com.denfop.network.packet.CustomPacketBuffer;
import net.minecraft.nbt.NBTTagCompound;

public class Factory
extends Building
implements IFactory {
    public final EnumTypeFactory typeFactory;
    byte people;

    public Factory(IColony colonie, EnumTypeFactory typeFactory, boolean simulate) {
        super(colonie);
        this.typeFactory = typeFactory;
        if (!simulate) {
            this.getColony().addBuilding(this);
        }
    }

    public Factory(CustomPacketBuffer packetBuffer, Colony colonie) {
        super(colonie);
        byte id = packetBuffer.readByte();
        this.typeFactory = EnumTypeFactory.getID(id);
        this.people = packetBuffer.readByte();
        this.getColony().addBuilding(this);
    }

    public Factory(NBTTagCompound tag, IColony colonie) {
        super(colonie);
        byte id = tag.func_74771_c("id");
        this.typeFactory = EnumTypeFactory.getID(id);
        this.people = tag.func_74771_c("people");
        this.getColony().addBuilding(this);
    }

    @Override
    public CustomPacketBuffer writePacket(CustomPacketBuffer customPacketBuffer) {
        super.writePacket(customPacketBuffer);
        customPacketBuffer.writeByte(this.typeFactory.ordinal());
        customPacketBuffer.writeByte(this.people);
        return customPacketBuffer;
    }

    @Override
    public byte getId() {
        return 2;
    }

    @Override
    public NBTTagCompound writeTag(NBTTagCompound tag) {
        super.writeTag(tag);
        tag.func_74774_a("id", (byte)this.getType().ordinal());
        tag.func_74774_a("people", this.people);
        return tag;
    }

    @Override
    public int getMinLevelColony() {
        return this.getType().getLevel();
    }

    @Override
    public void work() {
        if (this.getColony().getEnergy() >= this.typeFactory.getEnergy()) {
            this.getColony().useEnergy(this.typeFactory.getEnergy());
            this.getColony().addFood((int)((double)(this.people * 2) * this.getColony().getPercentEntertainment()));
        } else if (!this.getColony().getProblems().contains((Object)EnumProblems.ENERGY)) {
            this.getColony().getProblems().add(EnumProblems.ENERGY);
        }
    }

    @Override
    public EnumTypeBuilding getTypeBuilding() {
        return EnumTypeBuilding.FABRIC;
    }

    @Override
    public int getPeople() {
        return this.people;
    }

    @Override
    public int getWorkers() {
        return this.people;
    }

    @Override
    public int getEnergy() {
        return this.getType().getEnergy();
    }

    @Override
    public EnumTypeFactory getType() {
        return this.typeFactory;
    }

    @Override
    public int needWorkers() {
        return this.typeFactory.getPeople() - this.people;
    }

    @Override
    public void addWorkers(int workers) {
        this.people = (byte)(this.people + workers);
    }

    @Override
    public void removeWorkers(int remove) {
        this.people = (byte)(this.people - remove);
    }
}

