/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.colonies.building;

import com.denfop.api.space.colonies.api.building.IStorage;
import com.denfop.api.space.colonies.building.StorageBuilding;
import com.denfop.network.packet.CustomPacketBuffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class Storage
implements IStorage {
    private final StorageBuilding storageBuilding;
    private final int maxvaluefluid;
    List<ItemStack> itemStackList;
    List<FluidStack> fluidStackList;
    private int max;
    private int fluidmax;

    public Storage(StorageBuilding storageBuilding) {
        this.itemStackList = new LinkedList<ItemStack>();
        this.fluidStackList = new LinkedList<FluidStack>();
        this.max = 5;
        this.fluidmax = 10;
        this.maxvaluefluid = 10000;
        this.storageBuilding = storageBuilding;
    }

    public Storage(NBTTagCompound tag, StorageBuilding storageBuilding) {
        this.maxvaluefluid = 10000;
        this.storageBuilding = storageBuilding;
        this.readNBT(tag);
    }

    public Storage(CustomPacketBuffer packetBuffer, StorageBuilding storageBuilding) {
        this.maxvaluefluid = 10000;
        this.storageBuilding = storageBuilding;
        this.readPacket(packetBuffer);
    }

    @Override
    public StorageBuilding getStorageBuilding() {
        return this.storageBuilding;
    }

    @Override
    public List<ItemStack> getStacks() {
        return this.itemStackList;
    }

    @Override
    public List<FluidStack> getFluidStacks() {
        return this.fluidStackList;
    }

    @Override
    public int getMaxStorage() {
        return this.max;
    }

    @Override
    public int getMaxStorageForFluid() {
        return this.fluidmax;
    }

    @Override
    public void addMaxStorage(int storage) {
        this.max += storage;
    }

    @Override
    public void addMaxStorageForFluid(int storage) {
        this.fluidmax += storage;
    }

    @Override
    public boolean canAddFluidStack(FluidStack fluidStack) {
        if (!this.getStorageBuilding().getWork()) {
            return false;
        }
        if (fluidStack == null) {
            return false;
        }
        List<FluidStack> fluidStacks = this.getFluidStacks();
        boolean added = false;
        fluidStacks.removeIf(Objects::isNull);
        for (FluidStack stack : fluidStacks) {
            if (!stack.isFluidEqual(fluidStack)) continue;
            if (stack.amount + fluidStack.amount <= this.maxvaluefluid) {
                stack.amount += fluidStack.amount;
                return true;
            }
            if (stack.amount >= this.maxvaluefluid) continue;
            int amount = this.maxvaluefluid - stack.amount;
            stack.amount += amount;
            fluidStack.amount -= amount;
            added = true;
        }
        if (added && fluidStack.amount > 0 && this.getFluidStacks().size() < this.fluidmax) {
            fluidStacks.add(fluidStack);
            return true;
        }
        if (this.getFluidStacks().size() >= this.fluidmax) {
            return false;
        }
        this.getFluidStacks().add(fluidStack);
        return true;
    }

    @Override
    public boolean canRemoveFluidStack(FluidStack fluidStack) {
        if (!this.getStorageBuilding().getWork()) {
            return false;
        }
        List<FluidStack> fluidStacks = this.getFluidStacks();
        for (FluidStack stack : fluidStacks) {
            if (!stack.isFluidEqual(fluidStack) || stack.amount - fluidStack.amount < 0) continue;
            stack.amount -= fluidStack.amount;
            return true;
        }
        return false;
    }

    @Override
    public boolean canAddItemStack(ItemStack itemStack) {
        if (!this.getStorageBuilding().getWork()) {
            return false;
        }
        List<ItemStack> stackList = this.getStacks();
        int size = itemStack.func_190916_E();
        boolean added = false;
        for (ItemStack stack : stackList) {
            if (!stack.func_77969_a(itemStack)) continue;
            if (stack.func_190916_E() + size <= stack.func_77976_d()) {
                stack.func_190917_f(size);
                return true;
            }
            if (stack.func_190916_E() >= stack.func_77976_d()) continue;
            int amount = stack.func_77976_d() - stack.func_190916_E();
            stack.func_190917_f(amount);
            itemStack.func_190918_g(amount);
            size = itemStack.func_190916_E();
            added = true;
        }
        if (added && itemStack.func_190916_E() > 0 && this.getStacks().size() < this.max) {
            this.itemStackList.add(itemStack);
            return true;
        }
        if (this.getStacks().size() >= this.max) {
            return false;
        }
        this.getStacks().add(itemStack);
        return true;
    }

    @Override
    public boolean canRemoveItemStack(ItemStack itemStack) {
        if (!this.getStorageBuilding().getWork()) {
            return false;
        }
        List<ItemStack> itemStackList = this.getStacks();
        for (ItemStack stack : itemStackList) {
            if (!stack.func_77969_a(itemStack) || stack.func_190916_E() - itemStack.func_190916_E() < 0) continue;
            stack.func_190918_g(itemStack.func_190916_E());
            return true;
        }
        return false;
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound tag) {
        tag.func_74768_a("max", this.max);
        tag.func_74768_a("fluidmax", this.fluidmax);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("col", this.getStacks().size());
        for (int i = 0; i < this.getStacks().size(); ++i) {
            nbt.func_74782_a(String.valueOf(i), (NBTBase)this.getStacks().get(i).func_77955_b(new NBTTagCompound()));
        }
        tag.func_74782_a("stacks", (NBTBase)nbt);
        NBTTagCompound nbt1 = new NBTTagCompound();
        nbt1.func_74768_a("col_fluid", this.getFluidStacks().size());
        for (int i = 0; i < this.getFluidStacks().size(); ++i) {
            if (this.fluidStackList.get(i) == null) continue;
            nbt1.func_74782_a(String.valueOf(i), (NBTBase)this.getFluidStacks().get(i).writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("fluids", (NBTBase)nbt1);
        return tag;
    }

    public void readPacket(CustomPacketBuffer tag) {
        this.max = tag.readInt();
        this.fluidmax = tag.readInt();
        try {
            NBTTagCompound nbt = tag.func_150793_b();
            assert (nbt != null);
            int size = nbt.func_74762_e("col");
            this.itemStackList = new ArrayList<ItemStack>();
            for (int i = 0; i < size; ++i) {
                this.itemStackList.add(new ItemStack(nbt.func_74775_l(String.valueOf(i))));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            NBTTagCompound nbt1 = tag.func_150793_b();
            assert (nbt1 != null);
            int size = nbt1.func_74762_e("col_fluid");
            this.fluidStackList = new ArrayList<FluidStack>();
            for (int i = 0; i < size; ++i) {
                this.fluidStackList.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt1.func_74775_l(String.valueOf(i))));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void readNBT(NBTTagCompound tag) {
        this.max = tag.func_74762_e("max");
        this.fluidmax = tag.func_74762_e("fluidmax");
        NBTTagCompound nbt = tag.func_74775_l("stacks");
        int size = nbt.func_74762_e("col");
        this.itemStackList = new ArrayList<ItemStack>();
        for (int i = 0; i < size; ++i) {
            this.itemStackList.add(new ItemStack(nbt.func_74775_l(String.valueOf(i))));
        }
        NBTTagCompound nbt1 = tag.func_74775_l("fluids");
        size = nbt1.func_74762_e("col_fluid");
        this.fluidStackList = new ArrayList<FluidStack>();
        for (int i = 0; i < size; ++i) {
            this.fluidStackList.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt1.func_74775_l(String.valueOf(i))));
        }
    }

    @Override
    public boolean work() {
        return this.storageBuilding.work;
    }

    @Override
    public void writePacket(CustomPacketBuffer customPacketBuffer) {
        customPacketBuffer.writeInt(this.max);
        customPacketBuffer.writeInt(this.fluidmax);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("col", this.getStacks().size());
        for (int i = 0; i < this.getStacks().size(); ++i) {
            nbt.func_74782_a(String.valueOf(i), (NBTBase)this.getStacks().get(i).func_77955_b(new NBTTagCompound()));
        }
        customPacketBuffer.func_150786_a(nbt);
        NBTTagCompound nbt1 = new NBTTagCompound();
        nbt1.func_74768_a("col_fluid", this.getStacks().size());
        for (int i = 0; i < this.getFluidStacks().size(); ++i) {
            if (this.getFluidStacks().get(i) == null) continue;
            nbt1.func_74782_a(String.valueOf(i), (NBTBase)this.getFluidStacks().get(i).writeToNBT(new NBTTagCompound()));
        }
        customPacketBuffer.func_150786_a(nbt1);
    }
}

