/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.fakebody;

import com.denfop.api.space.IBody;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.fakebody.IData;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;

public class Data
implements IData {
    private final UUID player;
    private final IBody body;
    private double percent;

    public Data(UUID player, IBody body) {
        this.player = player;
        this.body = body;
    }

    public Data(NBTTagCompound nbtTagCompound) {
        this.player = nbtTagCompound.func_186857_a("uuid");
        this.body = SpaceNet.instance.getBodyFromName(nbtTagCompound.func_74779_i("nameBody"));
        this.percent = nbtTagCompound.func_74769_h("percent");
    }

    public IBody getBody() {
        return this.body;
    }

    public NBTTagCompound writeNBT() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        nbtTagCompound.func_74780_a("percent", this.percent);
        nbtTagCompound.func_186854_a("uuid", this.player);
        nbtTagCompound.func_74778_a("nameBody", this.body.getName());
        return nbtTagCompound;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Data data = (Data)o;
        return Objects.equals(this.player, data.player) && Objects.equals(this.body, data.body);
    }

    @Override
    public double getPercent() {
        return this.percent;
    }

    @Override
    public void addInformation() {
        this.percent += 1.0;
        if (this.percent > 100.0) {
            this.percent = 100.0;
        }
    }

    @Override
    public void setInformation(double information) {
        this.percent = information;
        if (this.percent > 100.0) {
            this.percent = 100.0;
        }
    }

    @Override
    public void addInformation(double information) {
        this.percent += information;
        if (this.percent > 100.0) {
            this.percent = 100.0;
        }
    }
}

