/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.fakebody;

import com.denfop.api.space.BaseResource;
import com.denfop.api.space.IBaseResource;
import com.denfop.api.space.IBody;
import com.denfop.api.space.ISatellite;
import com.denfop.api.space.SpaceInit;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.fakebody.IData;
import com.denfop.api.space.fakebody.IFakeSatellite;
import com.denfop.api.space.fakebody.SpaceOperation;
import com.denfop.api.space.rovers.Rovers;
import com.denfop.api.space.rovers.api.IRovers;
import com.denfop.api.space.rovers.api.IRoversItem;
import com.denfop.api.space.rovers.enums.EnumTypeUpgrade;
import com.denfop.api.space.upgrades.SpaceUpgradeSystem;
import com.denfop.blocks.FluidName;
import com.denfop.utils.Timer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;

public class FakeSatellite
implements IFakeSatellite {
    SpaceOperation spaceOperation;
    private UUID player;
    private ISatellite planet;
    private IRovers rovers;
    private IData data;
    private List<IBaseResource> iBaseResourceList = new ArrayList<IBaseResource>();
    private Timer timerToPlanet;
    private Timer timerFromPlanet;

    public FakeSatellite(UUID player, ISatellite planet, IRovers rovers, IData data, SpaceOperation spaceOperation) {
        this.player = player;
        this.planet = planet;
        this.rovers = rovers;
        this.spaceOperation = spaceOperation;
        this.data = data;
        double distancePlanetToPlanet = (planet.getPlanet().getDistance() - SpaceInit.earth.getDistance()) / (SpaceInit.mars.getDistance() - SpaceInit.earth.getDistance());
        double distanceSatellite = Math.abs(SpaceInit.moon.getDistanceFromPlanet() - planet.getDistanceFromPlanet()) / SpaceInit.moon.getDistanceFromPlanet();
        if (planet.getPlanet() == SpaceInit.earth) {
            distanceSatellite = 1.0;
        }
        int seconds = (int)Math.abs(distanceSatellite * 2.5 * 60.0 * 0.8 + distancePlanetToPlanet * 576.0);
        if (SpaceUpgradeSystem.system.hasModules(EnumTypeUpgrade.ENGINE, rovers.getItemStack())) {
            int engine = SpaceUpgradeSystem.system.getModules((EnumTypeUpgrade)EnumTypeUpgrade.ENGINE, (ItemStack)rovers.getItemStack()).number;
            seconds = (int)((double)seconds * (1.0 - (double)engine * 0.125));
        }
        FluidStack fluidStack = rovers.getItem().getFluidHandler(rovers.getItemStack()).drain(1000, false);
        double coef = 1.0;
        if (fluidStack.getFluid().equals(FluidName.fluiddimethylhydrazine.getInstance())) {
            coef = 3.0;
        }
        if (fluidStack.getFluid().equals(FluidName.fluiddecane.getInstance())) {
            coef = 4.4;
        }
        if (fluidStack.getFluid().equals(FluidName.fluidxenon.getInstance())) {
            coef = 7.5;
        }
        seconds = (int)((double)seconds / coef);
        this.timerToPlanet = new Timer(seconds);
        this.timerFromPlanet = new Timer(seconds);
        this.timerFromPlanet.setCanWork(false);
    }

    public FakeSatellite(NBTTagCompound nbtTagCompound) {
        this.player = nbtTagCompound.func_186857_a("uuid");
        this.planet = (ISatellite)SpaceNet.instance.getBodyFromName(nbtTagCompound.func_74779_i("body"));
        this.data = SpaceNet.instance.getFakeSpaceSystem().getDataFromUUID(this.player).get(this.planet);
        ItemStack stack = new ItemStack(nbtTagCompound.func_74775_l("rover"));
        this.rovers = new Rovers((IRoversItem)stack.func_77973_b(), stack);
        this.timerToPlanet = new Timer(nbtTagCompound.func_74775_l("timerTo"));
        this.timerFromPlanet = new Timer(nbtTagCompound.func_74775_l("timerFrom"));
        this.spaceOperation = new SpaceOperation((IBody)this.planet, nbtTagCompound.func_74775_l("operation"));
        NBTTagList tagList = nbtTagCompound.func_150295_c("baseResource", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            BaseResource baseResource = new BaseResource(tagCompound);
            this.iBaseResourceList.add(baseResource);
        }
        SpaceUpgradeSystem.system.updateListFromNBT(this.rovers.getItem(), this.rovers.getItemStack());
    }

    @Override
    public Timer getTimerTo() {
        return this.timerToPlanet;
    }

    @Override
    public List<IBaseResource> getResource() {
        return this.iBaseResourceList;
    }

    @Override
    public void addBaseResource(IBaseResource baseResource) {
        this.iBaseResourceList.add(baseResource);
    }

    @Override
    public IBody getBody() {
        return this.getSatellite();
    }

    @Override
    public void resetAuto() {
        this.spaceOperation.setAuto(!this.getSpaceOperation().getAuto());
    }

    @Override
    public Timer getTimerFrom() {
        return this.timerFromPlanet;
    }

    @Override
    public SpaceOperation getSpaceOperation() {
        return this.spaceOperation;
    }

    @Override
    public NBTTagCompound writeNBTTagCompound(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_186854_a("uuid", this.player);
        nbtTagCompound.func_74778_a("body", this.planet.getName());
        nbtTagCompound.func_74782_a("rover", (NBTBase)this.rovers.getItemStack().func_77955_b(new NBTTagCompound()));
        nbtTagCompound.func_74782_a("timerTo", (NBTBase)this.timerToPlanet.writeNBT(new NBTTagCompound()));
        nbtTagCompound.func_74782_a("timerFrom", (NBTBase)this.timerFromPlanet.writeNBT(new NBTTagCompound()));
        nbtTagCompound.func_74782_a("operation", (NBTBase)this.spaceOperation.writeTag(new NBTTagCompound()));
        NBTTagList tagList = new NBTTagList();
        for (IBaseResource baseResource : this.iBaseResourceList) {
            NBTTagCompound nbt = new NBTTagCompound();
            baseResource.writeNBTTag(nbt);
            tagList.func_74742_a((NBTBase)nbt);
        }
        nbtTagCompound.func_74782_a("baseResource", (NBTBase)tagList);
        return nbtTagCompound;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FakeSatellite that = (FakeSatellite)o;
        return Objects.equals(this.player, that.player) && Objects.equals(this.planet, that.planet);
    }

    @Override
    public boolean matched(IBody body) {
        return this.planet.getName().equals(body.getName());
    }

    @Override
    public ISatellite getSatellite() {
        return this.planet;
    }

    @Override
    public UUID getPlayer() {
        return this.player;
    }

    @Override
    public IRovers getRover() {
        return this.rovers;
    }

    @Override
    public IData getData() {
        return this.data;
    }
}

