/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.upgrades;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.space.rovers.api.IRoversItem;
import com.denfop.api.space.rovers.enums.EnumTypeUpgrade;
import com.denfop.api.space.upgrades.api.ISpaceUpgradeSystem;
import com.denfop.api.space.upgrades.event.EventItemLoad;
import com.denfop.api.space.upgrades.info.SpaceUpgradeItemInform;
import com.denfop.recipe.IInputHandler;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BaseSpaceUpgradeSystem
implements ISpaceUpgradeSystem {
    Map<Integer, List<SpaceUpgradeItemInform>> map = new HashMap<Integer, List<SpaceUpgradeItemInform>>();
    Map<Integer, ItemStack> map_stack;
    Map<Integer, Integer> map_col = new HashMap<Integer, Integer>();
    int max = 0;

    public BaseSpaceUpgradeSystem() {
        this.map_stack = new HashMap<Integer, ItemStack>();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void addupgrade(Item container, ItemStack fill) {
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("roverupgradeblock", new BaseMachineRecipe(new Input(input.getInput(new ItemStack(container, 1, Short.MAX_VALUE)), input.getInput(fill)), new RecipeOutput(null, new ItemStack(container, 1, Short.MAX_VALUE))));
    }

    @SubscribeEvent
    public void loadItem(EventItemLoad event) {
        this.updateListFromNBT(event.item, event.stack);
    }

    @Override
    public int getRemaining(ItemStack item) {
        NBTTagCompound nbt = ModUtils.nbt(item);
        int id = nbt.func_74762_e("ID_Item");
        return this.map_col.getOrDefault(id, 24);
    }

    @Override
    public boolean hasInMap(ItemStack stack) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        int id = nbt.func_74762_e("ID_Item");
        ItemStack item = this.map_stack.get(id);
        if (item == null || item.func_190926_b()) {
            return false;
        }
        int id1 = ModUtils.nbt(item).func_74762_e("ID_Item");
        return item.func_77969_a(stack) && id1 == id && item.func_77978_p() != null && item.func_77978_p().equals((Object)stack.func_77978_p());
    }

    @Override
    public List<SpaceUpgradeItemInform> getInformation(ItemStack item) {
        NBTTagCompound nbt = ModUtils.nbt(item);
        int id = nbt.func_74762_e("ID_Item");
        List<SpaceUpgradeItemInform> list = this.map.get(id);
        return list != null ? list : Collections.emptyList();
    }

    @Override
    public SpaceUpgradeItemInform getModules(EnumTypeUpgrade module, ItemStack item) {
        List<SpaceUpgradeItemInform> list = this.getInformation(item);
        for (SpaceUpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return upgrade;
        }
        return null;
    }

    @Override
    public boolean hasModules(EnumTypeUpgrade module, ItemStack item) {
        if (!(item.func_77973_b() instanceof IRoversItem)) {
            return false;
        }
        List<SpaceUpgradeItemInform> list = this.getInformation(item);
        for (SpaceUpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateListFromNBT(IRoversItem item, ItemStack stack) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        boolean hasID = nbt.func_74767_n("hasID");
        int id = nbt.func_74762_e("ID_Item");
        if (!hasID) {
            id = this.max++;
            nbt.func_74768_a("ID_Item", id);
            nbt.func_74757_a("hasID", true);
        }
        NBTTagList modesTagList = nbt.func_150295_c("modes", 10);
        ArrayList<EnumTypeUpgrade> lst = new ArrayList<EnumTypeUpgrade>();
        for (int i = 0; i < modesTagList.func_74745_c(); ++i) {
            NBTTagCompound modeTag = modesTagList.func_150305_b(i);
            int index = modeTag.func_74762_e("index");
            lst.add(EnumTypeUpgrade.getFromID(index));
        }
        int ost = 24 - modesTagList.func_74745_c();
        nbt.func_74757_a("canupgrade", ost > 0);
        if (this.map_col.containsKey(id)) {
            this.map_col.replace(id, ost);
        } else {
            this.map_col.put(id, ost);
        }
        this.setInformation(item, lst, stack);
    }

    @Override
    public void setInformation(IRoversItem item, List<EnumTypeUpgrade> lst, ItemStack stack) {
        this.write(item, lst, stack);
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        this.map.clear();
        this.max = 0;
        this.map_col.clear();
        this.map_stack.clear();
    }

    @Override
    public void write(IRoversItem item, List<EnumTypeUpgrade> lst, ItemStack stack) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        int id = nbt.func_74762_e("ID_Item");
        Map<EnumTypeUpgrade, Integer> moduleCounts = lst.stream().collect(Collectors.toMap(module -> module, module -> 1, Integer::sum));
        List upgrades = moduleCounts.entrySet().stream().map(entry -> new SpaceUpgradeItemInform((EnumTypeUpgrade)((Object)((Object)entry.getKey())), (Integer)entry.getValue())).collect(Collectors.toList());
        this.map.put(id, upgrades);
        this.map_stack.put(id, stack);
    }

    private int getModulesValue(EnumTypeUpgrade module, ItemStack stack) {
        SpaceUpgradeItemInform modules = this.getModules(module, stack);
        if (modules == null) {
            return 0;
        }
        return modules.number;
    }

    @Override
    public void removeUpdate(ItemStack stack, World world, int index) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        NBTTagList modesTagList = nbt.func_150295_c("modes", 10);
        int i = 0;
        for (int ii = 0; ii < modesTagList.func_74745_c(); ++ii) {
            NBTTagCompound tagCompound = modesTagList.func_150305_b(ii);
            if (tagCompound.func_74762_e("index") != index) continue;
            i = ii;
            break;
        }
        modesTagList.func_74744_a(i);
        MinecraftForge.EVENT_BUS.post((Event)new EventItemLoad(world, (IRoversItem)stack.func_77973_b(), stack));
    }

    @Override
    public List<ItemStack> getListStack(ItemStack stack) {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        NBTTagCompound nbt = ModUtils.nbt(stack);
        NBTTagList modesTagList = nbt.func_150295_c("modes", 10);
        for (int ii = 0; ii < modesTagList.func_74745_c(); ++ii) {
            NBTTagCompound tagCompound = modesTagList.func_150305_b(ii);
            list.add(new ItemStack((Item)IUItem.spaceupgrademodule, 1, tagCompound.func_74762_e("index")));
        }
        return list;
    }

    @Override
    public void addRecipe(Item stack, EnumTypeUpgrade ... lst) {
        for (EnumTypeUpgrade upgrades : lst) {
            BaseSpaceUpgradeSystem.addupgrade(stack, new ItemStack((Item)IUItem.spaceupgrademodule, 1, upgrades.ordinal()));
        }
    }

    @Override
    public boolean shouldUpdate(EnumTypeUpgrade type, ItemStack stack1) {
        List<SpaceUpgradeItemInform> list = this.getInformation(stack1);
        for (SpaceUpgradeItemInform inform : list) {
            if (inform.upgrade != type || inform.number < type.getMax()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<String> getAvailableUpgrade(IRoversItem iUpgradeItem, ItemStack item) {
        NBTTagCompound nbt = ModUtils.nbt(item);
        int id = nbt.func_74762_e("ID_Item");
        List<SpaceUpgradeItemInform> list = this.map.get(id);
        List<EnumTypeUpgrade> list1 = iUpgradeItem.getUpgradeModules();
        LinkedList<String> stringList = new LinkedList<String>();
        block0: for (EnumTypeUpgrade enumInfoUpgradeModules : list1) {
            for (SpaceUpgradeItemInform upgradeItemInform : list) {
                if (!upgradeItemInform.upgrade.equals((Object)enumInfoUpgradeModules)) continue;
                if (upgradeItemInform.number >= upgradeItemInform.upgrade.getMax()) continue block0;
                stringList.add(TextFormatting.GREEN + "" + (upgradeItemInform.upgrade.getMax() - upgradeItemInform.number) + "x " + new ItemStack((Item)IUItem.spaceupgrademodule, 1, enumInfoUpgradeModules.ordinal()).func_82833_r());
                continue block0;
            }
            stringList.add(TextFormatting.GREEN + "" + enumInfoUpgradeModules.getMax() + "x " + new ItemStack((Item)IUItem.spaceupgrademodule, 1, enumInfoUpgradeModules.ordinal()).func_82833_r());
        }
        return list != null ? stringList : Collections.emptyList();
    }
}

