/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.steam;

import com.denfop.api.steam.EnumSteamPhase;
import com.denfop.api.steam.ICoolant;
import com.denfop.api.steam.ISteam;
import com.denfop.api.steam.ISteamBlade;
import com.denfop.tiles.mechanism.steamturbine.IRod;
import com.denfop.world.WorldBaseGen;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class Steam {
    private static final Random random = WorldBaseGen.random;
    private final ISteam steam;
    private double coef;

    public Steam(ISteam steam) {
        this.steam = steam;
        this.updateData();
    }

    public double getCoef() {
        return this.coef;
    }

    public void onTick() {
        if (this.steam.isWork() && this.coef > 0.0) {
            boolean update = false;
            FluidTank steamTank = this.steam.getSteamFluid();
            FluidTank waterTank = this.steam.getWaterFluid();
            if (steamTank.getFluidAmount() > 0 && steamTank.getFluidAmount() - this.steam.getPressure() * (this.steam.getSteamPhase().ordinal() + 1) >= 0) {
                int canAdd = waterTank.getCapacity() - waterTank.getFluidAmount();
                canAdd = Math.min(canAdd, this.steam.getPressure() * (this.steam.getSteamPhase().ordinal() + 1));
                steamTank.drain(this.steam.getPressure() * (this.steam.getSteamPhase().ordinal() + 1), true);
                if (canAdd > 0) {
                    waterTank.fill(new FluidStack(FluidRegistry.WATER, canAdd), true);
                }
                if (random.nextInt(5) <= 1 && this.steam.getHeat() < this.steam.getMaxHeat() * 0.5 && this.steam.getSteamPhase().ordinal() <= this.steam.getStableSteamPhase().ordinal()) {
                    this.steam.addPhase(random.nextInt(this.steam.getPressure() + 1));
                } else if (this.steam.getHeat() >= this.steam.getMaxHeat() * 0.5 && this.steam.getHeat() < this.steam.getMaxHeat() * 0.75 || this.steam.getSteamPhase().ordinal() > this.steam.getStableSteamPhase().ordinal()) {
                    this.steam.removePhase(random.nextInt(2));
                } else if (this.steam.getHeat() >= this.steam.getMaxHeat() * 0.75) {
                    this.steam.removePhase(random.nextInt(4));
                }
                this.steam.addHeat(this.steam.getPressure() * (this.steam.getSteamPhase().ordinal() + 1));
                for (ICoolant iCoolant : this.steam.getCoolant()) {
                    if (iCoolant.getCoolant().getFluid() == null || iCoolant.getCoolant().getFluid().amount < iCoolant.getPressure()) continue;
                    this.steam.removeHeat(iCoolant.getPower());
                    iCoolant.getCoolant().drain(iCoolant.getPressure(), true);
                }
            } else {
                this.steam.removePhase(random.nextInt(5));
            }
            for (IRod rod : this.steam.getInfo()) {
                int n = 0;
                for (ItemStack stack : rod.getSlot().getContents()) {
                    if (stack.func_190926_b()) continue;
                    ISteamBlade steamBlade = rod.getRods().get(n);
                    update = update || steamBlade.damageBlade(stack);
                    ++n;
                }
            }
            this.steam.setGeneration(this.getGeneration());
            if (update) {
                this.steam.updateInfo();
                this.updateData();
            }
        }
    }

    public double getGeneration() {
        EnumSteamPhase type = this.steam.getSteamPhase();
        return this.coef * (double)this.steam.getPhase() * (double)(type.ordinal() + 1) * 0.98;
    }

    public void updateData() {
        this.coef = 0.0;
        for (IRod entry : this.steam.getInfo()) {
            AtomicReference<Double> coefBlade = new AtomicReference<Double>(0.0);
            entry.getRods().forEach(steamBlade -> {
                Double cfr_ignored_0 = (Double)coefBlade.updateAndGet(v -> v + steamBlade.getCoef());
            });
            this.coef += coefBlade.get().doubleValue();
        }
    }
}

