/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.tesseract;

import com.denfop.api.tesseract.ITesseract;
import com.denfop.api.tesseract.TypeChannel;
import com.denfop.api.tesseract.TypeMode;
import com.denfop.network.packet.CustomPacketBuffer;
import java.util.Objects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class Channel {
    private final int channel;
    private TypeMode mode;
    private TypeChannel typeChannel;
    private ITesseract tesseract;
    private boolean isPrivate;
    private boolean active;
    private BlockPos pos;

    public Channel(int channel, ITesseract tesseract, TypeMode mode, TypeChannel typeChannel, boolean isPrivate) {
        this.channel = channel;
        this.mode = mode;
        this.typeChannel = typeChannel;
        this.active = false;
        this.isPrivate = isPrivate;
        this.tesseract = tesseract;
        this.pos = tesseract.getBlockPos();
    }

    public Channel(int channel, TypeMode mode, TypeChannel typeChannel, boolean isPrivate) {
        this.channel = channel;
        this.mode = mode;
        this.typeChannel = typeChannel;
        this.active = false;
        this.isPrivate = isPrivate;
        this.tesseract = null;
        this.pos = BlockPos.field_177992_a;
    }

    public Channel(CustomPacketBuffer customPacketBuffer) {
        this.channel = customPacketBuffer.readInt();
        this.mode = TypeMode.values()[customPacketBuffer.readInt()];
        this.typeChannel = TypeChannel.values()[customPacketBuffer.readInt()];
        this.active = customPacketBuffer.readBoolean();
        this.isPrivate = customPacketBuffer.readBoolean();
    }

    public Channel(NBTTagCompound nbtTagCompound) {
        this.channel = nbtTagCompound.func_74762_e("channel");
        this.mode = TypeMode.values()[nbtTagCompound.func_74762_e("mode")];
        this.typeChannel = TypeChannel.values()[nbtTagCompound.func_74762_e("typeChannel")];
        this.active = nbtTagCompound.func_74767_n("active");
        this.isPrivate = nbtTagCompound.func_74767_n("isPrivate");
    }

    public ITesseract getTesseract() {
        return this.tesseract;
    }

    public void setTesseract(ITesseract tesseract) {
        this.tesseract = tesseract;
        this.pos = tesseract.getBlockPos();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Channel channel1 = (Channel)o;
        return this.channel == channel1.channel && Objects.equals(this.tesseract, channel1.tesseract);
    }

    public int hashCode() {
        return Objects.hash(this.channel, this.tesseract);
    }

    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packetBuffer = new CustomPacketBuffer();
        packetBuffer.writeInt(this.channel);
        packetBuffer.writeInt(this.mode.ordinal());
        packetBuffer.writeInt(this.typeChannel.ordinal());
        packetBuffer.writeBoolean(this.active);
        packetBuffer.writeBoolean(this.isPrivate);
        return packetBuffer;
    }

    public NBTTagCompound writeNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74768_a("channel", this.channel);
        tagCompound.func_74768_a("mode", this.mode.ordinal());
        tagCompound.func_74768_a("typeChannel", this.typeChannel.ordinal());
        tagCompound.func_74757_a("active", this.active);
        tagCompound.func_74757_a("isPrivate", this.isPrivate);
        return tagCompound;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public void setPrivate(boolean aPrivate) {
        this.isPrivate = aPrivate;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public TypeChannel getTypeChannel() {
        return this.typeChannel;
    }

    public void setTypeChannel(TypeChannel typeChannel) {
        this.typeChannel = typeChannel;
    }

    public int getChannel() {
        return this.channel;
    }

    public TypeMode getMode() {
        return this.mode;
    }

    public void setMode(TypeMode mode) {
        this.mode = mode;
    }
}

