/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.tesseract;

import com.denfop.api.tesseract.Channel;
import com.denfop.api.tesseract.EventHandler;
import com.denfop.api.tesseract.ITesseract;
import com.denfop.api.tesseract.ITesseractSystem;
import com.denfop.api.tesseract.TesseractLocalSystem;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.World;

public class TesseractSystem
implements ITesseractSystem {
    public static TesseractSystem instance;
    public static Map<Integer, TesseractLocalSystem> localSystemMap;

    private TesseractSystem() {
        instance = this;
        new EventHandler();
    }

    public static void init() {
        if (instance == null) {
            new TesseractSystem();
        }
    }

    public TesseractLocalSystem getForWorld(World world) {
        if (world == null) {
            return null;
        }
        int id = world.field_73011_w.getDimension();
        if (!localSystemMap.containsKey(id)) {
            TesseractLocalSystem local = new TesseractLocalSystem();
            localSystemMap.put(id, local);
            return local;
        }
        return localSystemMap.get(id);
    }

    @Override
    public void addChannel(Channel channel) {
        TesseractLocalSystem tesseractLocalSystem = this.getForWorld(channel.getTesseract().getLevel());
        if (tesseractLocalSystem != null) {
            tesseractLocalSystem.addChannel(channel);
        }
    }

    @Override
    public void removeChannel(Channel channel) {
        TesseractLocalSystem tesseractLocalSystem = this.getForWorld(channel.getTesseract().getLevel());
        if (tesseractLocalSystem != null) {
            tesseractLocalSystem.removeChannel(channel);
        }
    }

    @Override
    public void addTesseract(ITesseract tesseract) {
        TesseractLocalSystem tesseractLocalSystem = this.getForWorld(tesseract.getLevel());
        if (tesseractLocalSystem != null) {
            tesseractLocalSystem.add(tesseract);
        }
    }

    @Override
    public void removeTesseract(ITesseract tesseract) {
        TesseractLocalSystem tesseractLocalSystem = this.getForWorld(tesseract.getLevel());
        if (tesseractLocalSystem != null) {
            tesseractLocalSystem.remove(tesseract);
        }
    }

    @Override
    public void onTick(World world) {
        TesseractLocalSystem tesseractLocalSystem = this.getForWorld(world);
        if (tesseractLocalSystem != null) {
            tesseractLocalSystem.onTick();
        }
    }

    @Override
    public void onWorldUnload(World world) {
        TesseractLocalSystem tesseractLocalSystem = this.getForWorld(world);
        if (tesseractLocalSystem != null) {
            tesseractLocalSystem.onUnload();
        }
    }

    @Override
    public List<Channel> getPublicChannels(World world) {
        TesseractLocalSystem tesseractLocalSystem = this.getForWorld(world);
        if (tesseractLocalSystem != null) {
            return tesseractLocalSystem.getPublicChannels();
        }
        return Collections.emptyList();
    }

    static {
        localSystemMap = new HashMap<Integer, TesseractLocalSystem>();
    }
}

