/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.transport;

import com.denfop.api.energy.event.TileLoadEvent;
import com.denfop.api.energy.event.TileUnLoadEvent;
import com.denfop.api.energy.event.TilesUpdateEvent;
import com.denfop.api.transport.TransportNetGlobal;
import com.denfop.api.transport.TransportNetLocal;
import com.denfop.api.transport.event.TransportTileLoadEvent;
import com.denfop.api.transport.event.TransportTileUnLoadEvent;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EventHandler {
    public EventHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void load(TileLoadEvent event) {
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void unLoad(TileUnLoadEvent event) {
        TileEntity tile = event.tileentity;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void update(TilesUpdateEvent event) {
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEnergyTileLoad(TransportTileLoadEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        TransportNetLocal local = TransportNetGlobal.getForWorld(event.getWorld());
        if (local != null) {
            local.addTile(event.tile);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEnergyTileUnLoad(TransportTileUnLoadEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        TransportNetLocal local = TransportNetGlobal.getForWorld(event.getWorld());
        if (local != null) {
            local.removeTile(event.tile);
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.WorldTickEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            TransportNetGlobal.onTickEnd(event.world);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        TransportNetGlobal.onWorldUnload(event.getWorld());
    }
}

