/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.transport;

import com.denfop.api.sytem.InfoTile;
import com.denfop.api.transport.ITransportAcceptor;
import com.denfop.api.transport.ITransportConductor;
import com.denfop.api.transport.ITransportEmitter;
import com.denfop.api.transport.ITransportSink;
import com.denfop.api.transport.ITransportSource;
import com.denfop.api.transport.ITransportTile;
import com.denfop.api.transport.ItemFluidHandler;
import com.denfop.api.transport.TransportItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TransportFluidItemSinkSource
implements ITransportSource,
ITransportSink {
    private final BlockPos pos;
    private final TileEntity parent;
    Map<EnumFacing, ItemFluidHandler> handlerMap = new HashMap<EnumFacing, ItemFluidHandler>();
    Map<EnumFacing, Integer> slotsMap = new HashMap<EnumFacing, Integer>();
    Map<EnumFacing, List<Integer>> limitsMap = new HashMap<EnumFacing, List<Integer>>();
    Map<EnumFacing, ITransportTile> energyConductorMap = new HashMap<EnumFacing, ITransportTile>();
    boolean hasHashCode = false;
    int hashCodeSource;
    List<InfoTile<ITransportTile>> validReceivers = new LinkedList<InfoTile<ITransportTile>>();
    List<Integer> energyTickList = new LinkedList<Integer>();
    private boolean isSink;
    private boolean isSource;
    private boolean isSinkFluid;
    private boolean isSourceFluid;
    private long id;
    private int hashCode;

    public TransportFluidItemSinkSource(TileEntity parent, BlockPos pos) {
        this.parent = parent;
        this.pos = pos;
        boolean isItem = false;
        boolean isFluid = false;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            int slots1;
            IItemHandler item_storage = (IItemHandler)parent.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
            IFluidHandler fluid_storage = (IFluidHandler)parent.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
            if (!isFluid && fluid_storage != null) {
                isFluid = true;
            }
            if (!isItem && item_storage != null) {
                isItem = true;
            }
            try {
                slots1 = item_storage.getSlots();
            }
            catch (Exception exception) {
                slots1 = 0;
            }
            this.handlerMap.put(facing, new ItemFluidHandler(item_storage, fluid_storage));
            this.slotsMap.put(facing, slots1);
            ArrayList<Integer> list_limits = new ArrayList<Integer>();
            for (int i = 0; i < slots1; ++i) {
                list_limits.add(item_storage.getSlotLimit(i));
            }
            this.limitsMap.put(facing, list_limits);
        }
        this.isSink = isItem;
        this.isSource = isItem;
        this.isSinkFluid = isFluid;
        this.isSourceFluid = isFluid;
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public void RemoveTile(ITransportTile tile, EnumFacing facing1) {
        if (!this.parent.func_145831_w().field_72995_K) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<ITransportTile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<ITransportTile> tileInfoTile = iter.next();
                if (!((ITransportTile)tileInfoTile.tileEntity).getBlockPos().equals((Object)tile.getBlockPos())) continue;
                iter.remove();
                break;
            }
        }
    }

    public int hashCode() {
        if (!this.hasHashCode) {
            this.hasHashCode = true;
            this.hashCode = super.hashCode();
            return this.hashCode;
        }
        return this.hashCode;
    }

    @Override
    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    @Override
    public Map<EnumFacing, ITransportTile> getTiles() {
        return this.energyConductorMap;
    }

    @Override
    public List<InfoTile<ITransportTile>> getValidReceivers() {
        return this.validReceivers;
    }

    @Override
    public TileEntity getTileEntity() {
        return this.parent;
    }

    @Override
    public void AddTile(ITransportTile tile, EnumFacing facing1) {
        if (!this.parent.func_145831_w().field_72995_K && !this.energyConductorMap.containsKey(facing1)) {
            this.energyConductorMap.put(facing1, tile);
            this.validReceivers.add(new InfoTile<ITransportTile>(tile, facing1.func_176734_d()));
        }
    }

    @Override
    public boolean emitsTo(ITransportAcceptor var1, EnumFacing var2) {
        if (this.isSource && this.handlerMap.get(var2).getItemHandler() instanceof IItemHandler && var1 instanceof ITransportConductor) {
            return true;
        }
        return this.isSourceFluid && this.handlerMap.get(var2).getFluidHandler() instanceof IFluidHandler && var1 instanceof ITransportConductor;
    }

    public TransportItem<?> getOffered(int type, EnumFacing facing) {
        TransportItem transportItem;
        if (type == 0) {
            TransportItem itemTransportItem = new TransportItem();
            LinkedList<ItemStack> itemStackList = new LinkedList<ItemStack>();
            LinkedList<Integer> integerList = new LinkedList<Integer>();
            int slots = this.slotsMap.get(facing);
            List<Integer> list_limits = this.limitsMap.get(facing);
            for (int i = 0; i < slots; ++i) {
                ItemStack stack = this.handlerMap.get(facing).getItemHandler().extractItem(i, list_limits.get(i).intValue(), true);
                if (stack.func_190926_b()) continue;
                itemStackList.add(stack);
                integerList.add(i);
            }
            itemTransportItem.setList(itemStackList);
            itemTransportItem.setList1(integerList);
            transportItem = itemTransportItem;
        } else {
            IFluidTankProperties[] fluidTanks;
            TransportItem fluidTransportItem = new TransportItem();
            LinkedList<FluidStack> fluidStackList = new LinkedList<FluidStack>();
            for (IFluidTankProperties fluidTankProperties : fluidTanks = this.handlerMap.get(facing).getFluidHandler().getTankProperties()) {
                FluidStack contents = fluidTankProperties.getContents();
                if (!fluidTankProperties.canDrain() || contents == null) continue;
                fluidStackList.add(contents);
            }
            fluidTransportItem.setList(fluidStackList);
            transportItem = fluidTransportItem;
        }
        return transportItem;
    }

    public void draw(Object var, int col, EnumFacing facing) {
        if (this.isSource && var instanceof ItemStack) {
            this.handlerMap.get(facing).getItemHandler().extractItem(col, ((ItemStack)var).func_190916_E(), false);
        }
        if (this.isSourceFluid && var instanceof FluidStack) {
            FluidStack fluidStack = (FluidStack)var;
            fluidStack.amount = col;
            this.handlerMap.get(facing).getFluidHandler().drain(fluidStack, true);
        }
    }

    @Override
    public boolean isItem() {
        return this.isSource;
    }

    @Override
    public boolean isFluid() {
        return this.isSourceFluid;
    }

    @Override
    public boolean isSource() {
        return this.isSource || this.isSourceFluid;
    }

    @Override
    public Object getHandler(EnumFacing facing) {
        ItemFluidHandler handler = this.handlerMap.get(facing);
        if (handler.getFluidHandler() != null && handler.getItemHandler() != null) {
            return handler;
        }
        if (handler.getFluidHandler() == null) {
            return handler.getItemHandler();
        }
        if (handler.getItemHandler() == null) {
            return handler.getFluidHandler();
        }
        return handler;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.pos;
    }

    @Override
    public boolean acceptsFrom(ITransportEmitter var1, EnumFacing var2) {
        Object handler = var1.getHandler(var2);
        if (this.isSink && handler instanceof IItemHandler && var1 instanceof ITransportConductor) {
            return true;
        }
        return this.isSinkFluid && handler instanceof IFluidHandler && var1 instanceof ITransportConductor;
    }

    @Override
    public List<Integer> getDemanded(EnumFacing facing) {
        if (!this.isSink) {
            return Collections.emptyList();
        }
        LinkedList<Integer> demandedSlots = new LinkedList<Integer>();
        List<Integer> list_limits = this.limitsMap.get(facing);
        for (int i = 0; i < list_limits.size(); ++i) {
            ItemStack stack = this.handlerMap.get(facing).getStackInSlot(i);
            int limit = list_limits.get(i);
            int maxStackSize = stack.func_77976_d();
            if (!stack.func_190926_b() && stack.func_190916_E() >= Math.min(limit, maxStackSize)) continue;
            demandedSlots.add(i);
        }
        return demandedSlots;
    }

    @Override
    public boolean isSink() {
        return this.isSink || this.isSinkFluid;
    }

    @Override
    public List<Integer> getEnergyTickList() {
        return this.energyTickList;
    }

    @Override
    public boolean isItemSink() {
        return this.isSink;
    }

    @Override
    public boolean isFluidSink() {
        return this.isSinkFluid;
    }
}

