/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.transport;

import com.denfop.api.sytem.InfoTile;
import com.denfop.api.transport.ITransportAcceptor;
import com.denfop.api.transport.ITransportConductor;
import com.denfop.api.transport.ITransportEmitter;
import com.denfop.api.transport.ITransportSink;
import com.denfop.api.transport.ITransportSource;
import com.denfop.api.transport.ITransportTile;
import com.denfop.api.transport.InfoCable;
import com.denfop.api.transport.Path;
import com.denfop.api.transport.TransportItem;
import com.denfop.api.transport.TransportTick;
import com.denfop.api.transport.TransportTickList;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class TransportNetLocal {
    final TransportTickList<TransportTick<ITransportSource, Path>> senderPath = new TransportTickList();
    private final World world;
    private final Map<BlockPos, ITransportTile> chunkCoordinatesITransportTileMap;
    List<ITransportSource> sourceToUpdateList = new LinkedList<ITransportSource>();
    byte tick;
    List<ITransportSource> delete = new ArrayList<ITransportSource>();

    TransportNetLocal(World world) {
        this.world = world;
        this.chunkCoordinatesITransportTileMap = new HashMap<BlockPos, ITransportTile>();
    }

    public void remove1(ITransportSource par1) {
        for (TransportTick transportTick : this.senderPath) {
            if (transportTick.getSource() != par1) continue;
            if (transportTick.getList() != null) {
                for (Path path : transportTick.getList()) {
                    path.target.getEnergyTickList().remove((Object)((ITransportSource)transportTick.getSource()).hashCode());
                }
            }
            transportTick.setItemList(null);
            transportTick.setFluidList(null);
            break;
        }
    }

    public void remove(ITransportSource par1) {
        TransportTick<ITransportSource, Path> energyTick = this.senderPath.removeSource(par1);
        if (energyTick != null) {
            if (energyTick.getList() != null) {
                for (Path path : energyTick.getList()) {
                    path.target.getEnergyTickList().remove((Object)energyTick.getSource().hashCode());
                }
            }
            energyTick.setFluidList(null);
            energyTick.setItemList(null);
        }
    }

    public void removeAll(List<TransportTick<ITransportSource, Path>> par1) {
        if (par1 == null) {
            return;
        }
        for (TransportTick<ITransportSource, Path> IEnergySource2 : par1) {
            if (IEnergySource2.getList() != null) {
                for (Path path : IEnergySource2.getList()) {
                    path.target.getEnergyTickList().remove((Object)IEnergySource2.getSource().hashCode());
                }
            }
            IEnergySource2.setFluidList(null);
            IEnergySource2.setItemList(null);
        }
    }

    public boolean hasInSystem(ITransportAcceptor par1) {
        for (TransportTick transportTick : this.senderPath) {
            if (transportTick.getEnergyItemPaths() != null) {
                for (Path path : transportTick.getEnergyItemPaths()) {
                    if (!path.first.getBlockPos().equals((Object)par1.getBlockPos()) && !path.end.getBlockPos().equals((Object)par1.getBlockPos())) continue;
                    return true;
                }
                continue;
            }
            if (transportTick.getEnergyFluidPaths() == null) continue;
            for (Path path : transportTick.getEnergyFluidPaths()) {
                if (!path.first.getBlockPos().equals((Object)par1.getBlockPos()) && !path.end.getBlockPos().equals((Object)par1.getBlockPos())) continue;
                return true;
            }
        }
        return false;
    }

    public List<TransportTick<ITransportSource, Path>> getSources(ITransportAcceptor par1) {
        if (par1 instanceof ITransportSink) {
            LinkedList<TransportTick<ITransportSource, Path>> list = new LinkedList<TransportTick<ITransportSource, Path>>();
            for (TransportTick transportTick : this.senderPath) {
                if (!((ITransportSink)par1).getEnergyTickList().contains(((ITransportSource)transportTick.getSource()).hashCode())) continue;
                list.add(transportTick);
            }
            return list;
        }
        if (par1 instanceof ITransportConductor) {
            LinkedList<TransportTick> list = new LinkedList<TransportTick>();
            for (TransportTick transportTick : this.senderPath) {
                if (!transportTick.getConductors().contains(par1)) continue;
                list.add(transportTick);
            }
            return new ArrayList<TransportTick<ITransportSource, Path>>(list);
        }
        return Collections.emptyList();
    }

    public void addTile(ITransportTile tile1) {
        this.addTileEntity(tile1.getBlockPos(), tile1);
    }

    public boolean containsKey(TransportTick<ITransportSource, Path> par1) {
        return this.senderPath.contains(par1);
    }

    public void addTileEntity(BlockPos coords, ITransportTile tile) {
        if (this.chunkCoordinatesITransportTileMap.containsKey(coords)) {
            return;
        }
        this.chunkCoordinatesITransportTileMap.put(coords, tile);
        this.updateAdd(coords, tile);
        if (tile instanceof ITransportAcceptor) {
            this.onTileEntityAdded((ITransportAcceptor)tile);
        }
        if (tile instanceof ITransportSource) {
            this.senderPath.add(new TransportTick(tile, null));
        }
    }

    private void updateAdd(BlockPos pos, ITransportTile tile) {
        for (EnumFacing dir : EnumFacing.values()) {
            ITransportAcceptor receiver2;
            ITransportEmitter sender2;
            BlockPos pos1 = pos.func_177972_a(dir);
            ITransportTile tile1 = this.chunkCoordinatesITransportTileMap.get(pos1);
            if (tile1 == null) continue;
            EnumFacing inverseDirection2 = dir.func_176734_d();
            if (tile1 instanceof ITransportEmitter && tile instanceof ITransportAcceptor) {
                sender2 = (ITransportEmitter)tile1;
                receiver2 = (ITransportAcceptor)tile;
                if (!sender2.emitsTo(receiver2, dir.func_176734_d()) || !receiver2.acceptsFrom(sender2, inverseDirection2.func_176734_d())) continue;
                tile1.AddTile(tile, dir.func_176734_d());
                tile.AddTile(tile1, dir);
                continue;
            }
            if (!(tile1 instanceof ITransportAcceptor) || !(tile instanceof ITransportEmitter) || !(sender2 = (ITransportEmitter)tile).emitsTo(receiver2 = (ITransportAcceptor)tile1, dir) || !receiver2.acceptsFrom(sender2, inverseDirection2)) continue;
            tile1.AddTile(tile, dir.func_176734_d());
            tile.AddTile(tile1, dir);
        }
    }

    public void onTileEntityAdded(ITransportAcceptor tile) {
        LinkedList tileEntitiesToCheck = new LinkedList();
        tileEntitiesToCheck.add(tile);
        long id = WorldBaseGen.random.nextLong();
        this.sourceToUpdateList = new LinkedList<ITransportSource>();
        while (!tileEntitiesToCheck.isEmpty()) {
            ITransportTile currentTileEntity = (ITransportTile)tileEntitiesToCheck.pop();
            List<InfoTile<ITransportTile>> validReceivers = currentTileEntity.getValidReceivers();
            for (InfoTile<ITransportTile> validReceiver : validReceivers) {
                if (validReceiver.tileEntity == tile || ((ITransportTile)validReceiver.tileEntity).getIdNetwork() == id) continue;
                ((ITransportTile)validReceiver.tileEntity).setId(id);
                if (validReceiver.tileEntity instanceof ITransportSource) {
                    this.sourceToUpdateList.add((ITransportSource)validReceiver.tileEntity);
                    continue;
                }
                if (!(validReceiver.tileEntity instanceof ITransportConductor)) continue;
                tileEntitiesToCheck.push(validReceiver.tileEntity);
            }
        }
        this.sourceToUpdateList = new ArrayList<ITransportSource>(this.sourceToUpdateList);
    }

    public void removeTile(ITransportTile tile1) {
        this.removeTileEntity(tile1);
    }

    public void removeTileEntity(ITransportTile tile) {
        if (!this.chunkCoordinatesITransportTileMap.containsKey(tile.getBlockPos())) {
            return;
        }
        this.chunkCoordinatesITransportTileMap.remove(tile.getBlockPos());
        if (tile instanceof ITransportAcceptor) {
            this.removeAll(this.getSources((ITransportAcceptor)tile));
        }
        if (tile instanceof ITransportSource) {
            this.remove((ITransportSource)tile);
        }
        this.updateRemove(tile.getBlockPos(), tile);
    }

    private void updateRemove(BlockPos pos, ITransportTile tile) {
        for (EnumFacing dir : EnumFacing.values()) {
            BlockPos pos1 = pos.func_177972_a(dir);
            ITransportTile tile1 = this.chunkCoordinatesITransportTileMap.get(pos1);
            if (tile1 == null) continue;
            tile1.RemoveTile(tile, dir.func_176734_d());
        }
    }

    public boolean canInsertOrExtract(ITransportConductor transportConductor, ItemStack stack, EnumFacing facing) {
        List<ItemStack> BlackItemStacks = transportConductor.getBlackListItems(facing);
        if (BlackItemStacks.isEmpty()) {
            List<ItemStack> WhiteItemStacks = transportConductor.getWhiteListItems(facing);
            if (!WhiteItemStacks.isEmpty()) {
                for (ItemStack stack1 : WhiteItemStacks) {
                    if (!stack1.func_77969_a(stack)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        for (ItemStack stack1 : BlackItemStacks) {
            if (!stack1.func_77969_a(stack)) continue;
            return false;
        }
        return true;
    }

    public boolean canInsertOrExtract(ITransportConductor transportConductor, FluidStack stack, EnumFacing facing) {
        List<FluidStack> BlackItemStacks = transportConductor.getBlackListFluids(facing);
        if (BlackItemStacks.isEmpty()) {
            List<FluidStack> WhiteItemStacks = transportConductor.getWhiteListFluids(facing);
            if (!WhiteItemStacks.isEmpty()) {
                for (FluidStack stack1 : WhiteItemStacks) {
                    if (!stack1.isFluidEqual(stack)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        for (FluidStack stack1 : BlackItemStacks) {
            if (!stack1.isFluidEqual(stack)) continue;
            return false;
        }
        return true;
    }

    public void emitTransportFrom(ITransportSource<ItemStack, IItemHandler> transportSource, List<Path> transportPaths) {
        for (Path path : transportPaths) {
            ITransportSink transportSink;
            List<Integer> demandedSlots;
            TransportItem<ItemStack> amount = transportSource.getOffered(0, path.firstSide);
            List<ItemStack> items = amount.getList();
            List<Integer> indices = amount.getList1();
            if (items.isEmpty() || path.end.getMax(this.tick) == 0 || path.first.getMax(this.tick) == 0 || (demandedSlots = (transportSink = path.target).getDemanded(path.targetDirection)).isEmpty() || !path.first.canWork() || !path.end.canWork()) continue;
            for (Integer slot : demandedSlots) {
                for (int i = 0; i < indices.size(); ++i) {
                    ItemStack remainingStack;
                    ItemStack currentItem = items.get(i);
                    if (currentItem.func_190926_b() || !this.canInsertOrExtract(path.first, currentItem, path.firstSide.func_176734_d()) || !this.canInsertOrExtract(path.end, currentItem, path.targetDirection.func_176734_d()) || !(remainingStack = path.getHandler().insertItem(slot.intValue(), currentItem, true)).func_190926_b() && remainingStack.func_190916_E() == currentItem.func_190916_E()) continue;
                    ItemStack stack = currentItem.func_77946_l();
                    int count = Math.min(Math.min(stack.func_190916_E(), path.end.getMax(this.tick)), path.first.getMax(this.tick));
                    stack.func_190920_e(count);
                    remainingStack = path.getHandler().insertItem(slot.intValue(), stack, false);
                    int transferredAmount = Math.min(count, currentItem.func_190916_E()) - remainingStack.func_190916_E();
                    path.end.setMax(transferredAmount);
                    path.first.setMax(transferredAmount);
                    if (transferredAmount > 0) {
                        ItemStack drawnStack = currentItem.func_77979_a(transferredAmount);
                        transportSource.draw(drawnStack, indices.get(i), path.firstSide);
                    }
                    if (remainingStack.func_190926_b()) {
                        items.set(i, ItemStack.field_190927_a);
                        continue;
                    }
                    items.get(i).func_190920_e(remainingStack.func_190916_E());
                }
            }
        }
    }

    public TileEntity getTileFromITransport(ITransportTile tile) {
        if (tile == null) {
            return null;
        }
        if (tile instanceof TileEntity) {
            return (TileEntity)tile;
        }
        return this.world.func_175625_s(tile.getBlockPos());
    }

    public Tuple<List<Path>, LinkedList<ITransportConductor>> discover(ITransportSource emitter) {
        LinkedList tileEntitiesToCheck = new LinkedList();
        AbstractList energyPaths = new LinkedList();
        long id = WorldBaseGen.random.nextLong();
        emitter.setId(id);
        tileEntitiesToCheck.push(emitter);
        LinkedList<ITransportConductor> set = new LinkedList<ITransportConductor>();
        while (!tileEntitiesToCheck.isEmpty()) {
            ITransportTile currentTileEntity = (ITransportTile)tileEntitiesToCheck.pop();
            List<InfoTile<ITransportTile>> validReceivers = this.getValidReceivers(currentTileEntity);
            InfoCable cable = null;
            if (currentTileEntity instanceof ITransportConductor) {
                cable = ((ITransportConductor)currentTileEntity).getCable();
            }
            for (InfoTile<ITransportTile> validReceiver : validReceivers) {
                ITransportConductor conductor;
                if (currentTileEntity == emitter) {
                    if (validReceiver.tileEntity == emitter || ((ITransportTile)validReceiver.tileEntity).getIdNetwork() == id || !(validReceiver.tileEntity instanceof ITransportConductor) || !((ITransportConductor)validReceiver.tileEntity).isOutput()) continue;
                    conductor = (ITransportConductor)validReceiver.tileEntity;
                    ((ITransportTile)validReceiver.tileEntity).setId(id);
                    conductor.setCable(new InfoCable(conductor, validReceiver.direction, cable));
                    tileEntitiesToCheck.push(validReceiver.tileEntity);
                    continue;
                }
                if (validReceiver.tileEntity == emitter || ((ITransportTile)validReceiver.tileEntity).getIdNetwork() == id) continue;
                if (validReceiver.tileEntity instanceof ITransportSink && currentTileEntity instanceof ITransportConductor && ((ITransportConductor)currentTileEntity).isInput()) {
                    ((ITransportTile)validReceiver.tileEntity).setId(id);
                    energyPaths.add(new Path((ITransportSink)validReceiver.tileEntity, validReceiver.direction));
                    continue;
                }
                if (!(validReceiver.tileEntity instanceof ITransportConductor)) continue;
                ((ITransportTile)validReceiver.tileEntity).setId(id);
                conductor = (ITransportConductor)validReceiver.tileEntity;
                conductor.setCable(new InfoCable(conductor, validReceiver.direction, cable));
                tileEntitiesToCheck.push(validReceiver.tileEntity);
            }
        }
        int id1 = WorldBaseGen.random.nextInt();
        energyPaths = new ArrayList(energyPaths);
        for (Path energyPath : energyPaths) {
            ITransportTile tileEntity = energyPath.target;
            EnumFacing energyBlockLink = energyPath.targetDirection;
            if (!((tileEntity = tileEntity.getTiles().get(energyBlockLink)) instanceof ITransportConductor)) continue;
            energyPath.end = (ITransportConductor)tileEntity;
            InfoCable cable = ((ITransportConductor)tileEntity).getCable();
            int max = energyPath.end.getMax();
            while (cable != null) {
                ITransportConductor energyConductor = cable.getConductor();
                if (energyConductor.getHashCodeSource() != id1) {
                    energyConductor.setHashCodeSource(id1);
                    set.add(energyConductor);
                }
                if (energyConductor.getMax() < max) {
                    energyPath.end = null;
                    break;
                }
                if ((cable = cable.getPrev()) == null) break;
                energyPath.first = cable.getConductor();
            }
            if (energyPath.first == null) continue;
            energyPath.firstSide = ModUtils.getFacingFromTwoPositions(emitter.getBlockPos(), energyPath.first.getBlockPos());
        }
        return new Tuple((Object)energyPaths, set);
    }

    private List<InfoTile<ITransportTile>> getValidReceivers(ITransportTile emitter) {
        return emitter.getValidReceivers();
    }

    public void onTickEnd() {
        if (!this.sourceToUpdateList.isEmpty()) {
            for (ITransportSource iTransportSource : this.sourceToUpdateList) {
                this.remove1(iTransportSource);
            }
            this.sourceToUpdateList.clear();
        }
        if (!this.delete.isEmpty()) {
            for (ITransportSource iTransportSource : this.delete) {
                this.removeTile(iTransportSource);
            }
            this.delete.clear();
        }
        try {
            for (TransportTick transportTick : this.senderPath) {
                LinkedList<Path> removePath;
                List list;
                Tuple<List<Path>, LinkedList<ITransportConductor>> tuple;
                ITransportSource entry;
                if (((ITransportSource)transportTick.getSource()).getValidReceivers().isEmpty() || ((ITransportSource)transportTick.getSource()).getTiles().isEmpty() || ((ITransportSource)transportTick.getSource()).getTileEntity().func_145837_r()) {
                    this.delete.add((ITransportSource)transportTick.getSource());
                    continue;
                }
                if (this.world.func_72820_D() % 2L == 0L && ((ITransportSource)transportTick.getSource()).isItem() && (entry = (ITransportSource)transportTick.getSource()) != null) {
                    if (transportTick.getEnergyItemPaths() == null) {
                        tuple = this.discover(entry);
                        list = (List)tuple.func_76341_a();
                        removePath = new LinkedList<Path>();
                        for (Path transportPaths : list) {
                            if (transportPaths.end == null || transportPaths.first == null || transportPaths.first == transportPaths.end) {
                                removePath.add(transportPaths);
                                continue;
                            }
                            if (!transportPaths.target.isSink()) {
                                removePath.add(transportPaths);
                                continue;
                            }
                            if (!transportPaths.first.isOutput() || transportPaths.end.isOutput()) {
                                removePath.add(transportPaths);
                                continue;
                            }
                            if (!transportPaths.first.isInput() && !transportPaths.first.isOutput()) {
                                removePath.add(transportPaths);
                                continue;
                            }
                            if (!transportPaths.end.isInput() && !transportPaths.end.isOutput()) {
                                removePath.add(transportPaths);
                                continue;
                            }
                            if (!(((ITransportSource)transportTick.getSource()).getHandler(transportPaths.firstSide) instanceof IItemHandler)) {
                                removePath.add(transportPaths);
                                continue;
                            }
                            transportPaths.target.getEnergyTickList().add(((ITransportSource)transportTick.getSource()).hashCode());
                        }
                        list.removeAll(removePath);
                        transportTick.setItemList(list);
                        transportTick.setConductors((LinkedList)tuple.func_76340_b());
                    }
                    if (!transportTick.getEnergyItemPaths().isEmpty()) {
                        this.emitTransportFrom(entry, transportTick.getEnergyItemPaths());
                    }
                }
                if (!((ITransportSource)transportTick.getSource()).isFluid() || (entry = (ITransportSource)transportTick.getSource()) == null) continue;
                if (transportTick.getEnergyFluidPaths() == null) {
                    tuple = this.discover(entry);
                    list = (List)tuple.func_76341_a();
                    removePath = new LinkedList();
                    for (Path transportPaths : list) {
                        if (transportPaths.end == null || transportPaths.first == null || transportPaths.first == transportPaths.end) {
                            removePath.add(transportPaths);
                            continue;
                        }
                        if (!transportPaths.first.isOutput() || transportPaths.end.isOutput()) {
                            removePath.add(transportPaths);
                            continue;
                        }
                        if (!transportPaths.first.isInput() && !transportPaths.first.isOutput()) {
                            removePath.add(transportPaths);
                            continue;
                        }
                        if (!transportPaths.end.isInput() && !transportPaths.end.isOutput()) {
                            removePath.add(transportPaths);
                            continue;
                        }
                        if (!transportPaths.target.isFluidSink()) {
                            removePath.add(transportPaths);
                            continue;
                        }
                        if (!(((ITransportSource)transportTick.getSource()).getHandler(transportPaths.firstSide) instanceof IFluidHandler)) {
                            removePath.add(transportPaths);
                            continue;
                        }
                        transportPaths.target.getEnergyTickList().add(((ITransportSource)transportTick.getSource()).hashCode());
                    }
                    list.removeAll(removePath);
                    transportTick.setFluidList(list);
                    transportTick.setConductors((LinkedList)tuple.func_76340_b());
                }
                if (transportTick.getEnergyFluidPaths().isEmpty()) continue;
                this.emitTransportFluidFrom(entry, transportTick.getEnergyFluidPaths());
            }
        }
        catch (Exception exception) {
            System.out.println("IUERROR:" + exception.getMessage());
        }
        this.tick = (byte)(this.tick + 1);
    }

    public void emitTransportFluidFrom(ITransportSource<FluidStack, IFluidHandler> TransportSource, List<Path> TransportPaths) {
        for (Path TransportPath : TransportPaths) {
            TransportItem<FluidStack> transportItem = TransportSource.getOffered(1, TransportPath.firstSide);
            List<FluidStack> list = transportItem.getList();
            if (list.isEmpty()) break;
            if (TransportPath.end.getMax(this.tick) == 0 || TransportPath.first.getMax(this.tick) == 0) continue;
            IFluidHandler handler = TransportPath.getFluidHandler();
            for (FluidStack fluidStack : list) {
                if (!this.canInsertOrExtract(TransportPath.first, fluidStack, TransportPath.firstSide.func_176734_d()) || !this.canInsertOrExtract(TransportPath.end, fluidStack, TransportPath.targetDirection.func_176734_d()) || fluidStack.amount <= 0) continue;
                int amount = handler.fill(fluidStack, false);
                amount = Math.min(amount, Math.min(TransportPath.first.getMax(this.tick), TransportPath.end.getMax(this.tick)));
                fluidStack = fluidStack.copy();
                fluidStack.amount = amount;
                if (amount <= 0) continue;
                handler.fill(fluidStack, true);
                TransportPath.first.setMax(amount);
                TransportPath.end.setMax(amount);
                TransportSource.draw(fluidStack, amount, TransportPath.firstSide);
            }
        }
    }

    public ITransportTile getTileEntity(BlockPos pos) {
        return this.chunkCoordinatesITransportTileMap.get(pos);
    }

    public void onTileEntityRemoved(ITransportAcceptor par1) {
        this.onTileEntityAdded(par1);
    }

    public void onUnload() {
        this.senderPath.clear();
        this.chunkCoordinatesITransportTileMap.clear();
    }
}

