/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.upgrade;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.upgrade.ILevelInstruments;
import com.denfop.api.upgrade.IUpgradeItem;
import com.denfop.api.upgrade.IUpgradeSystem;
import com.denfop.api.upgrade.IUpgradeWithBlackList;
import com.denfop.api.upgrade.UpgradeItemInform;
import com.denfop.api.upgrade.UpgradeModificator;
import com.denfop.api.upgrade.event.EventItemBlackListLoad;
import com.denfop.api.upgrade.event.EventItemLoad;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.modules.ItemUpgradeModule;
import com.denfop.recipe.IInputHandler;
import com.denfop.utils.ModUtils;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BaseUpgradeSystem
implements IUpgradeSystem {
    Map<Integer, List<UpgradeItemInform>> map = new HashMap<Integer, List<UpgradeItemInform>>();
    Map<Integer, List<UpgradeModificator>> map_modification;
    Map<Integer, ItemStack> map_stack;
    Map<Integer, Integer> map_col;
    Map<Integer, List<Integer>> levelMap;
    Map<Integer, List<String>> map_blackList = new HashMap<Integer, List<String>>();
    List<UpgradeModificator> list_modificators;
    int max = 0;

    public BaseUpgradeSystem() {
        this.map_col = new HashMap<Integer, Integer>();
        this.map_stack = new HashMap<Integer, ItemStack>();
        this.levelMap = new HashMap<Integer, List<Integer>>();
        this.list_modificators = new ArrayList<UpgradeModificator>();
        this.map_modification = new HashMap<Integer, List<UpgradeModificator>>();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void addupgrade(Item container, ItemStack fill) {
        NBTTagCompound nbt = ModUtils.nbt();
        nbt.func_74778_a("mode_module", fill.func_77973_b() instanceof ItemUpgradeModule ? ItemUpgradeModule.getType((int)fill.func_77952_i()).name : "blacklist");
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("upgradeblock", new BaseMachineRecipe(new Input(input.getInput(new ItemStack(container, 1, Short.MAX_VALUE)), input.getInput(fill)), new RecipeOutput(nbt, new ItemStack(container, 1, Short.MAX_VALUE))));
        Recipes.recipes.addRecipe("antiupgradeblock", new BaseMachineRecipe(new Input(input.getInput(new ItemStack(container, 1, Short.MAX_VALUE))), new RecipeOutput(nbt, fill)));
    }

    public static void addupgrade(Item container, ItemStack fill, String type) {
        NBTTagCompound nbt = ModUtils.nbt();
        nbt.func_74778_a("type", type);
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("upgradeblock", new BaseMachineRecipe(new Input(input.getInput(new ItemStack(container, 1, Short.MAX_VALUE)), input.getInput(fill)), new RecipeOutput(nbt, new ItemStack(container, 1, Short.MAX_VALUE))));
    }

    @Override
    public void addModification() {
        if (this.list_modificators.isEmpty()) {
            this.list_modificators.add(new UpgradeModificator(new ItemStack(IUItem.core, 1, 7), "0"));
            this.list_modificators.add(new UpgradeModificator(new ItemStack(IUItem.neutroniumingot, 1), "1"));
        }
    }

    @Override
    public List<Integer> getPositiveUpgradeFromLevel(ItemStack stack) {
        if (stack.func_77973_b() instanceof ILevelInstruments) {
            ILevelInstruments levelInstruments = (ILevelInstruments)stack.func_77973_b();
            int level = levelInstruments.getLevel(stack);
            int speed = level / 2;
            int less_draw_energy = level / 5;
            int lucky = level / 10;
            int area = level / 15;
            int depth = level / 20;
            ArrayList<Integer> integers = new ArrayList<Integer>();
            integers.add(speed);
            integers.add(less_draw_energy);
            integers.add(lucky);
            integers.add(area);
            integers.add(depth);
            return integers;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void addModificate(ItemStack container, String name) {
        NBTTagCompound nbt = ModUtils.nbt(container);
        NBTTagList modificationsTagList = nbt.func_150295_c("modifications", 10);
        for (int i = 0; i < this.list_modificators.size(); ++i) {
            UpgradeModificator modificator = this.list_modificators.get(i);
            if (!modificator.matches(name)) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74768_a("index", i);
            modificationsTagList.func_74742_a((NBTBase)tagCompound);
            nbt.func_74782_a("modifications", (NBTBase)modificationsTagList);
            break;
        }
    }

    @Override
    public boolean needModificate(ItemStack container, ItemStack fill) {
        List<UpgradeModificator> list = this.getListModifications(container);
        for (UpgradeModificator modificator : list) {
            if (!modificator.matches(fill)) continue;
            return false;
        }
        return true;
    }

    @SubscribeEvent
    public void loadItem(EventItemLoad event) {
        this.updateListFromNBT(event.item, event.stack);
    }

    @SubscribeEvent
    public void loadItem(EventItemBlackListLoad event) {
        this.updateBlackListFromNBT(event.item, event.stack, event.nbt);
    }

    @Override
    public boolean getModifications(ItemStack item) {
        return this.map_modification.containsKey(ModUtils.nbt(item).func_74762_e("ID_Item"));
    }

    @Override
    public List<UpgradeModificator> getListModifications(ItemStack item) {
        int id = ModUtils.nbt(item).func_74762_e("ID_Item");
        ArrayList list = this.map_modification.get(id);
        return list != null ? list : new ArrayList();
    }

    @Override
    public int getRemaining(ItemStack item) {
        NBTTagCompound nbt = ModUtils.nbt(item);
        int id = nbt.func_74762_e("ID_Item");
        int k = this.getListModifications(item).size();
        return this.map_col.getOrDefault(id, 4 + k);
    }

    @Override
    public boolean hasBlackList(ItemStack item) {
        NBTTagCompound nbt = ModUtils.nbt(item);
        int id = nbt.func_74762_e("ID_Item");
        return this.map_blackList.containsKey(id);
    }

    @Override
    public boolean hasInMap(ItemStack stack) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        int id = nbt.func_74762_e("ID_Item");
        ItemStack item = this.map_stack.get(id);
        if (item == null || item.func_190926_b()) {
            return false;
        }
        int id1 = ModUtils.nbt(item).func_74762_e("ID_Item");
        return item.func_77969_a(stack) && id1 == id && item.func_77978_p() != null && item.func_77978_p().equals((Object)stack.func_77978_p());
    }

    @Override
    public List<String> getBlackList(ItemStack item) {
        NBTTagCompound nbt = ModUtils.nbt(item);
        int id = nbt.func_74762_e("ID_Item");
        List<String> list = this.map_blackList.get(id);
        return list != null ? list : Collections.emptyList();
    }

    @Override
    public List<UpgradeItemInform> getInformation(ItemStack item) {
        NBTTagCompound nbt = ModUtils.nbt(item);
        int id = nbt.func_74762_e("ID_Item");
        List<UpgradeItemInform> list = this.map.get(id);
        return list != null ? list : Collections.emptyList();
    }

    @Override
    public List<String> getAvailableUpgrade(IUpgradeItem iUpgradeItem, ItemStack item) {
        NBTTagCompound nbt = ModUtils.nbt(item);
        int id = nbt.func_74762_e("ID_Item");
        List<UpgradeItemInform> list = this.map.get(id);
        List<EnumInfoUpgradeModules> list1 = iUpgradeItem.getUpgradeModules();
        LinkedList<String> stringList = new LinkedList<String>();
        block0: for (EnumInfoUpgradeModules enumInfoUpgradeModules : list1) {
            for (UpgradeItemInform upgradeItemInform : list) {
                if (!upgradeItemInform.upgrade.equals((Object)enumInfoUpgradeModules)) continue;
                if (upgradeItemInform.number >= upgradeItemInform.upgrade.max) continue block0;
                stringList.add(TextFormatting.GREEN + "" + (upgradeItemInform.upgrade.max - upgradeItemInform.number) + "x " + new ItemStack(IUItem.upgrademodule, 1, enumInfoUpgradeModules.ordinal()).func_82833_r());
                continue block0;
            }
            stringList.add(TextFormatting.GREEN + "" + enumInfoUpgradeModules.max + "x " + new ItemStack(IUItem.upgrademodule, 1, enumInfoUpgradeModules.ordinal()).func_82833_r());
        }
        return list != null ? stringList : Collections.emptyList();
    }

    @Override
    public UpgradeItemInform getModules(EnumInfoUpgradeModules module, ItemStack item) {
        List<UpgradeItemInform> list = this.getInformation(item);
        for (UpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return upgrade;
        }
        return null;
    }

    @Override
    public UpgradeItemInform getModules(EnumInfoUpgradeModules module, ItemStack item, List<UpgradeItemInform> list) {
        for (UpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return upgrade;
        }
        return null;
    }

    @Override
    public boolean hasModules(EnumInfoUpgradeModules module, ItemStack item) {
        if (!(item.func_77973_b() instanceof IUpgradeItem)) {
            return false;
        }
        List<UpgradeItemInform> list = this.getInformation(item);
        for (UpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasModules(EnumInfoUpgradeModules module, ItemStack item, List<UpgradeItemInform> list) {
        if (!(item.func_77973_b() instanceof IUpgradeItem)) {
            return false;
        }
        for (UpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateListFromNBT(IUpgradeItem item, ItemStack stack) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        boolean hasID = nbt.func_74767_n("hasID");
        int id = nbt.func_74762_e("ID_Item");
        if (!hasID) {
            id = this.max++;
            nbt.func_74768_a("ID_Item", id);
            nbt.func_74757_a("hasID", true);
        }
        NBTTagList modificationsTagList = nbt.func_150295_c("modifications", 10);
        ArrayList<UpgradeModificator> list = new ArrayList<UpgradeModificator>();
        this.addModification();
        for (int i = 0; i < modificationsTagList.func_74745_c(); ++i) {
            NBTTagCompound modificationTag = modificationsTagList.func_150305_b(i);
            int index = modificationTag.func_74762_e("index");
            if (this.getModification(index) == null) continue;
            list.add(this.getModification(index));
        }
        List<UpgradeModificator> list1 = this.map_modification.get(id);
        if (list1 != null) {
            list1.clear();
            list1.addAll(list);
        } else {
            this.map_modification.put(id, list);
        }
        NBTTagList modesTagList = nbt.func_150295_c("modes", 10);
        ArrayList<EnumInfoUpgradeModules> lst = new ArrayList<EnumInfoUpgradeModules>();
        for (int i = 0; i < modesTagList.func_74745_c(); ++i) {
            NBTTagCompound modeTag = modesTagList.func_150305_b(i);
            int index = modeTag.func_74762_e("index");
            lst.add(EnumInfoUpgradeModules.getFromID(index));
        }
        int ost = modificationsTagList.func_74745_c() + 4 - modesTagList.func_74745_c();
        nbt.func_74757_a("canupgrade", ost > 0);
        if (this.map_col.containsKey(id)) {
            this.map_col.replace(id, ost);
        } else {
            this.map_col.put(id, ost);
        }
        if (this.levelMap.containsKey(id)) {
            this.levelMap.replace(id, this.getPositiveUpgradeFromLevel(stack));
        } else {
            this.levelMap.put(id, this.getPositiveUpgradeFromLevel(stack));
        }
        this.setInformation(item, lst, stack);
    }

    public List<Integer> getLevel(ItemStack stack) {
        List<Integer> level;
        NBTTagCompound nbt = ModUtils.nbt(stack);
        int id = nbt.func_74762_e("ID_Item");
        if (this.levelMap.containsKey(id)) {
            level = this.getPositiveUpgradeFromLevel(stack);
            this.levelMap.replace(id, level);
        } else {
            level = this.getPositiveUpgradeFromLevel(stack);
            this.levelMap.put(id, level);
        }
        return level;
    }

    @Override
    public List<Integer> getUpgradeFromList(ItemStack stack) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        int id = nbt.func_74762_e("ID_Item");
        return this.levelMap.getOrDefault(id, this.getLevel(stack));
    }

    private UpgradeModificator getModification(int i) {
        if (i == 0) {
            return this.list_modificators.get(0);
        }
        if (i == 1) {
            return this.list_modificators.get(1);
        }
        return null;
    }

    @Override
    public void setInformation(IUpgradeItem item, List<EnumInfoUpgradeModules> lst, ItemStack stack) {
        this.write(item, lst, stack);
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        this.map.clear();
        this.map_blackList.clear();
        this.max = 0;
        this.map_col.clear();
        this.map_stack.clear();
        this.list_modificators.clear();
        this.map_modification.clear();
        this.levelMap.clear();
    }

    @Override
    public void write(IUpgradeItem item, List<EnumInfoUpgradeModules> lst, ItemStack stack) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        int id = nbt.func_74762_e("ID_Item");
        Map<EnumInfoUpgradeModules, Integer> moduleCounts = lst.stream().collect(Collectors.toMap(module -> module, module -> 1, Integer::sum));
        List upgrades = moduleCounts.entrySet().stream().map(entry -> new UpgradeItemInform((EnumInfoUpgradeModules)((Object)((Object)entry.getKey())), (Integer)entry.getValue())).collect(Collectors.toList());
        this.map.put(id, upgrades);
        this.map_stack.put(id, stack);
        Map enchantmentMap = EnchantmentHelper.func_82781_a((ItemStack)stack);
        this.updateEnchantment(enchantmentMap, Enchantments.field_185306_r, EnumInfoUpgradeModules.SILK_TOUCH, 1, stack);
        this.updateEnchantment(enchantmentMap, Enchantments.field_185308_t, EnumInfoUpgradeModules.LUCKY, this.getModulesValue(EnumInfoUpgradeModules.LUCKY, stack), stack);
        this.updateEnchantment(enchantmentMap, Enchantments.field_185305_q, EnumInfoUpgradeModules.EFFICIENT, this.calculateEfficiencyLevel(stack), stack);
        this.updateEnchantment(enchantmentMap, Enchantments.field_77334_n, EnumInfoUpgradeModules.FIRE, this.getModulesValue(EnumInfoUpgradeModules.FIRE, stack), stack);
        this.updateEnchantment(enchantmentMap, Enchantments.field_185304_p, EnumInfoUpgradeModules.LOOT, this.getModulesValue(EnumInfoUpgradeModules.LOOT, stack), stack);
        this.updateEnchantment(enchantmentMap, Enchantments.field_180308_g, EnumInfoUpgradeModules.PROTECTION_ARROW, this.calculateProjectileProtectionLevel(stack), stack);
        EnchantmentHelper.func_82782_a((Map)enchantmentMap, (ItemStack)stack);
    }

    private void updateEnchantment(Map<Enchantment, Integer> enchantmentMap, Enchantment enchantment, EnumInfoUpgradeModules module, int level, ItemStack stack) {
        if (this.hasModules(module, stack)) {
            enchantmentMap.put(enchantment, level);
        } else {
            enchantmentMap.remove(enchantment);
        }
    }

    private int getModulesValue(EnumInfoUpgradeModules module, ItemStack stack) {
        UpgradeItemInform modules = this.getModules(module, stack);
        if (modules == null) {
            return 0;
        }
        return modules.number;
    }

    private int calculateEfficiencyLevel(ItemStack stack) {
        int baseLevel = 1;
        int moduleLevel = this.getModulesValue(EnumInfoUpgradeModules.EFFICIENT, stack);
        if (moduleLevel == 0) {
            return 0;
        }
        return baseLevel + (moduleLevel - 1) * 2;
    }

    private int calculateProjectileProtectionLevel(ItemStack stack) {
        int baseLevel = 1;
        int moduleLevel = this.getModulesValue(EnumInfoUpgradeModules.PROTECTION_ARROW, stack);
        if (moduleLevel == 0) {
            return 0;
        }
        return baseLevel + (moduleLevel - 1) * 2;
    }

    @Override
    public void updateBlackListFromNBT(IUpgradeWithBlackList item, ItemStack stack, NBTTagCompound nbt) {
        this.updateListFromNBT(item, stack);
        int id = nbt.func_74762_e("ID_Item");
        NBTTagList tagList = nbt.func_150295_c("blacklist", 8);
        AbstractList blacklist = new LinkedList<String>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            blacklist.add(tagList.func_150307_f(i));
        }
        blacklist = new ArrayList(blacklist);
        nbt.func_74757_a("accept_blacklist", true);
        if (this.map_blackList.containsKey(id)) {
            this.map_blackList.replace(id, blacklist);
        } else {
            this.map_blackList.put(id, blacklist);
        }
    }

    @Override
    public void updateLevel(ItemStack stack) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        int id = nbt.func_74762_e("ID_Item");
        if (this.levelMap.containsKey(id)) {
            this.levelMap.replace(id, this.getPositiveUpgradeFromLevel(stack));
        } else {
            this.levelMap.put(id, this.getPositiveUpgradeFromLevel(stack));
        }
    }

    @Override
    public void updateBlackListFromStack(ItemStack stack) {
        AbstractList lst = new LinkedList<String>();
        NBTTagCompound nbt = ModUtils.nbt(stack);
        NBTTagList tagList = nbt.func_150295_c("blacklist", 8);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            lst.add(tagList.func_150307_f(i));
        }
        lst = new ArrayList(lst);
        int id = nbt.func_74762_e("ID_Item");
        nbt.func_74757_a("accept_blacklist", true);
        this.map_blackList.put(id, lst);
    }

    @Override
    public void removeUpdate(ItemStack stack, World world, int index) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        NBTTagList modesTagList = nbt.func_150295_c("modes", 10);
        int i = 0;
        for (int ii = 0; ii < modesTagList.func_74745_c(); ++ii) {
            NBTTagCompound tagCompound = modesTagList.func_150305_b(ii);
            if (tagCompound.func_74762_e("index") != index) continue;
            i = ii;
            break;
        }
        modesTagList.func_74744_a(i);
        MinecraftForge.EVENT_BUS.post((Event)new EventItemLoad(world, (IUpgradeItem)stack.func_77973_b(), stack));
    }

    @Override
    public List<ItemStack> getListStack(ItemStack stack) {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        NBTTagCompound nbt = ModUtils.nbt(stack);
        NBTTagList modesTagList = nbt.func_150295_c("modes", 10);
        for (int ii = 0; ii < modesTagList.func_74745_c(); ++ii) {
            NBTTagCompound tagCompound = modesTagList.func_150305_b(ii);
            list.add(new ItemStack(IUItem.upgrademodule, 1, tagCompound.func_74762_e("index")));
        }
        return list;
    }

    @Override
    public void addRecipe(Item stack, List<EnumInfoUpgradeModules> lst) {
        for (EnumInfoUpgradeModules upgrades : lst) {
            BaseUpgradeSystem.addupgrade(stack, new ItemStack(IUItem.upgrademodule, 1, upgrades.ordinal()));
        }
        if (lst.contains((Object)EnumInfoUpgradeModules.DIG_DEPTH)) {
            BaseUpgradeSystem.addupgrade(stack, new ItemStack(IUItem.module9, 1, 12));
        }
        for (UpgradeModificator modificator : this.list_modificators) {
            BaseUpgradeSystem.addupgrade(stack, modificator.itemstack, modificator.type);
        }
    }

    @Override
    public boolean shouldUpdate(EnumInfoUpgradeModules type, ItemStack stack1) {
        List<UpgradeItemInform> list = this.getInformation(stack1);
        for (UpgradeItemInform inform : list) {
            if (inform.upgrade != type || inform.number < type.max) continue;
            return false;
        }
        return true;
    }
}

