/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.upgrade;

import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.utils.ModUtils;
import net.minecraft.item.ItemStack;

public interface ILevelInstruments {
    default public int getLevel(ItemStack stack) {
        return ModUtils.nbt(stack).func_74762_e("level");
    }

    default public int getExperience(ItemStack stack) {
        return ModUtils.nbt(stack).func_74762_e("experience");
    }

    default public int getMaxLevel(ItemStack stack) {
        int level = this.getLevel(stack);
        if (level >= 30) {
            return Integer.MAX_VALUE;
        }
        return (int)(Math.pow(2.0, Math.log(Math.exp(Math.log(level + 1)))) * (150.0 * Math.log(Math.pow(8.0, level + 1))));
    }

    default public void addExperience(ItemStack stack, int experience) {
        int exp = this.getExperience(stack) + experience;
        int maxLevel = this.getMaxLevel(stack);
        if (maxLevel == Integer.MAX_VALUE) {
            return;
        }
        if (maxLevel < exp) {
            exp -= maxLevel;
            ModUtils.nbt(stack).func_74768_a("level", this.getLevel(stack) + 1);
            UpgradeSystem.system.updateLevel(stack);
        }
        ModUtils.nbt(stack).func_74768_a("experience", exp);
    }
}

