/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.vein;

import com.denfop.Config;
import com.denfop.api.vein.IVeinSystem;
import com.denfop.api.vein.Type;
import com.denfop.api.vein.Vein;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeHills;
import net.minecraft.world.biome.BiomeSnow;
import net.minecraft.world.biome.BiomeTaiga;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;

public class VeinSystem
implements IVeinSystem {
    public static IVeinSystem system;
    public static Vein EMPTY;
    private final Random rand;
    List<Vein> list;
    LinkedList<ChunkPos> chunkPos;
    Map<ChunkPos, Vein> chunkPosVeinMap;

    public VeinSystem() {
        system = this;
        this.list = new LinkedList<Vein>();
        this.chunkPos = new LinkedList();
        this.chunkPosVeinMap = new HashMap<ChunkPos, Vein>();
        this.rand = new Random();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public Vein getEMPTY() {
        return EMPTY;
    }

    @Override
    public LinkedList<ChunkPos> getChunkPos() {
        return this.chunkPos;
    }

    @Override
    public List<Vein> getVeinsList() {
        return this.list;
    }

    @Override
    public void addVein(Chunk chunk) {
        int col;
        int chance = this.rand.nextInt(100);
        this.rand.setSeed(this.rand.nextLong());
        Vein vein = new Vein(Type.EMPTY, 0, chunk.func_76632_l());
        Biome biome = chunk.func_177412_p().func_180494_b(new BlockPos(chunk.field_76635_g * 16, 0, chunk.field_76647_h * 16));
        int n = col = biome instanceof BiomeHills ? 25 : 0;
        if (chance >= 15 + col) {
            int n2 = col = biome instanceof BiomeTaiga || biome instanceof BiomeSnow ? 15 : 0;
            if (this.rand.nextInt(100) < 85 - col) {
                this.getnumber(vein, biome);
            } else {
                vein.setType(Type.GAS);
                vein.setOldMineral(false);
                vein.setMeta(0);
                vein.setMaxCol(450000);
                vein.setCol(450000);
            }
        } else {
            int meta = this.rand.nextInt(30);
            vein.setType(Type.VEIN);
            vein.setOldMineral(meta <= 15);
            vein.setMeta(meta);
            vein.setMaxCol(Config.maxVein);
            vein.setCol(Config.maxVein);
        }
        this.list.add(vein);
        this.chunkPos.add(vein.getChunk());
        this.chunkPosVeinMap.put(vein.getChunk(), vein);
    }

    @Override
    public void addVein(NBTTagCompound tag) {
        Vein vein = new Vein(tag);
        this.list.add(vein);
        this.chunkPos.add(vein.getChunk());
        this.chunkPosVeinMap.put(vein.getChunk(), vein);
    }

    @Override
    public Vein getVein(ChunkPos pos) {
        return this.chunkPosVeinMap.getOrDefault(pos, EMPTY);
    }

    @Override
    public void unload() {
        this.list.clear();
        this.chunkPos.clear();
        this.chunkPosVeinMap.clear();
    }

    private void getnumber(Vein vein, Biome biome) {
        int meta = this.rand.nextInt(6);
        if (Biome.func_185362_a((Biome)biome) == 2) {
            int random = this.rand.nextInt(100);
            if (random >= 35) {
                int number = this.rand.nextInt(500000) + 150000;
                vein.setCol(number);
                vein.setMaxCol(number);
                vein.setType(Type.OIL);
                vein.setOldMineral(true);
                vein.setMeta(meta);
            } else {
                vein.setType(Type.EMPTY);
                vein.setCol(0);
                vein.setMaxCol(0);
            }
        } else if (Biome.func_185362_a((Biome)biome) == 0) {
            int random = this.rand.nextInt(100);
            if (random >= 40) {
                int number = this.rand.nextInt(500000) + 150000;
                vein.setCol(number);
                vein.setMaxCol(number);
                vein.setType(Type.OIL);
                vein.setOldMineral(true);
                vein.setMeta(meta);
            } else {
                vein.setType(Type.EMPTY);
                vein.setCol(0);
                vein.setMaxCol(0);
            }
        } else if (Biome.func_185362_a((Biome)biome) == 24) {
            int random = this.rand.nextInt(100);
            if (random > 35) {
                int number = this.rand.nextInt(300000) + 100000;
                vein.setCol(number);
                vein.setMaxCol(number);
                vein.setType(Type.OIL);
                vein.setOldMineral(true);
                vein.setMeta(meta);
            } else {
                vein.setType(Type.EMPTY);
                vein.setCol(0);
                vein.setMaxCol(0);
            }
        } else if (Biome.func_185362_a((Biome)biome) == 10) {
            int random = this.rand.nextInt(100);
            if (random > 60) {
                int number = this.rand.nextInt(300000) + 100000;
                vein.setCol(number);
                vein.setMaxCol(number);
                vein.setType(Type.OIL);
                vein.setOldMineral(true);
                vein.setMeta(meta);
            } else {
                vein.setType(Type.EMPTY);
                vein.setCol(0);
                vein.setMaxCol(0);
            }
        } else if (Biome.func_185362_a((Biome)biome) == 17) {
            int random = this.rand.nextInt(100);
            if (random > 35) {
                int number = this.rand.nextInt(300000) + 200000;
                vein.setCol(number);
                vein.setMaxCol(number);
                vein.setType(Type.OIL);
                vein.setOldMineral(true);
                vein.setMeta(meta);
            } else {
                vein.setType(Type.EMPTY);
                vein.setCol(0);
                vein.setMaxCol(0);
            }
        } else if (Biome.func_185362_a((Biome)biome) == 7) {
            int random = this.rand.nextInt(100);
            if (random > 50) {
                int number = this.rand.nextInt(200000) + 50000;
                vein.setCol(number);
                vein.setMaxCol(number);
                vein.setType(Type.OIL);
                vein.setOldMineral(true);
                vein.setMeta(meta);
            } else {
                vein.setType(Type.EMPTY);
                vein.setCol(0);
                vein.setMaxCol(0);
            }
        } else if (Biome.func_185362_a((Biome)biome) == 35) {
            int random = this.rand.nextInt(100);
            if (random > 50) {
                int number = this.rand.nextInt(300000) + 100000;
                vein.setCol(number);
                vein.setMaxCol(number);
                vein.setType(Type.OIL);
                vein.setOldMineral(true);
                vein.setMeta(meta);
            } else {
                vein.setType(Type.EMPTY);
                vein.setCol(0);
                vein.setMaxCol(0);
            }
        } else {
            int random = this.rand.nextInt(100);
            if (random > 89) {
                int number = this.rand.nextInt(300000);
                vein.setCol(number);
                vein.setMaxCol(number);
                vein.setType(Type.OIL);
                vein.setOldMineral(true);
                vein.setMeta(meta);
            } else {
                vein.setType(Type.EMPTY);
                vein.setCol(0);
                vein.setMaxCol(0);
            }
        }
    }

    static {
        EMPTY = new Vein(Type.EMPTY, 0, new ChunkPos(999999999, 999999999));
    }
}

